<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="toolCenterTable" scope="request"
	     type="oracle.sysman.emx.ui.ToolCenterTableBean"/>
<jsp:useBean id="groupsTable" scope="request"
	     type="oracle.sysman.emx.ui.GroupsTableBean"/>
<jsp:useBean id="toolCenter" scope="request"
	     type="oracle.sysman.emx.ui.ToolCenterBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>
  <uix:bundle name="sdkUIMsg"
	      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>
      <uix:pageLayout>
	<%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>
        <uix:start>
	  <%@ include file="../metrics/template/adminSideNav.jspf"%>
        </uix:start>

	<uix:form name="mpTableForm">
	  <uix:stackLayout>

	    <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
	      <uix:case name="errNode">
		<uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
				messageBinding="errorMessage@errData@servletRequest"/>
	      </uix:case>
	    </uix:switcher>
	    <oem:messageBox messageType="error"
			    errorTableBinding="errors@servletRequest"
			    titleTextKey="titleText"
			    mainTextKey="mainText"/>
	    <uix:spacer width="5"/>
	    <uix:header textBinding="TOOL_CENTER_TITLE@mpBundle">
	      <uix:stackLayout>
		<uix:tableLayout width="100%">
		  <uix:rowLayout>
		    <uix:cellFormat width="60%" hAlign="left" 
				    wrappingDisabled="false" vAlign="top">
		      <uix:styledText styleClass="OraInstructionText"
				      textBinding="TC_SUMMARY@mpBundle"/>
		    </uix:cellFormat>
		    <uix:cellFormat>
		      
		      <spacer width="10"/>
		    </uix:cellFormat>
		    <uix:cellFormat hAlign="right" wrappingDisabled="true"
				    vAlign="top">
		      <uix:styledText styleClass="OraTipText"
				      textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
		      <uix:spacer width="4"/>
		      <uix:styledText styleClass="OraTipLabel"
				      textBinding="timestamp@toolCenter@servletRequest"/>
		      <uix:spacer width="4"/>
		      <uix:image sourceBinding="refreshIcon@servletRequest"
				 destination="home?event=refreshTable"
				 shortDescBinding="REFRESH_DATA@mpBundle"/>
		    </uix:cellFormat>

		  </uix:rowLayout>
		</uix:tableLayout>

		<uix:tableLayout width="100%">
		  <uix:rowLayout>
		    <uix:cellFormat width="100%" hAlign="right" vAlign="top">
                      <uix:submitButton textBinding="EXPORT@mpBundle"
                            name="event"
                            value="export" formName="mpTableForm"
                            shortDescBinding="EXPORT_MPS@mpBundle"/>
		      <uix:button textBinding="IMPORT@mpBundle"
				  destination="import"
				  shortDescBinding="IMPORT_TITLE@mpBundle"/>
		    </uix:cellFormat>
		  </uix:rowLayout>
		</uix:tableLayout>

		<uix:spacer height="10"/>
		<uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
		<uix:spacer height="10"/>

		<uix:switcher childNameBinding="showTableTip@toolCenterTable@servletRequest">
		  <uix:case name="yes">
		    <uix:tip>
		      <uix:styledText styleClass="OraTipText"
				      textBinding="tableTip@toolCenterTable@servletRequest"/>
		    </uix:tip>
		  </uix:case>
		</uix:switcher>

		<oem:table name="mpTable"
			   summaryBinding="TOOLCENTER_TABLE_SUMMARY@mpBundle"
			   width="100%"
			   blockSizeBinding="blockSize@toolCenterTable@servletRequest"
			   showAll="yes"
			   id="mpTable"
			   formSubmitted="true"
			   valueBinding="value@toolCenterTable@servletRequest"
			   minValueBinding="minValue@toolCenterTable@servletRequest"
			   maxValueBinding="maxValue@toolCenterTable@servletRequest"
			   dataSourceProp="tableData"
			   beanKey="toolCenterTable">
		  <uix:tableSelection>
		    <uix:multipleSelection disabledBinding="disabled@toolCenterTable@servletRequest"
                                           selectedBinding="selected"
					   selectionBinding="selection@toolCenterTable@servletRequest">
		      <uix:pageButtonBar>
			<uix:submitButton textBinding="DELETE@mpBundle"
					  name="event" value="delete"
					  shortDescBinding="DELETE_MPS@mpBundle"/>
			<uix:submitButton textBinding="CREATE@mpBundle"
					  name="event" value="create"
					  shortDescBinding="CREATE_GROUP_TT@mpBundle"/>
		      </uix:pageButtonBar>
		    </uix:multipleSelection>
		  </uix:tableSelection>
		</oem:table>

		<uix:spacer height="10"/>

		<uix:header textBinding="GROUPS_TABLE_TITLE@mpBundle"/>
                <uix:styledText styleClass="OraInstructionText"
		                textBinding="GROUPS_TABLE_INSTRUCTION_SUMMARY@mpBundle"/>
		<uix:spacer height="10"/>
		<oem:table name="groupsTable"
			   summaryBinding="GROUPS@mpBundle"
			   width="100%"
			   blockSizeBinding="blockSize@groupsTable@servletRequest"
			   showAll="yes"
			   id="groupsTable"
			   formSubmitted="true"
			   valueBinding="value@groupsTable@servletRequest"
			   minValueBinding="minValue@groupsTable@servletRequest"
			   maxValueBinding="maxValue@groupsTable@servletRequest"
			   dataSourceProp="tableData"
			   beanKey="groupsTable">
		  <uix:tableSelection>
		    <uix:multipleSelection disabledBinding="disabled@groupsTable@servletRequest"
                                           selectedBinding="selected"
					   selectionBinding="selection@groupsTable@servletRequest">
		      <uix:pageButtonBar>
			<uix:submitButton textBinding="DELETE@mpBundle"
					  name="event" value="deleteGroup"
					  shortDescBinding="DELETE_GROUPS@mpBundle"/>
		      </uix:pageButtonBar>
		    </uix:multipleSelection>
		  </uix:tableSelection>
		</oem:table>
                <uix:tip>
                  <uix:styledText styleClass="OraTipText"
                                  textBinding="EXPORT_BUTTON_USAGE@mpBundle"/>
                </uix:tip>
		<oem:relatedLinks />
	      </uix:stackLayout>
	    </uix:header>
	  </uix:stackLayout>
	</uix:form>
      </uix:pageLayout>

    </uix:body>
  </uix:document>
</uix:renderingContext>
