<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="undeployBean" scope="request"
             type="oracle.sysman.emx.ui.UndeployBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@undeployBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@mpBundle" name="event"
                            value="cancel" formName="undeployTable"
                            shortDescBinding="CANCEL@mpBundle"/>
          <uix:submitButton textBinding="OK@mpBundle" name="event"
                            value="doUndeploy" formName="undeployTable"
                            shortDescBinding="UNDEPLOY_TITLE@mpBundle"/>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>
	 <uix:switcher childNameBinding="isGroupDeploy@undeployBean@servletRequest">
          <uix:case name="false">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="type@undeployBean@servletRequest"/>
            <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="version@undeployBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="true">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="groupName@undeployBean@servletRequest"/>
            <uix:messagePrompt promptBinding="APPLICABLE_GROUP_MEMBERS@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="applicableMembers@undeployBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
	 </uix:switcher>
        </uix:pageStatus>

	<uix:messages>
	 <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
          <uix:case name="errNode">
           <uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
                           messageBinding="errorMessage@errData@servletRequest"/>
          </uix:case>
         </uix:switcher>
	</uix:messages>

        <uix:spacer height="5"/>
        <uix:separator/>

        <uix:tableLayout width="100%">
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="UNDEPLOY_SUMMARY@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

        <uix:form name="undeployTable" method="POST">
         <uix:stackLayout>
          <uix:spacer height="10"/>
	   <uix:switcher childNameBinding="showTableTip@undeployBean@servletRequest">
	     <uix:case name="yes">
	       <uix:tip>
		 <uix:styledText styleClass="OraTipText"
				 textBinding="tableTip@undeployBean@servletRequest"/>
	       </uix:tip>
	     </uix:case>
	   </uix:switcher>
          <oem:table name="undeployTable"
		     summaryBinding="UNDEPLOY_TABLE_SUMMARY@mpBundle"
                     width="100%"
                     showAll="yes"
                     formSubmitted="true"
                     blockSizeBinding="blockSize@undeployBean@servletRequest"
                     valueBinding="value@undeployBean@servletRequest"
                     minValueBinding="minValue@undeployBean@servletRequest"
                     maxValueBinding="maxValue@undeployBean@servletRequest"
                     id="undeployTable"
                     dataSourceProp="tableData"
                     beanKey="undeployBean">
		      <uix:tableSelection>
			<uix:multipleSelection selectedBinding="selected"
					       selectionBinding="selection@undeployBean@servletRequest">
			</uix:multipleSelection>
		      </uix:tableSelection>
          </oem:table>
         </uix:stackLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
