<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--
  -- Page:        processing.jsp
  -- Controller:  oracle.sysman.emx.ui.DeployController
  --
  -- Description: Launched when user deploys or undeploys an MP
  --
  --  MODIFIED    (MM/DD/YY)
  --     caroy     02/24/05 - name cutover 
  --     caroy     02/03/05 - caroy_add_processing_page
  --%>

<jsp:useBean id="undeployBean" scope="request"
             type="oracle.sysman.emx.ui.UndeployBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="undeployProcessing">
  
          <uix:pageLayout>
           <%@ include file="/oemGlobal.jspf" %>
           <%@ include file="../health/header.jsp"%>
           <%@ include file="/setRefreshRate.jspf" %>
  
           <uix:header textBinding="UNDEPLOY_PROCESSING_TITLE@mpBundle"
             	icon="/em/images/processl.gif">
  
             <uix:tableLayout width="100%" hAlign="center">
  
               <uix:rowLayout>
                 <uix:cellFormat hAlign="left">
                   <uix:styledText
                     styleClass="OraInstructionText"
                     text=""
                   />
                 </uix:cellFormat>
               </uix:rowLayout>
  
               <uix:rowLayout>
                 <uix:spacer height="20" width="0"/>
               </uix:rowLayout>
  
               <uix:rowLayout hAlign="center">
                 <uix:cellFormat hAlign="center">
                   <uix:stackLayout>
                     <uix:contents>
                       <uix:processing
                         percentCompleteBinding="percentDone@undeployBean@servletRequest"
                         timeInterval="<%=processingPageInterval%>">
                        <uix:contents>
                         <uix:styledText 
                           styleClass="OraProcessingStatusVariable"
                           textBinding="processingText@undeployBean@servletRequest"
                         />
                        </uix:contents>
                       </uix:processing>
                     </uix:contents>
                   </uix:stackLayout>
                 </uix:cellFormat>
               </uix:rowLayout>
  
               <uix:rowLayout>
                 <uix:spacer height="10" width="0"/>
               </uix:rowLayout>
               <uix:rowLayout>
                 <uix:cellFormat>
                   <uix:tip>
                     <uix:text textBinding="UNDEPLOY_PROCESSING_TIP@mpBundle"/>
                   </uix:tip>
                 </uix:cellFormat>
               </uix:rowLayout>
  
             </uix:tableLayout>
           </uix:header>
  
          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

