<%--
  - FILE
  -   esa.jsp
  -
  - DESCRIPTION
  -   ESA home page
  -
  - MODIFIED  (MM/DD/YY)
  -   rmadampa  06/22/06 - fix bug 5162364 - default Last 31 days 
  -   rmadampa  07/30/06 - Backport rmadampa_bug-5162364 from main
  -   hmodawel  02/27/06 - fix ojsp 1013 compilation errors 
  -   rmadampa  11/11/05 - fix bug 4625338 
  -   rmadampa  08/25/05 - remove frameBorderLayout:bug 4493397 
  -   rmadampa  07/31/05 - fix bug 4371780: NLS 
  -   rmadampa  06/17/05 - chart xaxis grbled bug4284887 fix 
  -   rmadampa  06/17/05 - ADA input focus bug4428896 fix 
  -   rmadampa  06/14/05 - fix ADA bugs 
  -   dkjain    05/01/05 - Fixed bug-4340956 
  -   rmadampa  11/21/04 - Remove related links 
  -   rmadampa  10/07/04 - added timestamp
  -   rmadampa  09/11/04 - created
  -
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
	<oem:setURLEncoder id="renderingContext"/>
	  <%--Common UI messages --%>
	  <uix:bundle name="sdkUIMsg" 
				  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
	  <%--ResourceBundle for common labels/headers etc--%>
      <uix:bundle name="commonResourceBundle"
				  class="oracle.sysman.resources.CommonResourceBundle"/>
	  <%--ResourceBundle for labels/headers specific to ESA Project--%>
	  <uix:bundle name="esaResourceBundle"
				  class="oracle.sysman.resources.eml.esa.EsaMsg"/>
	  <uix:bundle name="patchResourceBundle"
				  class="oracle.sysman.eml.ecm.patch.util.PatchResourceBundle"/>
    <uix:dataScope>
        <uix:document>
		<%@ include file="/oemTitle.jspf" %>
		<uix:body>
			<uix:form name="secGlance" method="POST">
				<uix:pageLayout titleBinding="SECURITY_AT_A_GLANCE@esaResourceBundle">
					<%@ include file="/enablePPR.jspf" %>
					<%@ include file="/oemGlobal.jspf" %>
						<uix:flowLayout>
							<uix:rowLayout hAlign="right">
									<uix:styledText 
										styleClass="OraTipText" 
										textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
									<uix:spacer width="4" />
									<uix:styledText 
                                        id="pgRefreshId"
										styleClass="OraTipLabel" 
										textBinding="timestamp@EsaViolationBean@servletRequest"/>
                                    <uix:spacer width="10"/>
											<uix:styledText styleClass="OraFieldText"
															textBinding="SEC_VIOL_SINCE_LBL@esaResourceBundle"
                                                            labeledNodeId="sinceChoiceId"/>
											<uix:spacer width="10"/>
												<uix:choice 
                                                    id="sinceChoiceId"
													name="sinceChoice" 
                                                                                                        selectedIndexBinding="sinceChoiceIdx@servletRequest"
                                                    primaryClientActionBinding="onChangeDroplist@servletRequest">
													<!--onChange="submitForm('secGlance', true, {event:'viewData'})">-->
													<uix:contents childDataBinding="EsaViolSinceData@servletRequest">
														<uix:option textBinding="item" valueBinding="value"/>
													</uix:contents>
												</uix:choice>


							</uix:rowLayout>
							<uix:spacer width="25" />
							<uix:contentContainer background="light" width="100%">

										<uix:flowLayout>
													<uix:tableLayout  width="100%">
														<uix:rowLayout>
															<uix:cellFormat>
																<uix:header textBinding="FILTER_BY_HDR@esaResourceBundle">
																<uix:tableLayout   cellSpacing="4">
																	<uix:rowLayout>
																		<uix:cellFormat width="50%">
																			<uix:tableLayout>
																				<uix:rowLayout>
																					<uix:cellFormat hAlign="right">
																						<uix:styledText 	styleClass="OraFieldText"
																							textBinding="TGT_GRP_LBL@esaResourceBundle"
                                                                                            labeledNodeId="groupsListId"/>
																					</uix:cellFormat>
																		 
																					<uix:cellFormat width="15">
																					</uix:cellFormat>

																					<uix:cellFormat hAlign="left">
																						<uix:messageChoice 
                                                                                            id="groupsListId"
																							name="groupsList" 	
																							selectedValueBinding="groupsList@servletRequest">
																					
																							<uix:contents childDataBinding="targetGroupList@EsaTargetGroupBean@servletRequest">
																								<uix:option textBinding="display_name" valueBinding="target_guid"/>
																							</uix:contents>
																						</uix:messageChoice>
																					</uix:cellFormat>
																				</uix:rowLayout>
																			</uix:tableLayout>
																		</uix:cellFormat>
																	
																		<uix:cellFormat width="50%">
																		<uix:inlineMessage
																		  messageTypeBinding="messageType@servletRequest"
																		  messageBinding="message@servletRequest">
																			<uix:tableLayout>
																				<uix:rowLayout>
																				  <uix:cellFormat 
																					hAlign="right"
																					wrappingDisabled="false">
																				
																						<uix:messageStyledText 
																							styleClass="OraFieldText"
																							textBinding="SEVERITY_LBL@esaResourceBundle">
																						</uix:messageStyledText>
																				  </uix:cellFormat>
																				  <uix:cellFormat width="15">
																				  </uix:cellFormat>
																				  <uix:cellFormat hAlign="left">
																					<uix:rowLayout>
																						<uix:cellFormat>
																							<uix:messageCheckBox name="mcbCrit" textBinding="SEVERITY_CRIT_LBL@esaResourceBundle" selectedValueBinding="mcbCrit@servletRequest"/>
																						</uix:cellFormat>
																						<uix:spacer width="5" />
																						<uix:cellFormat>
																							<uix:messageCheckBox name="mcbWarn" textBinding="SEVERITY_WARN_LBL@esaResourceBundle" selectedValueBinding="mcbWarn@servletRequest"/>
																						</uix:cellFormat>
																						<uix:spacer width="5" />
																						<uix:cellFormat>
																							<uix:messageCheckBox name="mcbInfo" textBinding="SEVERITY_INFO_LBL@esaResourceBundle" selectedValueBinding="mcbInfo@servletRequest"/>
																						</uix:cellFormat>
																						<uix:cellFormat>
																						</uix:cellFormat>
																						<uix:cellFormat width="15">
																						</uix:cellFormat>
																						<uix:cellFormat hAlign="left">
																							<uix:submitButton textBinding="GO@commonResourceBundle" name="event" value="filter" formName="secGlance"/>
																						</uix:cellFormat>
																					</uix:rowLayout>
																				  </uix:cellFormat>
																				</uix:rowLayout>
																			</uix:tableLayout>
																			</uix:inlineMessage>
																		</uix:cellFormat>
																	</uix:rowLayout>
																  </uix:tableLayout>
																</uix:header>
															</uix:cellFormat>
														</uix:rowLayout>
													</uix:tableLayout>
										</uix:flowLayout>

										<uix:separator/>

										<uix:flowLayout>
											<uix:tableLayout   width="100%">
												<uix:rowLayout id="chartRowLytId" vAlign="top">
													<uix:cellFormat>
														<uix:header textBinding="VIOL_FLUX_HDR@esaResourceBundle">
															<uix:flowLayout>
																<!--Start-->
																<uix:tableLayout width="100%">
																  <uix:rowLayout vAlign="top">
																	<oem:chart 
                                                                         id="tscViolFluxId"
																		 chartType="timeSeriesChart"
																		 width="450"
																		 height="200" 
																		 orientation="vertical"
																		 seriesSymbolsAutomatic="true"
																		 seriesColorsAutomatic="true"
																		 shortDescBinding="VIOL_FLUX_SHRT_DESC@esaResourceBundle"
																		 yAxisLabelBinding="VIOL_FLUX_GRAPH_LABEL@esaResourceBundle"

																		 timeLabelAlignment="wholeXAxis"
																		 xAxisMinBinding="violFluxXAxisMin@EsaViolationBean@servletRequest"
																		 xAxisMaxBinding="violFluxXAxisMax@EsaViolationBean@servletRequest"
																		 stacked="true"
																		 fill="cumulative"
																		 
																		 >
																	  <uix:contents>
																		<oem:boundChartDataSource 
																			  chartDataSourceBinding="violationFlux@EsaViolationBean@servletRequest"
																			  />
																		<oem:chartColumn
																			isTimeColumn="true"
																			displayLabel="Time"
																			sourceIndex="0"
																		  />
																		<oem:chartColumn                                   
																			displayLabelBinding="FIXED_LBL@esaResourceBundle"
																			sourceIndex="2"
																		  />
																		<oem:chartColumn                                   
																			displayLabelBinding="NEW_LBL@esaResourceBundle"
																			sourceIndex="1"
																		  />

																	  </uix:contents>
																	</oem:chart>
																  </uix:rowLayout>
																</uix:tableLayout>
																<!--End-->
															</uix:flowLayout>
															<!--uix:image source="violationFlux.gif"/-->
														</uix:header>
													</uix:cellFormat>                                        

													<uix:cellFormat>
														<uix:header textBinding="COMPL_SCORE_HDR@esaResourceBundle">
															<uix:flowLayout>
																<!--Start-->
																<uix:tableLayout width="100%">
																  <uix:rowLayout vAlign="top">
																		<oem:chart
                                                                             id="tscCompScoreId"
																			 chartType="timeSeriesChart"
																			 width="450"
																			 height="200" 
																			 orientation="vertical"
																			 legendVisible="false"
																			 seriesSymbolsAutomatic="true"
																			 seriesColorsAutomatic="true"
																			 shortDescBinding="COMPL_SCORE_SHRT_DESC@esaResourceBundle"

																			 timeLabelAlignment="wholeXAxis"
																		 xAxisMinBinding="compScoreXAxisMin@EsaViolationBean@servletRequest"
																		 	 xAxisMaxBinding="compScoreXAxisMax@EsaViolationBean@servletRequest"
																			 >
																		  <uix:contents>
																			<oem:boundChartDataSource 
																				  chartDataSourceBinding="violationScore@EsaViolationBean@servletRequest"
																				  />

																			<oem:chartColumn
																				isTimeColumn="true"
																				sourceIndex="0"
																			  />
																			<oem:chartColumn                                   
																				sourceIndex="1"
																			  />

																		  </uix:contents>
																		</oem:chart>

																  </uix:rowLayout>
																</uix:tableLayout>
																<!--End-->
															</uix:flowLayout>
															<!--uix:image source="violationScore.gif"/-->
														</uix:header>
													</uix:cellFormat>
												</uix:rowLayout>
			<%--
			  - This table uses partial renderring mode. So id attribute is must. Also
			  - partial renderring requires "/enablePPR.jspf" to be included
			--%>
												<uix:rowLayout vAlign="top">
													<uix:cellFormat hAlign="left" columnSpan="2">
														<uix:header textBinding="VIOL_SUMM_BY_SEVERITY_HDR@esaResourceBundle">
															<uix:flowLayout>
																<!--Start-->
																<uix:tableLayout  width="100%">
																	<uix:rowLayout vAlign="top">
																		<uix:table 
																				 id="violSummBySeverity"
																				 name="violSummBySeverity" 
                                                                                 summaryBinding="VIOL_SUMM_BY_SEVERITY_HDR@esaResourceBundle"
																				 alternateTextBinding="NO_VIOLATIONS_FOUND@esaResourceBundle"
																				 formSubmitted="true"
																				 width="100%"
																				 tableDataBinding="rows@EsaSevViolationBean@servletRequest"
																				 minValueBinding="minValue@EsaSevViolationBean@servletRequest"
																				 valueBinding="currentValue@EsaSevViolationBean@servletRequest"
																				 maxValueBinding="maxValue@EsaSevViolationBean@servletRequest"
																				 blockSizeBinding="blockSize@EsaSevViolationBean@servletRequest"
																				 partialRenderMode="self">
																			   
																	   
																			<uix:tableFormat tableBanding="rowBanding"/>

																			<%-- Severity column --%>                
																			<uix:column> 
																				<uix:columnHeader>
																				<uix:styledText textBinding="LBL_SEVERITY@esaResourceBundle" />                       
																			</uix:columnHeader> 
																			<uix:columnFormat columnDataFormat="iconButtonFormat"/>                                  
																			<uix:image 
																				hAlign="center" sourceBinding="sev_img_dest" 
																				textBinding="severity"/>
																			</uix:column>                                   
																			
																			<%-- Violation count column --%>
																			<uix:column> 
																			  <uix:columnHeader>
																				  <uix:styledText textBinding="LBL_VIOLATIONCOUNT@esaResourceBundle" />                                           
																			  </uix:columnHeader>                   
																			  <uix:columnFormat columnDataFormat="numberFormat"/>                  
																			  <uix:link textBinding="viol_cnt"
																						destinationBinding="viol_cnt_dest" />

																			</uix:column>
																			
																			<%-- Last 'x' days data --%>
																			<uix:columnGroup>  
																				<uix:columnHeader>                        
																					<uix:styledText textBinding="timePeriodHeader@servletRequest"/>
																				 </uix:columnHeader>
																				

																				  <%-- Cleared violations count column  --%>
																				  <uix:column>
																					<uix:columnHeader>
																					   <uix:styledText textBinding="LBL_CLEARED@esaResourceBundle" />                                                                                 
																					</uix:columnHeader>           
																					<uix:columnFormat columnDataFormat="numberFormat"/>
																					<uix:styledText textBinding="cleared"/>
																				  </uix:column>
																							   
																				  <%-- New violations column  --%>
																				  <uix:column>
																					<uix:columnHeader>
																					  <uix:styledText textBinding="LBL_NEW@esaResourceBundle" />                                                                                                                                                  
																					</uix:columnHeader>                                           
																					<uix:columnFormat columnDataFormat="numberFormat"/>
																					<uix:styledText textBinding="new"/>
																				  </uix:column>  

																			</uix:columnGroup>  
																			<uix:column> 
																				<uix:columnHeader>
																					<uix:styledText textBinding="LBL_POLICY_VIOLATED@esaResourceBundle"/>
																				</uix:columnHeader> 
																				<uix:columnFormat columnDataFormat="numberFormat"/>                  
																				<uix:link textBinding="policies_viol"
																						destinationBinding="viol_cnt_dest" />                  
																			</uix:column>    
																		</uix:table>
																	</uix:rowLayout>
																</uix:tableLayout>
																<!--End-->
															</uix:flowLayout>
														</uix:header>
													</uix:cellFormat>
												</uix:rowLayout>					
												
												<uix:rowLayout vAlign="top">
													<uix:cellFormat hAlign="left" columnSpan="2">
														<uix:header textBinding="violTargetsHdr@servletRequest">
															<uix:flowLayout>
																<!--Start-->
																<uix:tableLayout width="100%">
																	<uix:rowLayout vAlign="top">
																		<uix:table 
																				 id="tgtViolSumm"
																				 name="tgtViolSumm" 
                                                                                 partialRenderMode="self"
                                                                                 summaryBinding="violTargetsHdr@servletRequest"
																				 alternateTextBinding="NO_VIOLATIONS_FOUND@esaResourceBundle"
																				 formSubmitted="true"
																				 width="100%"
																				 minValueBinding="minValue@EsaTgtViolationBean@servletRequest" tableDataBinding="rows@EsaTgtViolationBean@servletRequest"
																				  
																				 valueBinding="currentValue@EsaTgtViolationBean@servletRequest" 
																				 maxValueBinding="maxValue@EsaTgtViolationBean@servletRequest"
																				 blockSizeBinding="defaultBlockSize@EsaTgtViolationBean@servletRequest"  
																				 columnHeaderDataBinding="columnHeaders@EsaTgtViolationBean@servletRequest"
                                                                                 showAll="yes">
																			   
																	   
																			<uix:tableFormat tableBanding="rowBanding"/>

                                                                                <uix:columnHeaderStamp>
                                                                                 <uix:sortableHeader
                                                                                  textBinding="text"
                                                                                  sortableBinding="sortable">
                                                                                 </uix:sortableHeader>
                                                                                </uix:columnHeaderStamp>
																			<%-- Target Name column --%>                
																				<uix:column> 
																				<uix:columnFormat columnDataFormat="textFormat"/>                                      
																				<uix:link textBinding="name"
																						destinationBinding="target_dest" />
																				</uix:column>
																			
																			<%-- Target type column --%>
																			<uix:column> 
																				<uix:columnFormat columnDataFormat="textFormat"/>                  
																				<uix:styledText textBinding="type_disp" />                    
																			 </uix:column>																			
																			
																			<%-- Violation count column --%>
																			<uix:column> 
																			  <uix:columnFormat columnDataFormat="numberFormat"/>
																			  <uix:link textBinding="viol_cnt"
																						destinationBinding="viol_cnt_dest" />
																			</uix:column>
																			
																			<%-- Last 'x' days data --%>
																			<uix:columnGroup> 
                                                                                <uix:columnHeader>
																					  <uix:styledText textBinding="timePeriodHeader@servletRequest" />            
																			    </uix:columnHeader>
																				<uix:contents>                  
																		   
																				  <%-- Cleared violations count column  --%>
																				  <uix:column>
																					<uix:columnFormat columnDataFormat="numberFormat"/>
																					<uix:styledText textBinding="cleared"/>
																				  </uix:column>
																							   
																				  <%-- New violations column  --%>
																				  <uix:column>
																					<uix:columnFormat columnDataFormat="numberFormat"/>
																					<uix:styledText textBinding="new"/>
																				  </uix:column>  
																		  </uix:contents>
																		  </uix:columnGroup>  
                                                                            <uix:column> 
																			  <uix:columnHeader>
																				<uix:sortableHeader textBinding="LBL_POLICY_VIOLATED@esaResourceBundle" sortable="true" value="5"/>
																			  </uix:columnHeader> 
																			  <uix:columnFormat columnDataFormat="numberFormat"/>                  
																			  <uix:styledText textBinding="policies_viol" destinationBinding="viol_cnt_dest"/>                  
																			</uix:column>
																			
																		</uix:table>
																	</uix:rowLayout>
																</uix:tableLayout>
																<!--End-->
															</uix:flowLayout>
														</uix:header>
													</uix:cellFormat>
											  </uix:rowLayout>
											</uix:tableLayout>
										</uix:flowLayout>

								</uix:contentContainer>
								<uix:spacer width="10"/>
								<uix:contentContainer background="light" width="100%">
									<uix:header textBinding="CRIT_SEC_PATCH_ADV_HDR@esaResourceBundle">
										<uix:table 
										  name="patch_advisories"
										  id="patch_advisories_id"
										  width="100%"
										  partialRenderMode="self"
                                          summaryBinding="CRIT_SEC_PATCH_ADV_HDR@esaResourceBundle"
										  showAll="yes"
										  valueBinding="currentValue@cpfDefaultBean@servletRequest"
										  minValueBinding="minValue@cpfDefaultBean@servletRequest"
										  blockSizeBinding="blockSize@cpfDefaultBean@servletRequest"
										  maxValueBinding="maxValue@cpfDefaultBean@servletRequest" 
										  alternateTextBinding="NO_ADVISORIES_FOUND@patchResourceBundle"
										  tableDataBinding="rows@cpfDefaultBean@servletRequest"
										  columnHeaderDataBinding="columnHeaders@cpfDefaultBean@servletRequest">
										   
										  <uix:tableFormat tableBanding="rowBanding"/>
										  <uix:columnHeaderStamp>
											<uix:sortableHeader 
												textBinding="text"
												sortableBinding="sortable">
											</uix:sortableHeader>
										  </uix:columnHeaderStamp>

										 <uix:tableSelection>
										  <uix:singleSelection selectedIndexBinding="index@cpfDefaultBean@servletRequest">
										   <uix:submitButton name="event" formName="secGlance"
														textBinding="LBL_SHOW_REMEDIES@patchResourceBundle"
														value="showRemediesForAlert"/>
										  </uix:singleSelection>
										 </uix:tableSelection>

										  <uix:column>
											 <uix:contents>
												<uix:styledText textBinding="advisory" destinationBinding="advisoryLink"/>
												<uix:formValue name="rowKey" valueBinding="rowKey"/>
											 </uix:contents>
										  </uix:column>

										  <uix:styledText textBinding="impact"/>

										  <uix:styledText textBinding="abstract"/>
										  
										  <uix:column>
										   <uix:contents>
											<uix:columnFormat 
											  cellNoWrapFormat="true"
											  columnDataFormat="numberFormat" />
											<uix:styledText 
											  textBinding="hosts"/>
										   </uix:contents>
										  </uix:column>

										  <uix:column>
										   <uix:contents>
											<uix:columnFormat 
											  cellNoWrapFormat="true"
											  columnDataFormat="numberFormat" />
											<uix:styledText 
											  textBinding="homes"/>
										   </uix:contents>
										  </uix:column>
										   
										</uix:table>
									</uix:header>
								</uix:contentContainer>

                            </uix:flowLayout>
					</uix:pageLayout>
                </uix:form>
            </uix:body>
        </uix:document>
</uix:dataScope>
</uix:renderingContext>

