<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       esaPropJobParam.jsp
 *
 *      NOTES
 *      Custom jsp for Security Policy Configuration job parameters page.
 *
 * MODIFIED
 *    dkjain     06/23/05  - dkjain_security_prop_job
 *    dkjain     06/17/05  - Created
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
<uix:dataScope>
 <uix:bundle name="esaResourceBundle" class="oracle.sysman.resources.eml.esa.EsaMsg"/>
    <uix:switcher childNameBinding="parametersAvailable@parametersViewBean@">
		<uix:case name="true">
		<uix:tableLayout cellSpacing="25">
           <uix:cellFormat vAlign="top" width="50%">
			<uix:labeledFieldLayout width="0" 
                                  labelWidth="0" fieldWidth="0" > 
            

             <uix:messageChoice  name="policy_name" 
                                 promptBinding = "SEC_POL_LBL@esaResourceBundle" 
                                 selectedValueBinding="policy_name@"
                                 disabledBinding="readOnly@parametersViewBean@"
                                 renderedBinding ="showPolicies@">
              <uix:contents childDataBinding="policyList@esaPolicyListJobBean@">
                 <uix:option textBinding="text" valueBinding="value" />
              </uix:contents>
            </uix:messageChoice>
  
           <uix:messageTextInput  nameBinding="name@max_count@paramMap@parametersViewBean@" 
                                  promptBinding="label@max_count@paramMap@parametersViewBean@" 
                                  columns="35" 
                                  rowsBinding="numlines@attribute@max_count@paramMap@parametersViewBean@"
                                  textBinding="value@max_count@paramMap@parametersViewBean@" 
                                  required="uiOnly" 
                                  secretBinding="password@max_count@paramMap@parametersViewBean@" 
                                  tipBinding="hint@max_count@paramMap@parametersViewBean@" 
                                  messageBinding="inlineMessage@max_count@paramMap@parametersViewBean@" 
                                  messageTypeBinding="inlineMessageType@max_count@paramMap@parametersViewBean@" 
                                  anchorBinding="name@max_count@paramMap@parametersViewBean@"
                                  disabledBinding="readOnly@parametersViewBean@"
                                  renderedBinding="showPolicies@"/>
           <uix:messageBox messageBinding="NO_POL_INFO_MSG@esaResourceBundle" messageType="info" 
           renderedBinding="showNoPolicies">
           </uix:messageBox>
             
           </uix:labeledFieldLayout>
		</uix:cellFormat>
	  </uix:tableLayout>
    </uix:case>
 </uix:switcher>
</uix:dataScope>
</oem:pageSegment>

