<%--

/* $Header: formsApacheLogin.jsp 12-sep-2006.14:34:44 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     End User Monitoring Apache Configuration Login Page For Forms.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie    09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie      09/11/06 - Fix bug 5521573
      yxie      03/30/06 - Creation.
*/

/**
 *  @version $Header: formsApacheLogin.jsp 12-sep-2006.14:34:44 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>

<uix:renderingContext id="renderingContext">
<oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>
        <uix:dataScope currentDataBinding="formsApacheConfigData@servletRequest" >
          <uix:form name="ApacheLogin" method="post" destinationBinding="apacheLoginURL">
    <uix:pageLayout>  
        <%@ include file="/oemGlobal.jspf"%>
              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:submitButton name="event" value="cancelLogin" textBinding="CANCEL@cmnMsg" />
                  <uix:submitButton name="event" value="login" textBinding="CONTINUE@cmnMsg" />
                </uix:pageButtonBar>
              </uix:contentFooter>
                  <uix:switcher childNameBinding="loginWarning">
                    <uix:case name="<%=Boolean.TRUE%>">
                      <uix:switcher childNameBinding="hasError">
                        <uix:case name="<%=Boolean.TRUE%>">
                          <uix:messageBox messageBinding="APACHE_CONFIG_LOGIN_WARNING@webappMsg" messageType="error">
                            <uix:contents>
                              <uix:styledText textBinding="errorMsg" /> 
                            </uix:contents>
                          </uix:messageBox>
                        </uix:case>
                        <uix:default>
                          <uix:messageBox messageBinding="APACHE_CONFIG_LOGIN_WARNING@webappMsg" messageType="error"/>
                        </uix:default>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
            <spacer height="10"/>
            <uix:header textBinding="configFormsApacheLoginHeader">
              <uix:contents>

                <uix:tableLayout width="100%">
                 <uix:contents>
              <uix:rowLayout hAlign="right" width="100%">

                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText" 
                                textBinding="APACHE_CONFIG_LOGIN_MSG@webappMsg"/>
                </uix:cellFormat>

                <uix:spacer width="5"/>

                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:submitButton name="event" value="cancelLogin" textBinding="CANCEL@cmnMsg" />
                  <uix:spacer width="10"/>
                  <uix:submitButton name="event" value="login" textBinding="CONTINUE@cmnMsg" />
                </uix:cellFormat>

              </uix:rowLayout>

              <uix:rowLayout width="100%">
                <uix:stackLayout>
                  <uix:spacer height="10"/>
                </uix:stackLayout>
              </uix:rowLayout>

                  <uix:rowLayout hAlign="center">
                    <uix:contents>
                      <uix:tableLayout hAlign="center" cellSpacing="2">
                        <uix:contents>
                            <uix:messageStyledText promptBinding="HOST_VALUE_LABEL@webappMsg" 
                                            textBinding="host" 
                                            styleClass="oraDataText"/>
                          <uix:rowLayout>
                            <uix:stackLayout>
                              <uix:spacer height="4"/>
                            </uix:stackLayout>
                          </uix:rowLayout>
                          <uix:messageTextInput name="username" promptBinding="USERNAME_HDR@webappMsg" textBinding="userName" noAutoComplete="true"/>
                          <uix:messageTextInput name="password" promptBinding="PASSWORD_HDR@webappMsg" secret="true" noAutoComplete="true"/>
            
                        </uix:contents>
                      </uix:tableLayout>        
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:contents>
                </uix:tableLayout>            


              </uix:contents>
            </uix:header> 

      </uix:pageLayout>
          <uix:formValue
                  name="<%=WebappConstants.APACHE_NAME%>"
                  valueBinding="apacheName"/>
          <uix:formValue
                  name="<%=WebappConstants.APACHE_TYPE%>"
                  valueBinding="apacheType"/>
                </uix:form>
        </uix:dataScope>
    </uix:body>

  </uix:document>
</uix:renderingContext>
