<%--

/* $Header: formsApacheRestart.jsp 12-sep-2006.14:34:44 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     End User Monitoring Apache Configuration Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie   09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie   04/20/05 - Fix bug 5521573
      yxie   04/07/05 - add standalone apache
      yxie   03/09/05 - change warning message box to warning page title
      yxie   02/24/05 - yxie_apacheui_fix4
      yxie   02/10/05 - Creation
 */

/**
 *  @version $Header: formsApacheRestart.jsp 12-sep-2006.14:34:44 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
      <uix:dataScope currentDataBinding="formsApacheConfigData@servletRequest" >
        <uix:form name="ApacheRestart" method="post">
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>
            <%@ include file="/oemNoscript.jspf" %>

              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:submitButton name="event" value="cancelRestart" textBinding="CANCEL@cmnMsg"/>
                  <uix:submitButton name="event" value="restart" textBinding="CONTINUE@cmnMsg"/>
                </uix:pageButtonBar>
              </uix:contentFooter>

              <uix:switcher childNameBinding="hasError">
                <uix:case name="<%=Boolean.TRUE%>">
                  <uix:messageBox messageBinding="errorTypeMsg" messageType="error">
                    <uix:contents>
                      <uix:styledText textBinding="errorMsg" /> 
                    </uix:contents>
                  </uix:messageBox>
                </uix:case>
              </uix:switcher>

              <uix:header messageType="warning">
                <uix:styledText textBinding="confirmationMsg" styleClass="OraInstructionTextStrong" />
             </uix:header>
            </uix:pageLayout>   
          <uix:formValue
                  name="<%=WebappConstants.APACHE_NAME%>"
                  valueBinding="apacheName"/>
          <uix:formValue
                  name="<%=WebappConstants.APACHE_TYPE%>"
                  valueBinding="apacheType"/>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext> 
