<%--

/* $Header: formsConf.jsp 12-sep-2006.14:34:46 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Forms configuration page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie     09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie     08/04/06 - XbranchMerge yxie_formsapp_regression from main
      yxie      09/11/06 - Fix bug 5521573
      yxie      03/10/06 - Creation
 */

/**
 *  @version $Header: formsConf.jsp 12-sep-2006.14:34:46 yxie Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.formsapp.data.FormsConfigData'%>
<%@ page import='oracle.sysman.eml.formsapp.data.FormsSectionConfigData'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="gensvcMsg" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    
    <uix:body>

      <uix:pageLayout>

        <%@ include file="/oemGlobal.jspf" %>

        <uix:dataScope currentDataBinding="formsConfigData@servletRequest" >

		      <uix:switcher childNameBinding="formsConfigCompleted@servletRequest">
					  <uix:case name="true">
						  <uix:messageBox messageType="confirmation" messageBinding="FORMS_CONFIG_COMPLETED_MSG@formsappMsg"/>
						</uix:case>
					</uix:switcher>

          <uix:header textBinding="header@servletRequest" >
            <uix:form name="formsConfigForm" method="POST">

              <%-- Table --%>
              <uix:stackLayout>

                <uix:rowLayout hAlign="right">
                  <uix:styledText textBinding="PAGE_REFRESHED@mntrMsg"
                                  styleClass="OraTipText"/>
                  <uix:spacer width="5"/>
                  <uix:styledText textBinding="refreshTime"
                                  styleClass="OraTipLabel"/>
                  <uix:spacer width="5"/>
                  <uix:button textBinding="REFRESH@sdkMsg"
                              destinationBinding="reloadDest"/>
                  <uix:spacer width="5"/>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="25"/>
                </uix:rowLayout>

                <uix:rowLayout width="100%">
                  <uix:switcher childNameBinding="ifError">
                    <uix:case name="<%=Boolean.TRUE%>">
                      <uix:stackLayout>
                        <uix:messageBox messageBinding="error"
                                        messageType="error"/>
                        <uix:spacer height="10"/>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>

                <uix:rowLayout>

                  <uix:cellFormat vAlign="top">
                
                    <uix:tableLayout width="100%">

                      <uix:rowLayout>			
                        <uix:cellFormat width="100%">

                          <uix:header textBinding="FORMS_SERVER@formsappMsg">
                            <uix:spacer height="5"/>
                            <uix:table name="<%=FormsConfigData.TABLE_NAME%>"
                                       tableDataBinding="formsTableData"
                                       formSubmitted="<%=Boolean.TRUE%>"
                                       blockSizeBinding="formsBlockSize"
                                       valueBinding="formsTableValue"
                                       minValueBinding="formsMinValue"
                                       maxValueBinding="formsMaxValue"
                                       width="100%"
                                       summaryBinding="FORMS_SERVER@formsappMsg">
                              <uix:tableFormat tableBanding="rowBanding"/>

                              <uix:tableSelection>
			    	                    <uix:singleSelection selectedIndex="0" shortDescBinding="<%=FormsConfigData.TARGET%>" disabledBinding="<%=FormsConfigData.DISABLED_BIND%>">
                                  <uix:button textBinding="CONFIGURE@webappMsg" onClick="submitForm('formsConfigForm',true,{'event':'configure'})"/>
            					  	      </uix:singleSelection>
						  	              </uix:tableSelection>

                              <uix:column>
                                <uix:columnHeader>
                                  <uix:columnFormat columnDataFormat="textFormat" />
                                    <uix:sortableHeader textBinding="NAME_HDR@formsappMsg"
					  																			      sortableBinding="formsNameSortable"/>                        
                                </uix:columnHeader>
                                <uix:link textBinding="<%=FormsConfigData.TARGET%>"
                                          destinationBinding="<%=FormsConfigData.TARGET_LINK%>"/>
                              </uix:column>

                              <uix:column>
                                <uix:columnHeader>
                                  <uix:columnFormat columnDataFormat="textFormat" />
                                    <uix:sortableHeader textBinding="TYPE_HDR@formsappMsg"/>                        
                                </uix:columnHeader>
                                <uix:link textBinding="<%=FormsConfigData.TARGET_TYPE_DISP%>"/>
                              </uix:column>

                              <uix:column>
                                <uix:columnHeader>
                                  <uix:styledText textBinding="CURRENT_STATUS@formsappMsg"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="10"/>
                                <uix:rowLayout hAlign="center">
                                  <uix:image sourceBinding="<%=FormsConfigData.STATUS_ICON%>"
                                             shortDescBinding="<%=FormsConfigData.STATUS_DESC%>"/>
                                </uix:rowLayout>
                              </uix:column>
                            </uix:table>

                            <uix:spacer height="10"/>

                            <uix:rowLayout hAlign="left">
												  		<uix:styledText textBinding="RELATED_LINK@webappMsg" styleClass="OraDataText" />
                              <uix:spacer width="10" />
                              <uix:link textBinding="SYSTEM_CONFIGURATION@gensvcMsg"
                                        destinationBinding="systemConfigLink"/>
                            </uix:rowLayout>

                          </uix:header>

                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:tip>
                          <uix:contents>
                            <uix:styledText textBinding="configTip" />
                          </uix:contents> 
                        </uix:tip>  
                      </uix:rowLayout>
                          
											<uix:rowLayout>
	                	   	<uix:spacer height="10"/>
                      </uix:rowLayout>

                    </uix:tableLayout>
                  </uix:cellFormat>

                  <uix:spacer width="10"/>

                  <uix:cellFormat width="35%">
                    <uix:contentContainer width="100%"
                                          textBinding="instructHeader">
                      <uix:styledText styleClass="OraInstructionText" textBinding="instructLeadIn" />
                      <uix:bulletedList>
                        <uix:contents childDataBinding="configSteps">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="<%=FormsConfigData.LABEL%>"/>
                        </uix:contents>
                      </uix:bulletedList>
                    </uix:contentContainer/>
                  </uix:cellFormat>

                </uix:rowLayout>

            </uix:stackLayout>

            </uix:form>
          </uix:header>
        </uix:dataScope>

      </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>
