<%--

/* $Header: formsConfigConfirm.jsp 12-sep-2006.14:34:46 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Forms Configuration Confirmation Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie   09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie   08/04/06 - XbranchMerge yxie_formsapp_regression from main
      yxie      09/11/06 - Fix bug 5521573
      yxie      03/20/06 - Creation
 */

/**
 *  @version $Header: formsConfigConfirm.jsp 12-sep-2006.14:34:46 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.formsapp.FormsappConstants'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>    
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>
      <uix:dataScope currentDataBinding="formsSectionConfigData@servletRequest" >
        <uix:form name="formsConfigConfirm" method="post">
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>
              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:submitButton name="event" value="cancelConfirm" textBinding="NO@formsappMsg" renderedBinding="recorderUninstalled"/>
                  <uix:submitButton name="event" value="confirmConfig" textBinding="YES@formsappMsg" renderedBinding="recorderUninstalled"/>
                  <uix:submitButton name="event" value="cancelConfirm" textBinding="CANCEL@cmnMsg" renderedBinding="recorderInstalled"/>
                </uix:pageButtonBar>
              </uix:contentFooter>

              <uix:switcher childNameBinding="hasError">
                <uix:case name="<%=Boolean.TRUE%>">
                  <uix:messageBox messageBinding="errorTypeMsg" messageType="error">
                    <uix:contents>
                      <uix:styledText textBinding="errorMsg" /> 
                    </uix:contents>
                  </uix:messageBox>
                </uix:case>
              </uix:switcher>

              <uix:header messageType="confirmation">
                <uix:styledText textBinding="confirmMsg" styleClass="OraInstructionTextStrong" />
             </uix:header>
            </uix:pageLayout>   
          <uix:formValue
                  name="<%=FormsappConstants.FORMS_NAME%>"
                  valueBinding="formsName"/>
          <uix:formValue
                  name="<%=FormsappConstants.FORMS_TYPE%>"
                  valueBinding="formsType"/>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext> 
