<%--

/* $Header: formsEUMConfigSection.jsp 12-sep-2006.14:34:49 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Forms Transaction Monitoring Section Configuration Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED (MM/DD/YY)
   yxie      09/12/06 - XbranchMerge yxie_bug-5521573 from main
   yxie      09/11/06 - Fix bug 5521573
   yxie      03/20/06 - Creation.
 */

/**
 *  @version $Header: formsEUMConfigSection.jsp 12-sep-2006.14:34:49 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.formsapp.FormsappConstants'%>
<%@ page import='oracle.sysman.eml.formsapp.data.FormsEUMConfigData'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemNoscript.jspf" %>  
    <uix:body>
      <uix:dataScope currentDataBinding="formsEUMConfigData@servletRequest" >
        <uix:form name="formsEUMConfig" method="post">
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>
            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton name="event" value="cancelConfig" textBinding="CANCEL@cmnMsg"/> 
                <uix:submitButton name="event" value="applyConfig" textBinding="OK@cmnMsg"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

            <uix:switcher childNameBinding="hasError">
              <uix:case name="<%=Boolean.TRUE%>">
                <uix:messageBox messageBinding="errorMsg" messageType="error"/>
              </uix:case>
            </uix:switcher>

            <uix:header textBinding="formsEUMConfigSectionHeader" >
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout hAlign="right" width="100%">

                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="FORMS_SECTION_CONFIG_TXT@formsappMsg"/>
                    </uix:cellFormat>

                    <uix:spacer width="5"/>

                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:submitButton name="event" value="cancelConfig" textBinding="CANCEL@cmnMsg"/> 
                      <uix:spacer width="10"/>
                      <uix:submitButton name="event" value="applyConfig" textBinding="OK@cmnMsg"/>
                    </uix:cellFormat>

                  </uix:rowLayout>

                  <uix:rowLayout width="100%">
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                    </uix:stackLayout>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="center">
                    <uix:contents>
                      <uix:tableLayout hAlign="center" cellSpacing="2">
                        <uix:contents>
                          <uix:messageStyledText promptBinding="HOST_VALUE_LABEL@webappMsg" 
                                                 textBinding="host" 
                                                 styleClass="oraDataText"/>
                          <uix:rowLayout>
                            <uix:stackLayout>
                              <uix:spacer height="4"/>
                            </uix:stackLayout>
                          </uix:rowLayout>
                          <uix:messageStyledText promptBinding="USERNAME_HDR@webappMsg" 
                                                   textBinding="userName" 
                                                   styleClass="oraDataText"/>
                        </uix:contents>
                      </uix:tableLayout>        
                    </uix:contents>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:header textBinding="SECTION_MONITORING@formsappMsg">
                        <uix:contents>
                          <uix:stackLayout>
                            <%--uix:styledText styleClass="OraInstructionText" textBinding="SECTION_CONFIGURATION_MESSAGE@formsappMsg"/> 
                            <uix:spacer width="5" height="10"/--%>
                            <uix:header textBinding="sectionConfigTableHeader" >
                              <uix:spacer height="5"/>
                              <uix:table  name="<%=FormsEUMConfigData.SECTION_TABLE_NAME%>"
                                          alternateTextBinding="NO_SECTION_CONFIGURATION_AVAILABLE@formsappMsg"
                                          showAll="yes"
                                          width="100%"
                                          tableDataBinding="sectionConfigTableData"
                                          columnHeaderDataBinding="sectionConfigTableHeaderData"
                                          formSubmitted="true"
                                          maxValueBinding="sectionConfigTableMaxValue"
                                          valueBinding="sectionConfigTableValue"
                                          blockSizeBinding="sectionConfigTableBlockSize"
                                          summaryBinding="sectionConfigTableHeader">

                                <uix:tableSelection>
	  		    	                    <uix:singleSelection selectedIndex="0" shortDescBinding="section" disabledBinding="notNewSection">
                                    <uix:button textBinding="REMOVE_SECTION@formsappMsg" onClick="submitForm('formsEUMConfig',true,{'event':'removeNewSection'})"/>
            					  	      </uix:singleSelection>
						  	              </uix:tableSelection>

                                <uix:columnHeaderStamp>
                                  <uix:text textBinding="text"/>
                                </uix:columnHeaderStamp>

                                <uix:tableActions>
                                  <uix:flowLayout>
                                    <uix:contents>
                                      <uix:submitButton name="event" value="enableAll" textBinding="ENABLE_ALL@webappMsg"/>
                                      <uix:submitButton name="event" value="disableAll" textBinding="DISABLE_ALL@webappMsg"/>  
                                      <uix:spacer width="8"/>
                                      <uix:submitButton name="event" value="addNewSection" textBinding="ADD_SECTION@formsappMsg"/>                          
                                    </uix:contents>
                                  </uix:flowLayout>
                                </uix:tableActions>
 
                                <uix:contents>
                                  <uix:messageTextInput name="section" textBinding="section" shortDescBinding="NAME_HDR@formsappMsg" readOnlyBinding="notNewSection"/>
                                  <uix:column>
                                    <uix:columnFormat columnDataFormat="iconButtonFormat" width="5"/>
                                    <uix:rowLayout hAlign="center">
                                      <uix:image sourceBinding="monitoringStatIcon"
                                                  shortDescBinding="monitoringStatDesc"/>
                                   </uix:rowLayout>
                                 </uix:column>

                                 <uix:column>
                                   <uix:columnFormat columnDataFormat="iconButtonFormat" width="5"/>
                                   <uix:rowLayout hAlign="center">
                                     <uix:checkBox name="enableMonitoring"
                                                   value="1"
                                                   checkedBinding="enableMonitoring"
                                                   disabledBinding="disableBinding"
                                                   shortDescBinding="ENABLE_MONITORING@webappMsg"/>
                                   </uix:rowLayout>
                                 </uix:column>

                                 <uix:messageTextInput name="eumURL" textBinding="eumURL" shortDescBinding="EUM_URL@formsappMsg"/>

                               </uix:contents>
                             </uix:table>
 
                             <uix:spacer width="1" height="5"/>
                             <uix:tip>
                               <uix:contents>
                                <uix:text textBinding="SECTION_CONFIGURATION_TIP@formsappMsg"/>
                               </uix:contents>
                             </uix:tip>
                              
                             <uix:spacer height="10"/>

                             <uix:rowLayout hAlign="left">
                               <uix:styledText textBinding="RELATED_LINK@webappMsg" styleClass="OraDataText" />
                               <uix:spacer width="10" />
                               <uix:link textBinding="monitorConfigLinkText"
                                         destinationBinding="monitorConfigURL"/>
                             </uix:rowLayout>
                           </uix:header>
                         </uix:stackLayout>
                       </uix:contents>
                     </uix:header>


                    <uix:spacer width="10" />
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          </uix:header>
        </uix:pageLayout>
        <uix:formValue name="<%=FormsappConstants.FORMS_NAME%>"
                       valueBinding="formsName"/>
        <uix:formValue name="<%=FormsappConstants.FORMS_TYPE%>"
                       valueBinding="formsType"/>
      </uix:form>
    </uix:dataScope>    
  </uix:body>
  </uix:document>
</uix:renderingContext> 
