<%--

/* $Header: formsRecorderInstruct.jsp 12-sep-2006.14:34:50 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Forms Transaction Recording Start Page Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie   09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie   07/18/06 - Backport yxie_bug-5344920 from main
      yxie      09/11/06 - Fix bug 5521573
      yxie      03/20/06 - Creation
 */

/**
 *  @version $Header: formsRecorderInstruct.jsp 12-sep-2006.14:34:50 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="oracle.sysman.eml.formsapp.FormsappConstants"%>
<%@ page import="oracle.sysman.eml.formsapp.data.FormsTxnRecorderData"%>
<%@ page import="oracle.sysman.eml.formsapp.data.FormsRecorderInstructionData"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>    
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>
      <uix:dataScope currentDataBinding="formsTxnRecordingData@servletRequest">
        <uix:form name="formsTxnRecord" method="POST">
          <uix:pageLayout>

            <%@ include file="/oemGlobal.jspf" %>

            <uix:messageBox messageType="error" messageBinding="errorMsg" renderedBinding="hasError">
            </uix:messageBox>

            <uix:header textBinding="header@servletRequest">
              <uix:stackLayout>
                <uix:spacer height="5"/>
                <uix:tableLayout>
                  <uix:cellFormat>
                    <uix:contentContainer width="100%">
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="FORMS_TXN_REC_INST_INTRO@formsappMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="FORMS_TXN_REC_INST_STEP_1@formsappMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="FORMS_TXN_REC_INST_STEP_2@formsappMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="FORMS_TXN_REC_INST_STEP_3@formsappMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="FORMS_TXN_REC_INST_STEP_4@formsappMsg" />
                    </uix:contentContainer>
                  </uix:cellFormat>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:header>
  

            <uix:contentFooter>
              <uix:flowLayout>
                <uix:button id="formsTxnRecordStartButton"
                            textBinding="FORMS_TRANS_START_REC@formsappMsg" 
                            onClick="startFormsRecording()"/>
                <uix:button id="formsTxnRecordAgainButton"
                            textBinding="FORMS_TRANS_REC_AGAIN@formsappMsg" 
                            onClick="recordAgain()"/>

                <uix:spacer width="10"/>

                <uix:button id="formsTxnRecordContinueButton"
                            textBinding="CONTINUE@commonResourceBundle"
                            onClick="continueSavingFormsRecording()"/>

                <uix:spacer width="10"/>

                <uix:button id="formsTxnRecordCancelButton"
                            textBinding="CANCEL@commonResourceBundle"
                            onClick="cancelSavingFormsRecording()"/>

              </uix:flowLayout>
            </uix:contentFooter>

          </uix:pageLayout>  

          <uix:tableLayout>
            <uix:rowLayout>
              <uix:rawText>

<%!
  String objectId= null;
  String codeBase = null;
  StringBuffer strBuf = null;
%>
<%
  FormsRecorderInstructionData formsRecordingData = (FormsRecorderInstructionData) request.getAttribute(FormsappConstants.FORMS_TXN_RECORDING_DATA);

  FormsTxnRecorderData formsTxnRecorderData = formsRecordingData.getFormsRecorder();
  
  if (formsTxnRecorderData != null)
  {
    objectId = formsTxnRecorderData.getRecorderObjID();
    codeBase = formsTxnRecorderData.getCodeBase();
    strBuf = new StringBuffer();

    strBuf.append( "<OBJECT id=recorderCtl width=10 height=10 top=0 left=0\n");
    strBuf.append( "    classid=\""+ objectId +"\" codebase=\""+codeBase+"\">" );
    strBuf.append( "  <PARAM NAME=\"visible\" VALUE=\"FALSE\">\n");
    strBuf.append( "</OBJECT>\n");

    out.println( strBuf.toString() );
  }
%>

<script language="JavaScript">   

function startFormsRecording() {

  <%!
    String emURL = "";
  String recordingInstructURL = "";
  %>
    <% emURL = formsTxnRecorderData.getPostURL(); %>
    <% recordingInstructURL = formsTxnRecorderData.getRecordingInstructURL(); %>

    var recordingInstructUrl = "<%=recordingInstructURL%>";
  var emUrl = "<%=emURL%>";
  var recorderCtl = document.getElementById("recorderCtl");

  if (emUrl != null)
  {
    recorderCtl.emUrl=emUrl;
  }

  if (recordingInstructUrl != null)
  {
    recorderCtl.startRecordingUrl = recordingInstructUrl;
  }

  var sessionID = getCookie("JSESSIONID");
  if (sessionID != null)
  {
    recorderCtl.sessionID = sessionID;
  }

  hideStartButton();
  showRecordAgainButton();

  recorderCtl.command="StartRec";

}

function recordAgain(){

  var recorderCtl = document.getElementById("recorderCtl");

  recorderCtl.command="StopRec";

  submitForm('formsTxnRecord',true,{'event':'formsRecordAgain'});

}

function continueSavingFormsRecording() {

  var recorderCtl = document.getElementById("recorderCtl");

  recorderCtl.command="StopRec";

  setTimeout("submitForm('formsTxnRecord',true,{'event':'formsSaveRecording'})", 3000);

}

function cancelSavingFormsRecording() {

  var recorderCtl = document.getElementById("recorderCtl");

  recorderCtl.command="StopRec";

  submitForm('formsTxnRecord',true,{'event':'formsCancelRecording'}); 
  
}

function getCookie(name) { 
  var arg = name + "="; 
  var cookieStartIndex = document.cookie.indexOf(arg); 
  if (cookieStartIndex == -1) return null; 
  var cookieEndIndex = document.cookie.indexOf(";", cookieStartIndex + arg.length); 
  if (cookieEndIndex == -1 ) cookieEndIndex = document.cookie.length; 
  return unescape(document.cookie.substring(cookieStartIndex + arg.length, cookieEndIndex)); 
}

function showStartButton() {
  /* show start button */
  var startButton = document.getElementById("formsTxnRecordStartButton");
  if (startButton != null)
  {
    startButton.style.display = "inline";
  }

}

function hideStartButton() {
  /* hide start button */
  var startButton = document.getElementById("formsTxnRecordStartButton");
  if (startButton != null)
  {
    startButton.style.display = "none";
  }

}

function showRecordAgainButton() {
  /* show record again button */
  var recordAgainButton = document.getElementById("formsTxnRecordAgainButton");
  if (recordAgainButton != null)
  {
    recordAgainButton.style.display = "inline";
  }

}

function hideRecordAgainButton() {
  /* hide recordAgain button */
  var recordAgainButton = document.getElementById("formsTxnRecordAgainButton");
  if (recordAgainButton != null)
  {
    recordAgainButton.style.display = "none";

  }
}

function restartRecording() {
  <%!
    String event = "";
  %>
  <% event = (String) request.getAttribute(FormsappConstants.FORMS_RECORDING_EVENT); %>
  var curEvent = "<%=event%>";

  if (curEvent == "formsRecordAgain")
  {
    startFormsRecording();
  }
  else if (curEvent == "formsSaveRecording")
  {
    hideStartButton();
    showRecordAgainButton();
  }

}

hideRecordAgainButton();
restartRecording();

</script>

              </uix:rawText>
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:form>
      </uix:dataScope> 
    </uix:body>
  </uix:document>
</uix:renderingContext> 
