<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       functions.jsp
 *
 *      NOTES
 *       Home Page for Hardware and Sofware Configuration on Deployments tab
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  summukhe  07/30/07 - 
 *  srukumar  06/05/07 - Fixing bug 6063982- Shifting the Patch Oracle Software
 *                       Link to under Agent Installation
 *  shgangul  10/27/06 - ARU Dload links reposition
 *  shgangul  10/19/06 - ARU Dload Link
 *  niramach  10/20/06 - Fix for bug 5554661.
 *  abhalla   10/13/06 - adding Patching DPs link
 *  akskumar  12/01/05 - Backport akskumar_bug-4655226 from main 
 *  akskumar  11/23/05 - bug-4655226
 *  sxzhu     09/26/05 - License Clone Database 
 *  spramani  07/06/05 - agent push changes 
 *  ktamtoro  06/23/05 - Add support for additional sections 
 *  mgoodric  05/12/05 - use SDKUIMsg for Configuration History title 
 *  tasingh   04/13/05 - 
 *  anusharm  01/30/05 - making clone OH link license aware 
 *  achugh    12/29/04 - make linux host patching link license aware 
 *  asaraswa  11/30/04 - new labels for CSA links
 *  mningomb  11/30/04 - Making OH Patching links license aware 
 *  niramach  11/18/04 - Remove the policy section from deployments page. 
 *  mgoodric  11/06/04 - move Configuration History to right side
 *  mgoodric  10/30/04 - add event=init for breadcrumb links 
 *  tasingh   10/20/04 - Change 'LINUX_HOST_PATCHING' to 'PATCH_LINUX_HOSTS' 
 *  asaraswa  10/13/04 - adding CSA-related links
 *  akskumar  10/07/04 - 
 *  tasingh   09/15/04 - add link for linux host patching 
 *  akskumar  08/23/04 - remove old Compare-to-host and compare-database
 *                       Launch points
 *  akskumar  07/22/04 - add links to generic config comparison wizards (1-1
 *                       and 1-N)
 *  mgoodric  07/17/04 - add configHistory link 
 *  akskumar  05/17/04 -
 *  kchiasso  03/08/04 - add csa
 *  xshen     01/19/04 - fix bug 3133612 - usability
 *  agor      10/03/03 - Add Policy Section
 *  asaraswa  09/18/03 - adding critical patch warnings section
 *  asaraswa  09/08/03 -
 *  agor      08/19/03 -
 *  agor      08/18/03 -
 *  asaraswa  06/17/03 -
 *  asaraswa  06/02/03 -
 *  kchiasso  04/23/03 - compare 1-n
 *  agor      03/19/03 -
 *  rmenon    02/14/03 - rmenon_functions_page_changes
 *  aarasu    02/14/03 - new file for functions page
 *  aarasu    12/26/02 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="EcmResourceBundle"
              class="oracle.sysman.eml.ecm.util.EcmResourceBundle"/>
  <uix:bundle name="SearchResourceBundle"
              class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle"/>
  <uix:bundle name="EngResourceBundle"
              class="oracle.sysman.eml.ecm.EcmEnglishMessages"/>
  <uix:bundle name="CompareConfigBundle"
              class="oracle.sysman.resources.eml.ecm.track.CompareConfigWizMsg"/>
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  <uix:bundle name="AgentPushResourceBundle"
              class="oracle.sysman.resources.eml.ecm.agentpush.AgentPushResourceBundle"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

      <homeuix:metaContainer>
          <homeuix:head title="foo" />
      </homeuix:metaContainer>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <uix:form name="invForm" method="GET">
         <uix:stackLayout>
          <uix:contents>

            <uix:messageBox messageBinding="AGENT_PUSH_STATUS_MESSAGE@servletRequest" messageTypeBinding="AGENT_PUSH_STATUS_MESSAGE_TYPE@servletRequest" renderedBinding="AGENT_PUSH_STATUS_SHOWMESSAGE@servletRequest">
            <uix:contents>
              <uix:tableLayout cellSpacing="2" width="100%">
              <uix:contents>

                <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" width="50%">
                  <uix:contents>
                    <oem:license>
                      <uix:link textBinding="AGENT_PUSH_STATUS_LINKTEXT@servletRequest" destinationBinding="AGENT_PUSH_STATUS@servletRequest" renderedBinding="AGENT_PUSH_STATUS_SHOWLINK@servletRequest"/>
                    </oem:license>
                  </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
                </uix:rowLayout>

              </uix:contents>
              </uix:tableLayout>
            </uix:contents>
            </uix:messageBox> 

            <uix:header textBinding="FUNC_INTRO_HDR@EcmResourceBundle">
             <uix:contents>


              <uix:tableLayout cellSpacing="2" width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>

                       <uix:cellFormat vAlign="top" width="60%">
			<uix:header textBinding="CRITICAL_PATCH@mntrResourceBundle">
			  <uix:include nodeBinding="EcmPatch@servletRequest"/>
			</uix:header>
                        <uix:header textBinding="ENTERPRISE_CONFIGURATION@mntrResourceBundle" >
                          <uix:include nodeBinding="EcmInv@servletRequest"/>
                        </uix:header>
                        </uix:cellFormat>

                        <uix:spacer width="5"/>

                       <uix:cellFormat vAlign="top" hAlign="right" >
                        <uix:contentContainer background="light" width="100%" textBinding="FUNC_CONTENT_HDR@EcmResourceBundle">
                         <uix:contents>

                          <uix:styledText styleClass="OraInstructionText" textBinding="FUNC_CONTENT_TXT@EcmResourceBundle"/>
                          <uix:spacer height="8"/>

                          <uix:tableLayout>
                           <uix:contents>
                            <uix:rowLayout>
                             <uix:contents>

                             <uix:bulletedList>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT1@EcmResourceBundle"/>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT2@EcmResourceBundle"/>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT3@EcmResourceBundle"/>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT4@EcmResourceBundle"/>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT5@EcmResourceBundle"/>
                              <%
                                 if(session.getAttribute("showPatchProcsLink") != null && "true".equals((String)session.getAttribute("showPatchProcsLink")))
                                 {
                              %>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="FUNC_BULLET_TXT6@EcmResourceBundle"/>
                              <%
                                  }
                              %>
                             </uix:bulletedList>
                             </uix:contents>
                            </uix:rowLayout>

                           </uix:contents>
                          </uix:tableLayout>

                        </uix:contents>
                        </uix:contentContainer>

                        </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>

                <uix:header textBinding="FUNC_INVENTORY_TRACKING_HDR@EcmResourceBundle">
                 <uix:contents>
                  <uix:tableLayout width="100%">
                   <uix:contents>

                    <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="SEARCH_INVENTORY@TrackResourceBundle" destinationBinding="SEARCH_CONFIG@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="IMPORT_SNAPSHOT_LINK@TrackResourceBundle" destinationBinding="importSnapshot@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:contents>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                       <uix:contents>
                        <oem:license>
                        <uix:link textBinding="BTN_COMPARE_CONFIGURATION@CompareConfigBundle" destinationBinding="COMPARE_CONFIG_DEST@servletRequest" />
                         </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="COLLECTION_STATUS@TrackResourceBundle" destinationBinding="MISSING_CONFIG@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                         <oem:license>
                        <uix:link textBinding="BTN_COMPARE_CONFIGURATION_JOB@CompareConfigBundle" destinationBinding="COMPARE_CONFIG_JOB_DEST@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="UPDATE_INVENTORY_CACHE_LINK@TrackResourceBundle" destinationBinding="launchUpdateInContext@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <uix:link textBinding="SAVED_CONFIGURATION_LINK@TrackResourceBundle" destinationBinding="SAVED_CONFIG_DEST@servletRequest" />
                      </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="CONFIG_HISTORY@sdkUIMsg" destinationBinding="CONFIG_HISTORY@servletRequest" />
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>


                      <% if(session.getAttribute("showPatchProcsLink") != null && "true".equals((String)session.getAttribute("showPatchProcsLink")))
                        {
                      %>

                         <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat wrappingDisabled="true" width="50%">
                           <uix:contents>
                             <oem:license>
                               <uix:link textBinding="ARU_DLOAD_CS_PATCHES@EcmResourceBundle" destinationBinding="ARU_DLOAD_CS_PATCH_DEST@servletRequest"/>
                             </oem:license>
                           </uix:contents>
                           </uix:cellFormat>
                         </uix:contents>
                         </uix:rowLayout>


                      <%
                       }
                      %>


                  </uix:contents>
                  </uix:tableLayout>
                </uix:contents>
                </uix:header>

                <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" width="50%" vAlign="top">
                    <uix:contents>

                      <uix:header textBinding="FUNC_PATCHING_HDR@EcmResourceBundle">
                      <uix:contents>
                        <uix:tableLayout width="100%">
                        <uix:contents>

                       <%
                         if(session.getAttribute("showPatchProcsLink") != null && "true".equals((String)session.getAttribute("showPatchProcsLink")))
                         {
                        %>
                          <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                            <uix:contents>
                              <oem:license>
                                <uix:link textBinding="FUNC_PATCHING_DEPL_PROCS@EcmResourceBundle" destinationBinding="FUNC_PATCHING_PROCS_DEST@servletRequest"/>
                              </oem:license>
                            </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                          </uix:rowLayout>
                        <%
                          }
                         %>


                         <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat wrappingDisabled="true" width="50%">
                           <uix:contents>
                             <oem:license>
                               <uix:link textBinding="FUNC_PATCHING_VIEW@EcmResourceBundle" destinationBinding="FUNC_PATCHING_VIEW@servletRequest"/>
                             </oem:license>
                           </uix:contents>
                           </uix:cellFormat>
                         </uix:contents>
                         </uix:rowLayout>

                         <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat wrappingDisabled="true" width="50%">
                           <uix:contents>
                             <oem:license>
                               <uix:link textBinding="PATCH_LINUX_HOSTS@EcmResourceBundle" destinationBinding="LINUX_HOST_PATCHING_DEST@servletRequest"/>
                             </oem:license>
                           </uix:contents>
                           </uix:cellFormat>
                         </uix:contents>
                         </uix:rowLayout>
                          
			 <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                            <uix:contents>
                                <uix:link textBinding="FUNC_PATCH_AGENT@EcmResourceBundle" destinationBinding="FUNC_PATCHING_APPLY@servletRequest"/>
                            </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                          </uix:rowLayout>

                       </uix:contents>
                       </uix:tableLayout>
                     </uix:contents>
                     </uix:header>
                   </uix:contents>
                   </uix:cellFormat>

                   <uix:cellFormat wrappingDisabled="true" width="50%" vAlign="top">
                   <uix:contents>
                     <uix:header textBinding="AGENT_INSTALLATION@AgentPushResourceBundle">
                     <%--<uix:header textBinding="PATCH_LINUX_HOSTS@EcmResourceBundle">--%>


                     <uix:contents>

                       <uix:tableLayout width="100%">
                       <uix:contents>

                         <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat wrappingDisabled="true" width="50%">
                           <uix:contents>
                             <oem:license>
                               <uix:link textBinding="INSTALL_AGENT@AgentPushResourceBundle" destinationBinding="AGENT_PUSH_INSTALL@servletRequest"/>
                             </oem:license>
                           </uix:contents>
                           </uix:cellFormat>
                         </uix:contents>
                         </uix:rowLayout>

                         <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat wrappingDisabled="true" width="50%">
                           <uix:contents>
                             <oem:license>
                               <uix:link textBinding="AGENT_INSTALLATION_STATUS@AgentPushResourceBundle" destinationBinding="AGENT_PUSH_STATUS@servletRequest"/>
                             </oem:license>
                           </uix:contents>
                           </uix:cellFormat>
                         </uix:contents>
                         </uix:rowLayout>


                       </uix:contents>
                       </uix:tableLayout>

                     </uix:contents>
                     </uix:header>
                   </uix:contents>
                   </uix:cellFormat>
                 </uix:contents>
                 </uix:rowLayout>

                </uix:contents>
                </uix:tableLayout>

                <uix:header textBinding="FUNC_CLONING_HDR@EcmResourceBundle">
                <uix:contents>
                  <uix:tableLayout width="100%">
                  <uix:contents>
                    <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
			<oem:license>
                          <uix:link textBinding="FUNC_CLONING_DATABASE@EcmResourceBundle" destinationBinding="DBCloneLink@servletRequest"/>
			</oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" width="50%">
                      <uix:contents>
                        <oem:license>
                        <uix:link textBinding="FUNC_CLONING_HOME@EcmResourceBundle" destinationBinding="FUNC_CLONING_HOME@servletRequest"/>
                        </oem:license>
                      </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>
                  </uix:contents>
                  </uix:tableLayout>
                </uix:contents>
                </uix:header>
                

                <uix:header textBinding="FUNC_CLIENT_CONFIGS@csaBundle" renderedBinding ="renderCSA@servletRequest">
                  <uix:contents>
                    <uix:tableLayout width="100%">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                              <uix:contents>
                                <uix:link textBinding="GETTING_STARTED@csaBundle"
                                          destinationBinding="csaStartedLink@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                              <uix:contents>
                                <uix:link textBinding="SEARCH_COLLECTIONS@csaBundle"
                                          destinationBinding="csaSearchLink@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                              <uix:contents>
                                <uix:link textBinding="FAILED_HDR@csaBundle"
                                          destinationBinding="csaFailedLink@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                              <uix:contents>
                                <uix:link textBinding="CURRENT_ASSOC_HDR@csaBundle"
                                          destinationBinding="csaAssocLink@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" width="50%">
                              <uix:contents>
                                <uix:link textBinding="OUT_OF_BOX_HDR@csaBundle"
                                          destinationBinding="csaOOBLink@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>

                <%-- Other sections (Provisioning Advisor, etc.) --%>
                <%

                oracle.cabo.ui.collection.UINodeList sections = (oracle.cabo.ui.collection.UINodeList)request.getAttribute("sections");
                if (sections != null)
                {
                  for (int i = 0; i < sections.size(renderingContext); i++)
                  {
                    oracle.cabo.ui.UINode section = sections.getUINode(renderingContext, i);
                    String temp = "section" + (new Integer(i)).toString();
                    request.setAttribute (temp, section);

                %>
                    <uix:include nodeBinding='<%= temp+"@servletRequest" %>'/>
                <%
                  }
                }
                %>


              </uix:contents>
             </uix:header>

         </uix:contents>
        </uix:stackLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
