<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.chronos.data.BuildSoapViewBean"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
              class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:bundle name="soap"
              class="oracle.sysman.eml.gensvc.test.soap.resources.SoapResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="createSOAP" method="post" destination="">
        <uix:contents>
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf"%>
            <uix:dataScope currentDataBinding="@servletRequest">
              <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf"%>
            </uix:dataScope>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right" width="100%">
                <uix:include nodeBinding="myMessageBean@servletRequest"/>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton textBinding="CANCEL@soap"
                                    name="<%=UIConstants.EVENT_PARAM%>"
                                    value="SOAP_CANCEL" unvalidated="true"/>
                  <uix:submitButton textBinding="OK@soap"
                                    name="<%=UIConstants.EVENT_PARAM%>"
                                    value="SOAP_OK" unvalidated="true"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:contentFooter>
            <uix:header textBinding="SOAP_REQUEST_PAGE_TITLE@soap">
              <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@soap"
                                      name="<%=UIConstants.EVENT_PARAM%>"
                                      value="SOAP_CANCEL" unvalidated="true"/>
                    <uix:submitButton textBinding="OK@soap"
                                      name="<%=UIConstants.EVENT_PARAM%>"
                                      value="SOAP_OK" unvalidated="true"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:rowLayout>
              <uix:spacer height="8"/>
              <uix:stackLayout>
                <uix:rowLayout width="75%" hAlign="center">
                  <uix:contents>
                    <uix:messageChoice name="portTypes" promptBinding="PORT_TYPE@soap"
                                       selectedValueBinding="portType@mySoapViewBean@servletRequest"
                                       onChange="submitForm(this.form,false,{event:\'PORT_TYPE_CHANGE\'})">
                      <uix:contents childDataBinding="portTypes@mySoapViewBean@servletRequest">
                        <uix:option textBinding="text" valueBinding="val"/>
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:contents>
                </uix:rowLayout>
              </uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:header textBinding="OPERATIONS@soap">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="OPERATIONS_INSTRUCTION@soap"/>
                <uix:spacer height="8"/>
                <uix:stackLayout>
                  <uix:rowLayout width="100%" hAlign="center">
                    <uix:contents>
                      <uix:radioGroup onChange="submitForm(\'createSOAP\', false, {event:\'SOAP_OP_CONTINUE\'});"
                                      childDataBinding="operationsDataSet@mySoapViewBean@servletRequest"
                                      textBinding="text" valueBinding="value"
                                      name="operation"
                                      selectedValueBinding="operationName@mySoapViewBean@servletRequest"
                                      disabledBinding="disabled"/>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout >
                  <uix:spacer height="10"/>
                  </uix:rowLayout>
                </uix:stackLayout>
              <uix:header textBinding="PARAMETERS_TITLE@soap">
                <uix:stackLayout>
                   <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="PARAMS_INSTRUCTION@soap"
                                  renderedBinding="nonVoidMethod@mySoapViewBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="NO_PARAMS_INSTRUCTION@soap"
                                  renderedBinding="voidMethod@mySoapViewBean@servletRequest"/>
                   </uix:rowLayout>               
                 <uix:rowLayout   renderedBinding="nonVoidMethod@mySoapViewBean@servletRequest">
                    <uix:contents>
			<uix:radioButton 
   			  	onClick="submitForm(\'createSOAP\', false, {event:\'SOAP_MSG_INPUT_STYLE_CHANGE\'});"
				name="inputStyle"
                		textBinding="HTML_FORM@soap"
                		selectedBinding="htmlFormStyleInput@mySoapViewBean@servletRequest"
                		value="htmlForm"/>
   			<uix:radioButton 
   			  	onClick="submitForm(\'createSOAP\', false, {event:\'SOAP_MSG_INPUT_STYLE_CHANGE\'});"
   				name="inputStyle"
                		textBinding="XML_SOURCE@soap"
                		selectedBinding="xmlStyleInput@mySoapViewBean@servletRequest"
                		value="xmlSource"/>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:spacer height="8"/>
  		<uix:rowLayout  renderedBinding="nonVoidMethod@mySoapViewBean@servletRequest">
           <uix:switcher childNameBinding="htmlFormStyleInput@mySoapViewBean@servletRequest">              
                <uix:case name="true">
                                  
		  <uix:include nodeBinding="stackLayoutBean@servletRequest" />
               </uix:case>
               <uix:case name="false">
                    <uix:textInput id="payloadTextField" name="payloadTextInput" columns="100"   rows="20" 
                    textBinding="payloadString@mySoapViewBean@servletRequest" wrap="hard" shortDescBinding="XML_SOURCE_DESC@soap"/>
               </uix:case>
               </uix:switcher>
		</uix:rowLayout>
                </uix:stackLayout>
              </uix:header>
            </uix:header>

              <uix:spacer height="10"/>
              <uix:header textBinding="AUTHENTICATION_TITLE@soap">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="AUTHENTICATION_INSTRUCTION@soap"/>
                  <uix:spacer height="8"/>
                  <uix:labeledFieldLayout width="75%">
                    <uix:messageTextInput name="realm"
                                          promptBinding="SOAP_AUTH_REALM@soap"
                                          columns="8"
                                          textBinding="realm@servletRequest"/>
                    <uix:messageTextInput name="username"
                                          promptBinding="SOAP_AUTH_USERNAME@soap"
                                          columns="8"
                                          textBinding="username@servletRequest"/>
                    <uix:messageTextInput name="password"
                                          promptBinding="SOAP_AUTH_PASSWORD@soap"
                                          columns="8"
                                          textBinding="password@servletRequest"
                                          secret="true" noAutoComplete="true"/>
                  </uix:labeledFieldLayout>
                </uix:stackLayout>
              </uix:header>
              <uix:spacer height="10"/>
              <uix:header textBinding="SOAP_ENDPOINT@soap">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ENDPOINT_INSTRUCTION_TEXT@soap"/>
                  <uix:spacer height="8"/>
                  <uix:messageTextInput name="endpoint"
                                        promptBinding="SOAP_ENDPOINT@soap"
                                        columns="95"
                                        textBinding="soapEndpoint@mySoapViewBean@servletRequest"
                                        required="yes"/>
                </uix:stackLayout>
              </uix:header>
            </uix:header>
          </uix:pageLayout>
        </uix:contents>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
