<%--
/* $Header: gensvcAvail.jsp 27-may-2005.14:56:32 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Threshold Settings page 

   PRIVATE CLASSES
    The availability page.

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      05/27/05 - add related links 
    andyao      03/04/05 - use EmlConstants.RETURN_URL_PAGE_PROPERTY 
    andyao      01/07/05 - 
    andyao      12/21/04 - use hide/show 
    andyao      12/03/04 - use message.jspf 
    andyao      11/18/04 - move page level text 
    andyao      11/09/04 - fix tip text 
    andyao      11/05/04 - remove manage tests/beacons 
    andyao      10/26/04 - andyao_services5
    andyao      10/21/04 - move error location 
    andyao      10/13/04 - andyao_services4
    andyao      10/01/04 - Creation
 */

/**
 *  @version $Header: gensvcAvail.jsp 27-may-2005.14:56:32 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.GenSvcPageSegmentTypes' %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
	<oem:setURLEncoder id="renderingContext"/>
	<uix:document>
		<%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
			<uix:pageLayout>
				<%@ include file="/oemGlobal.jspf"%>
				<uix:form name="mainForm" method="POST">
          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />
            <uix:formValue
              name="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              />

            <%@ include file="/gensvc/message.jspf" %>

            <uix:header textBinding="AVAILABILITY_DEFINITION@gensvc">

              <uix:tableLayout cellSpacing="5" borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText textBinding="AVAILABILITY_PAGE_TEXT1@gensvc" styleClass="OraInstructionText"/> 
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right" columnSpan="2">
                    <uix:pageButtonBar>
                      <uix:submitButton 
                        textBinding="CANCEL@common"     
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=UIConstants.CANCEL_EVENT%>"
                        formName="mainForm"
                        />
                      <uix:submitButton 
                        textBinding="OK@common"     
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=GenSvcUIConstants.OK_EVENT%>"
                        formName="mainForm"
                        />
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_AVAILABILITY%>"/>
                  </uix:cellFormat>
                  <uix:cellFormat rowSpan="4" vAlign="top" rendered="false">
                    <uix:contentContainer textBinding="TIP@gensvc" width="300">
                      <uix:messagePrompt promptBinding="AVAILABILITY_PAGE_TEXT3@gensvc"/>
                      <%--<uix:messagePrompt prompt=""/>--%>
                      <%--<uix:messagePrompt promptBinding="AVAILABILITY_PAGE_TEXT4@gensvc"/>--%>
                    </uix:contentContainer>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:hideShowHeader 
                      textBinding="SERVICE_TESTS@gensvc" 
                      id="showTests"
                      partialRenderMode="self" 
                      unvalidated="true"
                      formSubmitted="true"
                      disclosedBinding="showTests@bean@">
                      <%--
                      <uix:tableLayout cellSpacing="5" borderWidth="0" width="80%">
                        <uix:rowLayout hAlign="right">
                          <uix:submitButton 
                            textBinding="MANAGE_TESTS@gensvc" 
                            name="<%=UIConstants.EVENT_PARAM%>" 
                            value="<%=GenSvcUIConstants.MANAGE_TESTS_EVENT%>"
                            />
                        </uix:rowLayout>
                      </uix:tableLayout>
                      --%>
                      <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_TESTS%>"/>
                    </uix:hideShowHeader>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:hideShowHeader 
                      textBinding="BEACONS@gensvc"
                      id="showBeacons"
                      partialRenderMode="self" 
                      unvalidated="true"
                      formSubmitted="true"
                      disclosedBinding="showBeacons@bean@">
                      <uix:messagePrompt promptBinding="AVAILABILITY_PAGE_TEXT5@gensvc"/>
                      <%--
                      <uix:tableLayout cellSpacing="5" borderWidth="0" width="80%">
                        <uix:rowLayout hAlign="right">
                          <uix:submitButton 
                            textBinding="MANAGE_BEACONS@gensvc" 
                            name="<%=UIConstants.EVENT_PARAM%>" 
                            value="<%=GenSvcUIConstants.MANAGE_BEACONS_EVENT%>"
                            />
                        </uix:rowLayout>
                      </uix:tableLayout>
                      --%>
                      <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_BEACONS%>"/>
                    </uix:hideShowHeader>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:hideShowHeader 
                      id="showSystem"
                      textBinding="SYSTEM@gensvc"
                      partialRenderMode="self" 
                      unvalidated="true"
                      formSubmitted="true"
                      disclosedBinding="showSystem@bean@">
                      <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_SYSTEM_ASSOCIATION%>"/>
                    </uix:hideShowHeader>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <%@ include file="/gensvc/relatedLinks.jspf" %>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>
          </uix:dataScope>
        </uix:form>
        <uix:contentFooter>
          <uix:pageButtonBar>
            <uix:submitButton 
              textBinding="CANCEL@common"     
              name="<%=UIConstants.EVENT_PARAM%>" 
              value="<%=UIConstants.CANCEL_EVENT%>"
              formName="mainForm"
              />
            <%-- the OK button --%>
            <uix:submitButton 
              textBinding="OK@common"     
              name="<%=UIConstants.EVENT_PARAM%>" 
              value="<%=GenSvcUIConstants.OK_EVENT%>"
              formName="mainForm"
              />
          </uix:pageButtonBar>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
