<%--
/* $Header: gensvcCreateBeacon.jsp 14-jun-2005.20:49:41 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The template for Create Services Drill Down page

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/14/05 - add alt image 
    andyao      06/14/05 - fix cancel button
    andyao      01/20/05 - allow beacon to be added from All Targets/Agent 
                           page 
    andyao      12/03/04 - use message.jspf 
    andyao      11/02/04 - andyao_svc_txn_integration
    andyao      11/01/04 - Creation
 */

/**
 *  @version $Header: gensvcCreateBeacon.jsp 14-jun-2005.20:49:41 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.BeaconPageViewBean" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>

      <uix:dataScope currentDataBinding="@servletRequest">
        <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
        <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
        <uix:bundle name="beacon" class="oracle.sysman.eml.rsc.gen.oracle_beaconMsg" />
        <uix:bundle name="emd"    class="oracle.sysman.eml.rsc.gen.oracle_emdMsg" />

        <uix:form method="POST" name="mainForm">
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf"%>

            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>
            <uix:formValue 
              name="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              /> 
            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />
            <uix:formValue
              name="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              />

            <%@ include file="/gensvc/message.jspf" %>
            <uix:header textBinding="<%=GenSvcUIConstants.PAGE_HEADER_KEY%>">
              <uix:tableLayout borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messagePrompt promptBinding="CREATE_BEACON_PAGE_TEXT1@gensvc" 
                      renderedBinding="showAgentSelector@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                    <uix:pageButtonBar>
                      <%-- the cancel button --%>
                      <uix:submitButton 
                        textBinding="CANCEL@common" 
                        unvalidated="true" 
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=UIConstants.CANCEL_EVENT%>"
                        />

                      <%-- the OK button --%>
                      <uix:submitButton
                        textBinding="OK@common"
                        name="<%=UIConstants.EVENT_PARAM%>"
                        value="<%=GenSvcUIConstants.OK_EVENT%>"
                        renderedBinding="<%=GenSvcUIConstants.SHOW_OK_BUTTON%>"
                        />

                      <%-- the continue button --%>
                      <uix:submitButton 
                        textBinding="CONTINUE@common"                  
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=GenSvcUIConstants.CONTINUE_EVENT%>"
                        renderedBinding="<%=GenSvcUIConstants.SHOW_CONTINUE_BUTTON%>"
                        />
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                  <%-- end of page buttons --%>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>
                <%-- begin of the actual content --%>
                <uix:rowLayout>
                  <uix:dataScope currentDataBinding="bean@">
                    <uix:tableLayout borderWidth="0">
                      <uix:rowLayout>
                        <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%">
                          <uix:messageLovField
                            name="<%=BeaconPageViewBean.AGENT_KEY%>"
                            required="yes"
                            textBinding="<%=BeaconPageViewBean.AGENT_KEY%>"
                            promptBinding="oracle_emd_name@emd"
                            onClickBinding="selectAgentOnClick"
                            renderedBinding="showAgentSelector@servletRequest"
                            searchDescBinding="SELECT_AGENT@gensvc"
                            />
                          <uix:messageTextInput
                            name="<%=BeaconPageViewBean.NAME_KEY%>"
                            required="yes"
                            textBinding="<%=BeaconPageViewBean.NAME_KEY%>"
                            promptBinding="NAME@common"
                            tipBinding="CREATE_BEACON_NAME_TIP@gensvc"
                            />
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:dataScope>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:dataScope currentDataBinding="bean@">
                    <uix:header textBinding="PROXY_INFORMATION@gensvc">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:messagePrompt promptBinding="CREATE_BEACON_PROXY_TEXT1@gensvc"/>
                          <uix:spacer height="10"/>
                          <uix:tableLayout>
                            <uix:rowLayout>
                              <uix:labeledFieldLayout labelWidth="40%" fieldWidth="60%">
                                <uix:messageTextInput
                                  name="<%=BeaconPageViewBean.HOST_KEY%>"
                                  promptBinding="oracle_beacon_proxy_host@beacon"
                                  textBinding="<%=BeaconPageViewBean.HOST_KEY%>"
                                  />
                                <uix:messageTextInput
                                  name="<%=BeaconPageViewBean.PORT_KEY%>"
                                  promptBinding="oracle_beacon_proxy_port@beacon"
                                  textBinding="<%=BeaconPageViewBean.PORT_KEY%>"
                                  />
                                <uix:messageTextInput
                                  name="<%=BeaconPageViewBean.DONT_USE_PROXY_FOR_KEY%>"
                                  promptBinding="oracle_beacon_dont_proxy_for@beacon"
                                  textBinding="<%=BeaconPageViewBean.DONT_USE_PROXY_FOR_KEY%>"
                                  />
                              </uix:labeledFieldLayout>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:header>
                  </uix:dataScope>
                </uix:rowLayout>
                <%-- end of the actual content --%>
              </uix:tableLayout>
            </uix:header>
            <uix:contentFooter>
              <uix:pageButtonBar>

                <%-- the cancel button --%>
                <uix:submitButton 
                  textBinding="CANCEL@common" 
                  unvalidated="true" 
                  name="<%=UIConstants.EVENT_PARAM%>" 
                  value="<%=UIConstants.CANCEL_EVENT%>"
                  />

                <%-- the OK button --%>
                <uix:submitButton
                  textBinding="OK@common"
                  name="<%=UIConstants.EVENT_PARAM%>"
                  value="<%=GenSvcUIConstants.OK_EVENT%>"
                  renderedBinding="<%=GenSvcUIConstants.SHOW_OK_BUTTON%>"
                  />

                <!-- the continue button -->
                <uix:submitButton 
                  textBinding="CONTINUE@common" 
                  name="<%=UIConstants.EVENT_PARAM%>" 
                  value="<%=GenSvcUIConstants.CONTINUE_EVENT%>" 
                  renderedBinding="<%=GenSvcUIConstants.SHOW_CONTINUE_BUTTON%>"
                  />

              </uix:pageButtonBar>
            </uix:contentFooter>
          </uix:pageLayout>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>
