<%--
/* $Header: gensvcCreateServiceReview.jsp 04-mar-2005.11:35:28 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The template for Create Services Review page

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      03/04/05 - add return url for error handling
    andyao      01/07/05 - 
    andyao      12/13/04 - add review header null check 
    andyao      12/03/04 - use message.jspf 
    andyao      11/18/04 - remove tip 
    andyao      10/21/04 - move error location 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: gensvcCreateServiceReview.jsp 04-mar-2005.11:35:28 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:dataScope currentDataBinding="@servletRequest">
        <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
        <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>

          <uix:form method="POST" name="mainForm">
            <%@ include file="/gensvc/admin/createServiceTrain.jspf" %>
            <%-- hidden field, so we know which step we are on in the wizard --%>
            <uix:formValue 
              name="<%=GenSvcUIConstants.CURRENT_PAGE_INDEX_KEY%>" 
              valueBinding="<%=GenSvcUIConstants.WIZARD_STATE_KEY%>"
              />
            <uix:formValue 
              name="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              /> 
            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />

            <%@ include file="/gensvc/message.jspf" %>            
            <uix:header textBinding="pageHeader">

              <uix:tableLayout borderWidth="0" width="100%" cellSpacing="5">
                <uix:rowLayout hAlign="right">
                  <%@ include file="/gensvc/admin/createServiceReviewNav.jspf"%>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:tableLayout borderWidth="0" width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:tableLayout borderWidth="0" width="100%">

                          <uix:rowLayout>
                            <%-- general --%>
                            <uix:ref refID="SERVICE_CONTENT_ID_1" /> 
                          </uix:rowLayout>

                          <uix:rowLayout>
                            <%-- system assoc --%>
                            <uix:ref refID="SERVICE_CONTENT_ID_2" /> 
                          </uix:rowLayout>
                          <%
                          int reviewSectionCount = 0;
                          String[] reviewHeaders = (String[]) 
                            request.getAttribute(GenSvcUIConstants.REVIEW_HEADERS_KEY);
                          if (reviewHeaders != null)
                          {
                            reviewSectionCount = reviewHeaders.length;
                          }
                          %>
                          <%
                          for ( int i = 0; i < reviewSectionCount; i++)
                          {
                            String pgSegAttr = "SERVICE_CONTENT_ID_"+(i+3);
                          %>
                            <uix:rowLayout rendered="true">
                              <%
                              if (reviewHeaders[i] == null)
                              {
                              %>
                              <uix:ref refID="<%=pgSegAttr%>"/> 
                              <%
                              }
                              else
                              {
                              %>
                              <uix:header text="<%=reviewHeaders[i]%>">
                                <uix:ref refID="<%=pgSegAttr%>"/> 
                              </uix:header>
                              <%
                              }
                              %>
                            </uix:rowLayout>
                          <%
                          }
                          %>


                        </uix:tableLayout>
                      </uix:cellFormat>
                      <uix:cellFormat rendered="false">
                        <uix:spacer width="50"/>
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="top" rendered="false">
                        <uix:contentContainer textBinding="TIP@gensvc" width="300">
                          <uix:messagePrompt promptBinding="REVIEW_PAGE_TEXT1@gensvc"/>
                          <uix:messagePrompt prompt=""/>
                          <uix:messagePrompt promptBinding="REVIEW_PAGE_TEXT2@gensvc"/>
                          <uix:messagePrompt prompt=""/>
                          <uix:messagePrompt promptBinding="REVIEW_PAGE_TEXT3@gensvc"/>
                        </uix:contentContainer>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
              </uix:tableLayout>

            </uix:header>
          </uix:form>

          <uix:contentFooter>
            <%@ include file="/gensvc/admin/createServiceReviewNav.jspf"%>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

