<%--
/* $Header: gensvcCreateServiceStep3.jsp 26-apr-2007.10:55:28 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The template for Create Services page for 2 segments.

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      07/24/05 - fix button layout 
    andyao      02/07/05 - use the latest target selector 
    andyao      02/04/05 - fix layout 
    andyao      01/07/05 - 
    andyao      12/28/04 - 
    afontana    12/17/04 - co for refresh 
    andyao      12/03/04 - use message.jspf 
    andyao      10/21/04 - move error location 
    andyao      09/18/04 - add inline error message 
    rmarripa    09/16/04 - add target selector 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: gensvcCreateServiceStep3.jsp 26-apr-2007.10:55:28 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:dataScope currentDataBinding="@servletRequest">
        <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>

          <uix:form method="POST" name="mainForm" id="mainForm">
            <%@ include file="/gensvc/admin/createServiceTrain.jspf" %>
            <%-- hidden field, so we know which step we are on in the wizard --%>
            <uix:formValue 
              name="<%=GenSvcUIConstants.CURRENT_PAGE_INDEX_KEY%>" 
              valueBinding="<%=GenSvcUIConstants.WIZARD_STATE_KEY%>"
              />
            <uix:formValue 
              name="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"
              /> 
            <%@ include file="/gensvc/message.jspf" %>
            <uix:header textBinding="<%=GenSvcUIConstants.PAGE_HEADER_KEY%>">
              <uix:tableLayout borderWidth="0" width="100%">
                <uix:rowLayout hAlign="right">
                  <%@ include file="/gensvc/admin/createServiceNav.jspf"%>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:tableLayout cellSpacing="5" borderWidth="0" width="100%">
                    <%-- begin of the actual content --%>
                    <uix:rowLayout>
                      <uix:cellFormat columnSpan="2" vAlign="top">
                        <uix:ref refID="SERVICE_CONTENT_ID_1" /> 
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat width="60%" vAlign="top">
                        <uix:ref refID="SERVICE_CONTENT_ID_2" /> 
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="top" renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>">
                        <uix:contentContainer textBinding="TIP@gensvc" width="300">
                          <uix:styledText styleClass="OraInstructionText">
                            <uix:rawText 
                              textBinding="TEST_PAGE_TIP_TEXT1@gensvc"/>
                          </uix:styledText>
                        </uix:contentContainer>
                      </uix:cellFormat>

                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat width="100%" columnSpan="2">
                        <uix:ref refID="SERVICE_CONTENT_ID_3" /> 
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
                <%-- end of the actual content --%>
              </uix:tableLayout>
            </uix:header>
          </uix:form>

          <uix:contentFooter>
            <%@ include file="/gensvc/admin/createServiceNav.jspf"%>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

