<%--
/* $Header: gensvcEditServiceStep1.jsp 24-jul-2005.14:25:39 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The template for Edit Service Page with 1 segment

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      07/24/05 - 
    andyao      03/04/05 - use EmlConstants.RETURN_URL_PAGE_PROPERTY 
    andyao      02/07/05 - use the latest target selector 
    andyao      01/21/05 - fix layout 
    andyao      01/07/05 - remove html comment 
    andyao      12/03/04 - use message.jspf 
    andyao      11/18/04 - fix layout 
    andyao      10/21/04 - move error location 
    andyao      09/18/04 - add inline error message 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: gensvcEditServiceStep1.jsp 24-jul-2005.14:25:39 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>

        <uix:dataScope currentDataBinding="@servletRequest">
          <%@ include file="/gensvc/message.jspf" %>
          <uix:header textBinding="pageHeader">

            <uix:form method="POST" name="mainForm">
              <%-- the value that indicates which page we are on --%>
              <uix:formValue 
                name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                />
              <uix:formValue
                name="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
                valueBinding="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
                />

              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right" vAlign="top">
                  <uix:cellFormat hAlign="right">
                    <%@ include file="/gensvc/admin/editServiceNav.jspf" %>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat vAlign="top">
                    <uix:ref refID="SERVICE_CONTENT_ID_1" /> 
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <%@ include file="/gensvc/relatedLinks.jspf" %>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:form>

          </uix:header>
        </uix:dataScope>

        <uix:contentFooter>
          <%@ include file="/gensvc/admin/editServiceNav.jspf" %>
        </uix:contentFooter>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
