<%--
/* $Header: gensvcInteractiveTest.jsp 13-jun-2005.16:34:35 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The template for Interactive Test page

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - add short description 
    andyao      03/04/05 - use EmlConstants.RETURN_URL_PAGE_PROPERTY 
    mfidanbo    02/07/05 - 
    andyao      01/07/05 - 
    andyao      12/03/04 - use message.jspf 
    andyao      11/05/04 - fix continue button 
    andyao      10/25/04 - remove unnecessary form values 
    mfidanbo    10/18/04 - implement interactive test 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: gensvcInteractiveTest.jsp 13-jun-2005.16:34:35 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.InteractiveTestViewBean"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/enablePPR.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:form method="POST" name="mainForm">
          <uix:formValue name="<%= GenSvcUIConstants.REFRESH_UI %>" value="<%= GenSvcUIConstants.NO_REFRESH %>"/>
          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:formValue name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>" valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"/>
            <uix:formValue name="<%=WebsiteConstants.TXN_ID%>" valueBinding="<%=WebsiteConstants.TXN_ID%>"/>
            <uix:formValue name="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>" valueBinding="<%=GenSvcUIConstants.WIZARD_MODE_KEY%>"/>
            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf"%>
            <%@ include file="/gensvc/message.jspf"%>
          </uix:dataScope>
          <uix:dataScope currentDataBinding="_DATA_SOURCE@servletRequest">
            <uix:header textBinding="VERIFY_SERVICE_TEST@gensvc">
              <uix:stackLayout>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat>
                    <uix:pageButtonBar>
                      <%-- the continue button --%>
                      <uix:submitButton textBinding="CONTINUE@common" shortDescBinding="CONTINUE@common" name="<%=UIConstants.EVENT_PARAM%>" value="<%=GenSvcUIConstants.CONTINUE_EVENT%>"/>
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                  <%-- end of page buttons --%>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText textBinding="INTERACTIVE_TEST_PAGE_TEXT1@gensvc" styleClass="OraPromptText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:spacer height="20"/>
                <uix:rowLayout>
                  <uix:cellFormat vAlign="top">
                    <uix:messageChoice nameBinding="TEST_LIST" id="SingSelectListOne"
                      promptBinding="SERVICE_TEST@gensvc"
                      >
                      <uix:contents childDataBinding="testList">
                        <uix:option textBinding="<%= UIConstants.TEXT_KEY %>" valueBinding="<%= UIConstants.VALUE_PARAM %>" selectedBinding="<%= UIConstants.SELECTED_KEY %>"/>
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:cellFormat>
                  <uix:spacer width="20"/>
                  <uix:cellFormat vAlign="top">
                    <uix:messageList nameBinding="BCN_LIST" multiple="true" size="3"
                      promptBinding="BEACONS@gensvc"
                      >
                      <uix:contents childDataBinding="beaconList">
                        <uix:option textBinding="<%= UIConstants.TEXT_KEY %>" valueBinding="<%= UIConstants.VALUE_PARAM %>" selectedBinding="<%= UIConstants.SELECTED_KEY %>"/>
                      </uix:contents>
                    </uix:messageList>
                  </uix:cellFormat>
                  <uix:spacer width="20"/>
                  <uix:cellFormat vAlign="top">
                    <%-- the interactive test button --%>
                    <uix:submitButton textBinding="PERFORM_TEST@gensvc" shortDescBinding="PERFORM_TEST@gensvc" name="<%= UIConstants.EVENT_PARAM %>" value="<%= GenSvcUIConstants.PERFORM_TEST_EVENT %>"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:spacer height="20"/>
                <uix:header textBinding="RESULTS@gensvc">
                  <uix:rowLayout>
                    <uix:include nodeBinding="table"/>
                  </uix:rowLayout>
                </uix:header>
                <%-- end of the actual content --%>
                <uix:spacer height="20"/>
             </uix:stackLayout>
            </uix:header>
          </uix:dataScope>
        </uix:form>
        <uix:contentFooter>
          <uix:pageButtonBar>
            <%-- the continue button --%>
            <uix:dataScope>
              <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle"/>
              <uix:submitButton textBinding="CONTINUE@common" shortDescBinding="CONTINUE@common" name="<%=UIConstants.EVENT_PARAM%>" value="<%=GenSvcUIConstants.CONTINUE_EVENT%>" formName="mainForm"/>
              <uix:spacer width="10"/>
            </uix:dataScope>
          </uix:pageButtonBar>
        </uix:contentFooter> 
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
