<%--
/* $Header: gensvcRCAConfig.jsp 13-jun-2005.14:15:47 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The RCA Configuration page

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - add table summary 
    andyao      03/04/05 - use EmlConstants.RETURN_URL_PAGE_PROPERTY 
    andyao      01/17/05 - 
    andyao      01/05/05 - add row banding 
    jriel       01/05/05 - UI feedback 
    andyao      12/03/04 - use message.jspf 
    jriel       12/07/04 - ui feedback 
    andyao      11/09/04 - andyao_rca_config
    andyao      11/07/04 - Creation
 */

/**
 *  @version $Header: gensvcRCAConfig.jsp 13-jun-2005.14:15:47 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.RCAConfigBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>

        <uix:dataScope currentDataBinding="@servletRequest">
          <uix:bundle 
            name="gensvc" 
            class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
          <uix:bundle 
            name="common" 
            class="oracle.sysman.resources.CommonResourceBundle" />

          <%@ include file="/gensvc/message.jspf" %>
          <uix:header textBinding="<%=GenSvcUIConstants.PAGE_HEADER_KEY%>">

            <uix:form method="POST" name="mainForm">

              <uix:formValue 
                name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                />

              <uix:formValue
                name="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
                valueBinding="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
                />
    
              <uix:dataScope currentDataBinding="bean">

                <uix:tableLayout borderWidth="0" cellSpacing="5" width="100%">
                 
                  <uix:rowLayout>
                    <uix:header textBinding="AUTOMATIC_ANALYSIS@gensvc" >
                      <uix:stackLayout>
                        <uix:styledText textBinding="RCA_CONFIG_PAGE_TEXT2@gensvc" styleClass="OraPromptText" />
                        <%-- perform RCA --%>
                        <uix:spacer height="10" />
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:spacer width="20" />
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:styledText textBinding="AUTOMATIC_ANALYSIS@gensvc" styleClass="OraPromptText" />
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:spacer width="5" />
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:styledText textBinding="<%=RCAConfigBean.AUTO_RCA_SETTING_KEY%>" styleClass="OraDataText" />
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:spacer width="10" />
                          </uix:cellFormat>
                          <uix:cellFormat vAlign="center" >
                            <uix:submitButton textBinding="<%=RCAConfigBean.AUTO_RCA_BUTTON_KEY%>"                    
                                name="<%=UIConstants.EVENT_PARAM%>" 
                                valueBinding="<%=RCAConfigBean.AUTO_RCA_VALUE_KEY%>"
                                formName="mainForm"  />
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:stackLayout>
                    </uix:header>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat>
 
                      <uix:header textBinding="RCA_CONFIG_COMPONENT_TESTS@gensvc">
                        <uix:messagePrompt promptBinding="RCA_CONFIG_PAGE_TEXT1@gensvc"/>

                        <uix:tableLayout width="60%">
                          <uix:rowLayout>
                            <uix:spacer height="5"/>
                          </uix:rowLayout>
                          
                          <uix:rowLayout>                          
                            <uix:flowLayout>
                              <uix:spacer width="20" />
                              <uix:styledText textBinding="SYSTEM@gensvc" styleClass="OraPromptText" />
                              <uix:spacer width="5" />
                              <uix:styledText textBinding="<%=RCAConfigBean.SYSTEM_NAME_KEY%>" styleClass="OraDataText" />                   
                            </uix:flowLayout>
                          </uix:rowLayout>
                          
                          <uix:rowLayout>
                            <uix:spacer height="5"/>
                          </uix:rowLayout>
                         </uix:tableLayout>

                        <uix:table
                          columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
                          columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
                          tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
                          alternateTextBinding="NO_SYSTEM_SELECTED@gensvc"
                          width="80%"
                          id="<%=RCAConfigBean.KEY_COMPONENTS_KEY%>"
                          partialRenderMode="self"
                          blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
                          maxValueBinding="<%=PageViewBean.MAX_KEY%>"
                          valueBinding="<%=PageViewBean.START_KEY%>"
                          unvalidated="true"
                          formSubmitted="true"
                          summaryBinding="RCA_CONFIG_COMPONENT_TESTS@gensvc"
                          >
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="<%=UIConstants.TEXT_KEY%>"
                              sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>
                          <uix:contents>
                            <uix:text textBinding="<%=RCAConfigBean.KEY_COMPONENT_NAME%>"/>
                            <uix:text textBinding="<%=RCAConfigBean.KEY_COMPONENT_TYPE%>"/>
                            <uix:link 
                              onClick="submitForm('mainForm', 0, {}); return true;"
                              destinationBinding="<%=RCAConfigBean.KEY_COMPONENT_TEST_LINK%>"
                              textBinding="<%=RCAConfigBean.KEY_COMPONENT_TEST%>"/>
                          </uix:contents>
                        </uix:table>
                      </uix:header>
                    </uix:cellFormat>
                    
                   </uix:rowLayout>
                </uix:tableLayout>
              </uix:dataScope>
            </uix:form>

          </uix:header>
        </uix:dataScope>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
