<%--
/* $Header: gensvcTestsBcns.jsp 24-jul-2005.10:31:30 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Tests and Beacons page.

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      07/24/05 - 
    andyao      05/27/05 - refactor related links code 
    andyao      03/04/05 - use EmlConstants.RETURN_URL_PAGE_PROPERTY 
    andyao      02/07/05 - use the latest target selector 
    andyao      01/07/05 - 
    andyao      12/28/04 - 
    andyao      12/03/04 - use message.jspf 
    andyao      12/02/04 - add related links 
    andyao      11/18/04 - change tip text 
    andyao      10/21/04 - move error location 
    andyao      10/18/04 - modify for availability 
    andyao      10/13/04 - andyao_services4
    andyao      10/01/04 - Creation
 */

/**
 *  @version $Header: gensvcTestsBcns.jsp 24-jul-2005.10:31:30 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.GenSvcPageSegmentTypes' %>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

	<oem:setURLEncoder id="renderingContext"/>
	<uix:document>
		<%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
			<uix:pageLayout>
				<%@ include file="/oemGlobal.jspf"%>
				<uix:form name="mainForm" method="POST">
          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />
            <uix:formValue
              name="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              valueBinding="<%=GenSvcUIConstants.CURRENT_PAGE_KEY%>"
              />

            <%@ include file="/gensvc/message.jspf" %>
            <uix:header textBinding="TESTS_AND_BCNS@gensvc">
              <uix:tableLayout cellSpacing="5" borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messagePrompt promptBinding="TESTS_BCNS_PAGE_TEXT1@gensvc"/>
                  </uix:cellFormat>
                  <uix:cellFormat columnSpan="2" hAlign="right">
                    <uix:pageButtonBar>
                      <%-- the OK button --%>
                      <uix:submitButton 
                        textBinding="OK@common"     
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=GenSvcUIConstants.OK_EVENT%>"
                        formName="mainForm"
                        />
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout cellSpacing="5" borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:header textBinding="SERVICE_TESTS@gensvc">
                      <uix:link id="testsAnchor"/>
                      <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_TESTS%>"/>
                    </uix:header>
                  </uix:cellFormat>
                  <uix:cellFormat rowSpan="2">
                    <uix:spacer width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat rowSpan="2" vAlign="top" width="300">
                    <uix:contentContainer textBinding="TIP@gensvc" width="300">
                      <uix:styledText styleClass="OraInstructionText">
                        <uix:rawText 
                          textBinding="TESTS_BCNS_PAGE_TIP_TEXT1@gensvc"/>
                      </uix:styledText>
                    </uix:contentContainer>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:header textBinding="BEACONS@gensvc">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="TESTS_BCNS_PAGE_TEXT2@gensvc"/>
                          <uix:link id="beaconsAnchor"/>
                          <uix:ref refID="<%=GenSvcPageSegmentTypes.GENERIC_SERVICE_BEACONS%>"/>
                        </uix:contents>
                    </uix:header>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <%@ include file="/gensvc/relatedLinks.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:dataScope>
        </uix:form>
        <uix:contentFooter>
          <%-- the OK button --%>
          <uix:pageButtonBar>
            <uix:submitButton 
              textBinding="OK@common"     
              name="<%=UIConstants.EVENT_PARAM%>" 
              value="<%=GenSvcUIConstants.OK_EVENT%>"
              formName="mainForm"
              />
          </uix:pageButtonBar>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
