<%--
/* $Header: availability.jsp 13-jun-2005.15:32:05 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The JSP for the Services - Availability page segment 

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - 
    andyao      02/09/05 - fix bug 4089604 
    andyao      01/07/05 - remove html comment 
    andyao      12/28/04 - 
    andyao      12/03/04 - remove error.jspf 
    andyao      11/18/04 - add tip 
    andyao      11/11/04 - fix availability display in view mode 
    andyao      10/20/04 - fix location of availability drop down 
    andyao      10/18/04 - modify for availability page 
    andyao      09/20/04 - Creation
 */

/**
 *  @version $Header: availability.jsp 13-jun-2005.15:32:05 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.AvailabilityPageViewBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:stackLayout renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>">
      <uix:contents>
        <uix:switcher childNameBinding="<%=AvailabilityPageViewBean.UP_CONDITION_KEY%>">
          <uix:case name="<%=AvailabilityPageViewBean.UP_IF_ALL_KEY%>">
            <uix:styledText 
              textBinding="UP_IF_ALL_KEY_COMPONENTS@gensvc" 
              styleClass="OraPromptText"
              renderedBinding="<%=AvailabilityPageViewBean.BASED_ON_SYSTEM_KEY%>"
              /> 
          </uix:case>
          <uix:case name="<%=AvailabilityPageViewBean.UP_IF_ANY_KEY%>">
            <uix:styledText 
              textBinding="UP_IF_ONE_KEY_COMPONENT@gensvc" 
              styleClass="OraPromptText"
              renderedBinding="<%=AvailabilityPageViewBean.BASED_ON_SYSTEM_KEY%>"
              />
          </uix:case>
        </uix:switcher>
      </uix:contents>
    </uix:stackLayout>

 
    <%-- edit or create mode --%>
    <uix:tableLayout cellSpacing="5" width="100%">
      <uix:rowLayout>
        <uix:cellFormat vAlign="top">
          <uix:tableLayout 
            cellSpacing="5" 
            borderWidth="0" 
            width="100%"
            renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>">

            <uix:rowLayout renderedBinding="<%=AvailabilityPageViewBean.IS_CREATE_MODE%>">
              <uix:cellFormat columnSpan="3">
                <uix:styledText textBinding="AVAILABILITY_PAGE_TEXT1@gensvc" styleClass="OraInstructionText"/> 
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat columnSpan="2">
                <uix:messageRadioGroup
                  promptBinding="DEFINE_AVAILABILITY_ON@gensvc"
                  name="<%=AvailabilityPageViewBean.AVAIL_KEY%>"
                  selectedValueBinding="<%=AvailabilityPageViewBean.AVAIL_KEY%>"
                  textBinding="<%=UIConstants.TEXT_KEY%>"
                  valueBinding="<%=UIConstants.VALUE_PARAM%>"
                  childDataBinding="<%=AvailabilityPageViewBean.AVAIL_CHOICES_KEY%>"
                  type="choice"
                  onChange="submitForm('mainForm',0,{'event':'changeAvailability'});return false;"
                  renderedBinding="<%=AvailabilityPageViewBean.SHOW_AVAIL_OPTION_KEY%>"
                  shortDescBinding="AVAILABILITY@gensvc"
                  />
                <uix:styledText styleClass="OraDataText"
                  textBinding="<%=AvailabilityPageViewBean.BASED_ON_TEXT_KEY%>"
                  renderedBinding="<%=AvailabilityPageViewBean.HIDE_AVAIL_OPTION_KEY%>"
                  />
                <uix:formValue 
                  name="<%=AvailabilityPageViewBean.AVAIL_KEY%>"
                  valueBinding="<%=AvailabilityPageViewBean.BASED_ON_VALUE_KEY%>"
                  renderedBinding="<%=AvailabilityPageViewBean.HIDE_AVAIL_OPTION_KEY%>"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer width="10"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:radioGroup
                  name="<%=AvailabilityPageViewBean.UP_CONDITION_KEY%>"
                  selectedValueBinding="<%=AvailabilityPageViewBean.UP_CONDITION_KEY%>"
                  textBinding="<%=UIConstants.TEXT_KEY%>"
                  valueBinding="<%=UIConstants.VALUE_PARAM%>"
                  childDataBinding="<%=AvailabilityPageViewBean.UP_CONDITION_CHOICES_KEY%>"
                  renderedBinding="<%=AvailabilityPageViewBean.SHOW_UP_CONDITION_KEY%>"
                  />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:cellFormat>

        <uix:cellFormat renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>">
          <uix:spacer width="20"/>
        </uix:cellFormat>

        <uix:cellFormat vAlign="top" renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>">
          <uix:contentContainer textBinding="TIP@gensvc" width="300">
            <uix:styledText styleClass="OraInstructionText">
              <uix:rawText 
                textBinding="AVAILABILITY_PAGE_TIP_TEXT1@gensvc"/>
            </uix:styledText>
          </uix:contentContainer>
        </uix:cellFormat>

      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
