<%--
/* $Header: beacons.jsp 07-may-2007.14:06:42 rgraham Exp $ */

/* Copyright (c) 2004, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rgraham     05/07/07 - add os, version columns to beacons table
    andyao      04/27/07 - add platform and version
    mvajapey    07/28/05 - not use partial 
    andyao      07/24/05 - add fire partial action 
    andyao      07/13/05 - add short desc 
    andyao      06/13/05 - add table summary 
    andyao      02/07/05 - use the latest target selector 
    andyao      01/28/05 - add read only key column 
    andyao      01/07/05 - move global button using tableActions 
    andyao      01/05/05 - add row banding 
    andyao      01/03/05 - disable beacons link 
    andyao      12/23/04 - add beacon status link 
    andyao      12/05/04 - add local beacon change event 
    andyao      12/03/04 - remove error.jspf 
    andyao      11/18/04 - add page text and tip text 
    andyao      11/05/04 - remove deselect/select all 
    andyao      11/01/04 - add Create Beacon 
    andyao      10/18/04 - modify for availability page 
    andyao      09/29/04 - add beacon status icon 
    andyao      09/20/04 - fix formats 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: beacons.jsp 07-may-2007.14:06:42 rgraham Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.BeaconsPageViewBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <%-- read only --%>
    <uix:table
      columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
      columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
      tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
      alternateTextBinding="NO_BEACONS_ADDED@gensvc"
      width="80%"
      id="<%=BeaconsPageViewBean.BEACONS_KEY%>"
      partialRenderMode="self"
      blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
      maxValueBinding="<%=PageViewBean.MAX_KEY%>"
      valueBinding="<%=PageViewBean.START_KEY%>"
      unvalidated="true"
      formSubmitted="true"
      renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>"
      summaryBinding="BEACONS@gensvc"
      >
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
      </uix:columnHeaderStamp>

      <uix:contents>
        <uix:text textBinding="<%=BeaconsPageViewBean.NAME_KEY%>"/>
        <uix:image 
          shortDescBinding="<%=BeaconsPageViewBean.STATUS_LABEL_KEY%>" 
          sourceBinding="<%=BeaconsPageViewBean.STATUS_ICON_KEY%>"/>
        <uix:checkBox 
          checkedBinding="<%=BeaconsPageViewBean.KEY_BEACON_KEY%>" 
          name="<%=BeaconsPageViewBean.KEY_BEACON_KEY%>" 
          readOnly="true"
          shortDescBinding="KEY_BEACON@gensvc"
          />
          <uix:text
            textBinding="<%=BeaconsPageViewBean.VER_KEY%>"/>
          <uix:text
            textBinding="<%=BeaconsPageViewBean.OS_KEY%>"/>
      </uix:contents>
    </uix:table>

    <uix:tableLayout width="100%" cellSpacing="5">

      <uix:rowLayout renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"> 
        <uix:cellFormat vAlign="top">
          <uix:stackLayout>
            <uix:messagePrompt promptBinding="BEACONS_PAGE_TEXT1@gensvc"/>
            <uix:spacer height="10"/>
          </uix:stackLayout>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"> 
        <uix:cellFormat vAlign="top">
          <uix:stackLayout>
            <uix:messagePrompt promptBinding="BEACONS_PAGE_TEXT2@gensvc"/>
          </uix:stackLayout>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat vAlign="top">
          <uix:tableLayout 
            width="80%" 
            cellSpacing="5" 
            borderWidth="0" 
            renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>"> 

            <uix:rowLayout>
              <uix:table
                columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
                columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
                tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
                alternateTextBinding="NO_BEACONS_ADDED@gensvc"
                width="100%"
                id="<%=BeaconsPageViewBean.BEACONS_KEY%>"
                partialRenderMode="self"
                blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
                maxValueBinding="<%=PageViewBean.MAX_KEY%>"
                valueBinding="<%=PageViewBean.START_KEY%>"
                unvalidated="true"
                formSubmitted="true"
                summaryBinding="BEACONS@gensvc"
                >
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:sortableHeader 
                    textBinding="<%=UIConstants.TEXT_KEY%>" 
                    sortableBinding="sortable"
                    />
                </uix:columnHeaderStamp>
                <uix:tableActions>
                  <uix:flowLayout renderedBinding="<%=BeaconsPageViewBean.SHOW_BUTTONS_ABOVE_TABLE_KEY%>">
                    <uix:contents>
                      <%-- commented out de select and select options --%>
                      <%--
                      <uix:submitButton
                        textBinding="DESELECT_ALL_AS_KEY_BEACONS@gensvc"
                        name="<%=UIConstants.EVENT_PARAM%>"
                        value="<%=BeaconsPageViewBean.DESELECT_ALL_KEY_BCNS_EVENT%>"
                        renderedBinding="<%=BeaconsPageViewBean.SHOW_KEY_COLUMN_KEY%>"
                        />
                      <uix:submitButton
                        textBinding="SELECT_ALL_AS_KEY_BEACONS@gensvc"
                        name="<%=UIConstants.EVENT_PARAM%>"
                        value="<%=BeaconsPageViewBean.SELECT_ALL_KEY_BCNS_EVENT%>"
                        renderedBinding="<%=BeaconsPageViewBean.SHOW_KEY_COLUMN_KEY%>"
                        />
                      --%>
                      <oem:targetSelection textBinding="ADD@common" />
                      <uix:submitButton
                        textBinding="CREATE@common"
                        name="<%=UIConstants.EVENT_PARAM%>"
                        value="<%=BeaconsPageViewBean.CREATE_EVENT%>"
                        />
                    </uix:contents>
                  </uix:flowLayout>
                </uix:tableActions>
                <uix:tableSelection>
                  <uix:multipleSelection renderedBinding="<%=BeaconsPageViewBean.SHOW_SELECTION_COLUMN_KEY%>"
                    shortDescBinding="<%=BeaconsPageViewBean.NAME_KEY%>"
                    >
                    <uix:contents>
                      <uix:submitButton 
                        textBinding="VERIFY_SERVICE_TEST@gensvc" 
                        name="<%=UIConstants.EVENT_PARAM%>" 
                        value="<%=BeaconsPageViewBean.INTERACTIVE_TEST_EVENT%>"
                        renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"
                        />
                      <uix:submitButton 
                        textBinding="REMOVE@common" 
			name="<%=UIConstants.EVENT_PARAM%>"
			value="<%=BeaconsPageViewBean.REMOVE_EVENT%>"
			/>
                    </uix:contents>
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:contents>
                  <uix:text
                    textBinding="<%=BeaconsPageViewBean.NAME_KEY%>"/>

                  <%--<uix:link 
                    textBinding="<%=BeaconsPageViewBean.NAME_KEY%>" 
                    destinationBinding="<%=BeaconsPageViewBean.NAME_DEST_KEY%>"/>--%>
                  <uix:image 
                    shortDescBinding="<%=BeaconsPageViewBean.STATUS_LABEL_KEY%>" 
                    destinationBinding="<%=BeaconsPageViewBean.STATUS_DEST_KEY%>"
                    sourceBinding="<%=BeaconsPageViewBean.STATUS_CLICKABLE_ICON_KEY%>"/>

                  <uix:flowLayout renderedBinding="<%=BeaconsPageViewBean.SHOW_KEY_COLUMN_KEY%>">
                    <uix:contents>
                      <uix:checkBox 
                        checkedBinding="<%=BeaconsPageViewBean.KEY_BEACON_KEY%>" 
                        name="<%=BeaconsPageViewBean.KEY_BEACON_KEY%>" 
                        renderedBinding="<%=BeaconsPageViewBean.SHOW_MUTABLE_KEY_COLUMN_KEY%>"
                        shortDescBinding="KEY_BEACON@gensvc"
                        />
                      <uix:switcher childNameBinding="<%=BeaconsPageViewBean.KEY_BEACON_KEY%>">
                        <uix:case name="true">
                          <uix:image sourceBinding="isKeyImageSource" shortDescBinding="KEY_BEACONS@gensvc" renderedBinding="<%=BeaconsPageViewBean.SHOW_READONLY_KEY_COLUMN_KEY%>"/>
                        </uix:case>
                        <uix:default>
                          <uix:text text="" renderedBinding="<%=BeaconsPageViewBean.SHOW_READONLY_KEY_COLUMN_KEY%>"/>
                        </uix:default>
                      </uix:switcher>
                    </uix:contents>
                  </uix:flowLayout>

                  <uix:text
                    textBinding="<%=BeaconsPageViewBean.VER_KEY%>"/>
                  <uix:text
                    textBinding="<%=BeaconsPageViewBean.OS_KEY%>"/>

                </uix:contents>
              </uix:table>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:cellFormat>

        <uix:cellFormat vAlign="top" renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>" rowSpan="2">
          <uix:spacer width="10"/>
        </uix:cellFormat>

        <uix:cellFormat vAlign="top" renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>" rowSpan="2">
          <uix:contentContainer textBinding="TIP@gensvc" width="300">
            <uix:styledText styleClass="OraInstructionText">
              <uix:rawText textBinding="BEACONS_PAGE_TIP_TEXT1@gensvc"/>
            </uix:styledText>
          </uix:contentContainer>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="<%=BeaconsPageViewBean.SHOW_LOCAL_BEACONS_KEY%>">
        <uix:cellFormat vAlign="top">
          <uix:messageChoice
            name="<%=BeaconsPageViewBean.LOCAL_BEACON_KEY%>"
            id="<%=BeaconsPageViewBean.LOCAL_BEACON_KEY%>"
            promptBinding="LOCAL_BEACON@gensvc"
            selectedValueBinding="<%=BeaconsPageViewBean.LOCAL_BEACON_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>"
            >
            <uix:contents childDataBinding="<%=BeaconsPageViewBean.LOCAL_BEACON_KEY%>" >
              <uix:option 
                textBinding="<%=UIConstants.TEXT_KEY%>" 
                valueBinding="<%=UIConstants.VALUE_PARAM%>"
                />
            </uix:contents>
            <uix:end>
              <uix:submitButton 
                renderedBinding="<%=PageViewBean.IS_EDIT_MODE%>"
                unvalidated="true" 
                textBinding="CHANGE@gensvc" 
                primaryClientActionBinding="changeLocalBeaconAction"/>
            </uix:end>
          </uix:messageChoice>
          <uix:messageTextInput
            name="<%=BeaconsPageViewBean.LOCAL_BEACON_KEY%>"
            promptBinding="LOCAL_BEACON@gensvc"
            textBinding="<%=BeaconsPageViewBean.LOCAL_BEACON_VALUE_KEY%>"
            styleClass="OraDataText"
            renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>"
            readOnly="true"
            /> 
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

  </uix:dataScope>
</oem:pageSegment>
