<%--
/* $Header: busMetrics.jsp 06-nov-2006.21:48:59 andyao Exp $ */

/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The JSP for the Services - Business Metric page segment 

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
     andyao     11/06/06 - use switcher
     eporter    03/22/06 - Creation
 */

/**
 *  @version $Header: busMetrics.jsp 06-nov-2006.21:48:59 andyao Exp $
 *  @author  eporter  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.MetricsPageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.BusMetricsPageViewBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="bam" class="oracle.sysman.resources.eml.bam.BamMsg" />
    <uix:bundle name="sdk" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:stackLayout renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>">
      <uix:contents>
        <%-- detail metric table --%>
        <uix:table
          columnHeaderDataBinding="<%=MetricsPageViewBean.COLUMN_HEADER_DATA_KEY%>"
          columnFormatsBinding="<%=MetricsPageViewBean.COLUMN_FORMATS_DATA_KEY%>"
          tableDataBinding="<%=MetricsPageViewBean.TABLE_DATA_KEY%>"
          alternateTextBinding="NO_BUSINESS_METRICS@gensvc"
          width="80%"
          id="<%=BusMetricsPageViewBean.METRICS_KEY%>"
          partialRenderMode="self"
          blockSizeBinding="<%=MetricsPageViewBean.BLOCK_SIZE_KEY%>"
          maxValueBinding="<%=MetricsPageViewBean.MAX_KEY%>"
          valueBinding="<%=MetricsPageViewBean.START_KEY%>"
          unvalidated="true"
          formSubmitted="true"
          summaryBinding="BUSINESS_METRICS@gensvc"
          >
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
          </uix:columnHeaderStamp>

          <uix:contents>
            <uix:text textBinding="<%=MetricsPageViewBean.NAME_KEY%>"/>
            <uix:text textBinding="<%=MetricsPageViewBean.OPERATOR_VALUE_KEY%>"/>
            <uix:text textBinding="<%=MetricsPageViewBean.WARN_THRESHOLD_KEY%>"/>
            <uix:text textBinding="<%=MetricsPageViewBean.CRIT_THRESHOLD_KEY%>"/>
          </uix:contents>
        </uix:table>
      </uix:contents>
    </uix:stackLayout>

    <uix:tableLayout cellSpacing="5" borderWidth="0" width="80%" renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>">

      <uix:rowLayout>
        <uix:messagePrompt promptBinding="BUSINESS_PAGE_TEXT1@gensvc"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:messagePrompt promptBinding="BUSINESS_PAGE_CANNOT_ADD_METRIC@gensvc"
          renderedBinding="<%=MetricsPageViewBean.SHOW_CANNOT_ADD_METRIC_KEY%>"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <%-- detail metric table --%>
        <uix:table
          columnHeaderDataBinding="<%=MetricsPageViewBean.COLUMN_HEADER_DATA_KEY%>"
          columnFormatsBinding="<%=MetricsPageViewBean.COLUMN_FORMATS_DATA_KEY%>"
          tableDataBinding="<%=MetricsPageViewBean.TABLE_DATA_KEY%>"
          alternateTextBinding="NO_BUSINESS_METRICS@gensvc"
          width="100%"
          id="<%=BusMetricsPageViewBean.METRICS_KEY%>"
          partialRenderMode="self"
          blockSizeBinding="<%=MetricsPageViewBean.BLOCK_SIZE_KEY%>"
          maxValueBinding="<%=MetricsPageViewBean.MAX_KEY%>"
          valueBinding="<%=MetricsPageViewBean.START_KEY%>"
          unvalidated="true"
          formSubmitted="true"
          summaryBinding="BUSINESS_METRICS@gensvc"
          >
          <uix:tableActions>
            <uix:flowLayout>
              <uix:formValue 
                name="<%=MetricsPageViewBean.METRIC_SOURCE_KEY%>" 
                value="<%=MetricsPageViewBean.SYSTEM_PARAM%>"/>
              <uix:submitButton 
                textBinding="ADD@common" 
                name="<%=UIConstants.EVENT_PARAM%>" 
                value="<%=MetricsPageViewBean.ADD_METRIC_EVENT%>"
                renderedBinding="<%=MetricsPageViewBean.SHOW_ADD_METRIC_KEY%>"
                />
            </uix:flowLayout>
          </uix:tableActions>
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:sortableHeader 
              textBinding="<%=UIConstants.TEXT_KEY%>" 
              sortableBinding="sortable"
              />
          </uix:columnHeaderStamp>
          <uix:tableSelection>
            <uix:singleSelection selectedIndex="0" shortDescBinding="<%=MetricsPageViewBean.NAME_KEY%>">
              <uix:contents>
                <uix:submitButton 
                  textBinding="DELETE@common" 
                  primaryClientActionBinding="deleteMetricAction"
                  />
                <uix:submitButton 
                  textBinding="EDIT@common" 
                  name="<%=UIConstants.EVENT_PARAM%>" 
                  value="<%=MetricsPageViewBean.EDIT_EVENT%>"
                  />
              </uix:contents>
            </uix:singleSelection>
          </uix:tableSelection>

          <uix:contents>
            <uix:textInput 
              textBinding="<%=MetricsPageViewBean.NAME_KEY%>" 
              name="<%=MetricsPageViewBean.NAME_KEY%>"
              columns="64"
              readOnlyBinding="<%=MetricsPageViewBean.READ_ONLY_KEY%>"
              shortDescBinding="METRIC_NAME@gensvc"
              required="yes"
              />
            <uix:choice 
              selectedValueBinding="<%=MetricsPageViewBean.OPERATOR_KEY%>" 
              shortDescBinding="COMPARISON_OPERATOR@gensvc"
              name="<%=MetricsPageViewBean.OPERATOR_KEY%>">
              <uix:contents 
                childDataBinding="<%=BusMetricsPageViewBean.OPERATORS_KEY%>"
                >
                <uix:option 
                  textBinding="<%=UIConstants.TEXT_KEY%>" 
                  valueBinding="value"
                  />
              </uix:contents>
            </uix:choice>
            <uix:textInput 
              textBinding="<%=MetricsPageViewBean.WARN_THRESHOLD_KEY%>" 
              name="<%=MetricsPageViewBean.WARN_THRESHOLD_KEY%>"
              styleClass="OraFieldNumber"
              shortDescBinding="WARNING_THRESHOLD@gensvc"
              />
            <uix:textInput 
              textBinding="<%=MetricsPageViewBean.CRIT_THRESHOLD_KEY%>" 
              name="<%=MetricsPageViewBean.CRIT_THRESHOLD_KEY%>"
              styleClass="OraFieldNumber"
              shortDescBinding="CRITICAL_THRESHOLD@gensvc"
              />
          </uix:contents>
        </uix:table>
      </uix:rowLayout>

      <uix:rowLayout>
        <%@ include file="nonPromoted.jspf" %>
      </uix:rowLayout>
    
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
