<%--
/* $Header: general.jsp 18-jul-2006.15:50:53 yxie Exp $ */

/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 the JSP for the Services General Information page

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    yxie        07/18/06 - Backport yxie_bug-5344920 from main
    yxie        06/27/06 - Fix security bug 5344920
    andyao      04/12/05 - 
    andyao      01/07/05 - remove html comment 
    andyao      12/03/04 - remove error.jspf 
    andyao      12/02/04 - fix timezone 
    andyao      10/29/04 - add properties 
    andyao      09/20/04 - fix formats 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: general.jsp 18-jul-2006.15:50:53 yxie Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.GeneralPageViewBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:tableLayout borderWidth="0" cellSpacing="5">
      <uix:rowLayout>
        <uix:switcher childNameBinding="<%=PageViewBean.PAGE_MODE_KEY%>">
          <uix:case name="<%=PageViewBean.CREATE_MODE%>">
            <uix:messagePrompt promptBinding="GENERAL_PAGE_TEXT1@gensvc"/>
          </uix:case>
          <uix:case name="<%=PageViewBean.EDIT_MODE%>">
            <uix:messagePrompt promptBinding="GENERAL_PAGE_TEXT2@gensvc"/>
          </uix:case>
        </uix:switcher>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:labeledFieldLayout fieldWidth="80%" labelWidth="20%">

          <%-- the name of the service --%>
          <uix:messageTextInput 
            promptBinding="NAME@common"
            readOnlyBinding="<%=GeneralPageViewBean.READ_ONLY_AND_REQUIRED_KEY%>"
            styleClassBinding="<%=GeneralPageViewBean.READ_ONLY_TEXT_STYLE_KEY%>"
            name="<%=GeneralPageViewBean.SERVICE_NAME_KEY%>" 
            textBinding="<%=GeneralPageViewBean.SERVICE_NAME_KEY%>"
            requiredBinding="<%=GeneralPageViewBean.REQUIRED_KEY%>"
            columns="64"
            maximumLength="256"
            />

          <%-- time zone is a drop down or a read only text field --%>

          <uix:messageChoice
            name="<%=GeneralPageViewBean.SERVICE_TIME_ZONE_KEY%>"
            promptBinding="TIME_ZONE@gensvc"
            selectedValueBinding="<%=GeneralPageViewBean.SERVICE_TIME_ZONE_VALUE_KEY%>"
            readOnlyBinding="<%=GeneralPageViewBean.READ_ONLY_KEY%>"
            tipBinding="CHOOSE_TIME_ZONE_TEXT1@gensvc"
            renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"
            >
            <uix:contents childDataBinding="<%=GeneralPageViewBean.SERVICE_TIME_ZONE_KEY%>" >
              <uix:option 
                textBinding="<%=UIConstants.TEXT_KEY%>" 
                valueBinding="<%=UIConstants.VALUE_PARAM%>"
                />
            </uix:contents>
          </uix:messageChoice>

          <uix:messageTextInput
            name="<%=GeneralPageViewBean.SERVICE_TIME_ZONE_KEY%>"
            readOnly="true"
            promptBinding="TIME_ZONE@gensvc"
            textBinding="<%=GeneralPageViewBean.SERVICE_TIME_ZONE_DISPLAY_VALUE_KEY%>"
            styleClass="OraDataText"
            renderedBinding="<%=PageViewBean.NOT_CREATE_MODE%>"
            /> 
        </uix:labeledFieldLayout>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:include nodeBinding="<%=GeneralPageViewBean.PROPERTY_KEY%>"/>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
