<%--
/* $Header: performance.jsp 06-nov-2006.21:48:59 andyao Exp $ */

/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
	 The jsp of the performance page

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      11/06/06 - use switcher
    eporter     06/27/06 - Show non-promoted metrics
    andyao      07/24/05 - add partial action 
    andyao      06/13/05 - add table summary 
    andyao      03/09/05 - fix bug 4178468 
    andyao      02/04/05 - metric name required 
    andyao      01/28/05 - right align threshold columns
    andyao      01/07/05 - move global button using tableActions 
    andyao      01/05/05 - add row banding 
    andyao      12/23/04 - add operators 
    andyao      12/03/04 - remove error.jspf 
    andyao      12/01/04 - limit test/system based agg metric selection 
    andyao      11/17/04 - add tip for default chart 
    andyao      10/26/04 - fix width 
    andyao      10/25/04 - 
    andyao      09/20/04 - fix formats 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: performance.jsp 06-nov-2006.21:48:59 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.MetricsPageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PerfPageViewBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
    <uix:bundle name="bam" class="oracle.sysman.resources.eml.bam.BamMsg" />
    <uix:bundle name="sdk" class="oracle.sysman.emSDK.eml.SDKUIMsg" />

    <uix:stackLayout renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>">
      <uix:contents>
        <uix:table
          columnHeaderDataBinding="<%=PerfPageViewBean.COLUMN_HEADER_DATA_KEY%>"
          columnFormatsBinding="<%=PerfPageViewBean.COLUMN_FORMATS_DATA_KEY%>"
          tableDataBinding="<%=PerfPageViewBean.TABLE_DATA_KEY%>"
          alternateTextBinding="NO_PERFORMANCE_METRICS@gensvc"
          width="80%"
          id="<%=PerfPageViewBean.METRICS_KEY%>"
          partialRenderMode="self"
          blockSizeBinding="<%=PerfPageViewBean.BLOCK_SIZE_KEY%>"
          maxValueBinding="<%=PerfPageViewBean.MAX_KEY%>"
          valueBinding="<%=PerfPageViewBean.START_KEY%>"
          unvalidated="true"
          formSubmitted="true"
          summaryBinding="PERFORMANCE_METRICS@gensvc"
          >
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
          </uix:columnHeaderStamp>

          <uix:contents>
            <uix:text textBinding="<%=PerfPageViewBean.NAME_KEY%>"/>
            <uix:text textBinding="<%=PerfPageViewBean.OPERATOR_VALUE_KEY%>"/>
            <uix:text textBinding="<%=PerfPageViewBean.WARN_THRESHOLD_KEY%>"/>
            <uix:text textBinding="<%=PerfPageViewBean.CRIT_THRESHOLD_KEY%>"/>
          </uix:contents>
        </uix:table>
        <uix:spacer height="10"/>
        <uix:switcher childNameBinding="<%=MetricsPageViewBean.NO_METRIC_FOUND_KEY%>">
          <uix:case name="true">
            <uix:messageTextInput 
              promptBinding="DEFAULT_CHART_LABEL@gensvc"
              readOnly="true"
              textBinding="NO_METRIC_FOUND@gensvc"
              styleClass="OraDataText"
              />
          </uix:case>
          <uix:default>
            <uix:messageTextInput 
              promptBinding="DEFAULT_CHART_LABEL@gensvc"
              readOnly="true"
              textBinding="<%=MetricsPageViewBean.DEFAULT_CHART_VALUE_KEY%>"
              styleClass="OraDataText"
              />
          </uix:default>
        </uix:switcher>
      </uix:contents>
    </uix:stackLayout>

    <uix:tableLayout cellSpacing="5" borderWidth="0"  width="80%" renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>">
      <uix:rowLayout>
        <uix:messagePrompt promptBinding="PERFORMANCE_PAGE_TEXT1@gensvc"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:messagePrompt promptBinding="PERFORMANCE_PAGE_CANNOT_ADD_METRIC@gensvc"
          renderedBinding="<%=MetricsPageViewBean.SHOW_CANNOT_ADD_METRIC_KEY%>"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:table
          columnHeaderDataBinding="<%=PerfPageViewBean.COLUMN_HEADER_DATA_KEY%>"
          columnFormatsBinding="<%=PerfPageViewBean.COLUMN_FORMATS_DATA_KEY%>"
          tableDataBinding="<%=PerfPageViewBean.TABLE_DATA_KEY%>"
          alternateTextBinding="NO_PERFORMANCE_METRICS@gensvc"
          width="100%"
          id="<%=PerfPageViewBean.METRICS_KEY%>"
          partialRenderMode="multiple"
          partialTargets="chart"
          blockSizeBinding="<%=PerfPageViewBean.BLOCK_SIZE_KEY%>"
          maxValueBinding="<%=PerfPageViewBean.MAX_KEY%>"
          valueBinding="<%=PerfPageViewBean.START_KEY%>"
          unvalidated="true"
          formSubmitted="true"
          summaryBinding="PERFORMANCE_METRICS@gensvc"
          >
          <uix:tableActions>
            <uix:flowLayout>
              <uix:messageChoice 
                name="<%=PerfPageViewBean.METRIC_SOURCE_KEY%>" 
                promptBinding="ADD@common"
                renderedBinding="<%=MetricsPageViewBean.SHOW_ADD_METRIC_KEY%>"
                >
                <uix:contents>
                  <uix:option 
                    textBinding="BASED_ON_SERVICE_TEST@gensvc" 
                    value="<%=PerfPageViewBean.TEST_PARAM%>" 
                    renderedBinding="<%=MetricsPageViewBean.SHOW_TEST_BASED_KEY%>"
                    />
                  <uix:option 
                    textBinding="BASED_ON_SYSTEM@gensvc" 
                    renderedBinding="<%=MetricsPageViewBean.SHOW_SYSTEM_BASED_KEY%>"
                    value="<%=PerfPageViewBean.SYSTEM_PARAM%>"/>
                </uix:contents>
                <uix:end>
                  <uix:submitButton 
                    name="<%=UIConstants.EVENT_PARAM%>" 
                    value="<%=PerfPageViewBean.ADD_METRIC_EVENT%>" 
                    textBinding="GO@common"/>
                </uix:end>
              </uix:messageChoice>
            </uix:flowLayout>
          </uix:tableActions>

          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:sortableHeader textBinding="<%=UIConstants.TEXT_KEY%>" sortableBinding="sortable"/>
          </uix:columnHeaderStamp>

          <uix:tableSelection>
            <uix:singleSelection selectedIndex="0" shortDescBinding="<%=MetricsPageViewBean.NAME_KEY%>">
              <uix:contents>
                <uix:submitButton 
                  textBinding="DELETE@common" 
                  primaryClientActionBinding="deleteMetricAction"
                  />
                <uix:submitButton 
                  textBinding="EDIT@common" 
                  name="<%=UIConstants.EVENT_PARAM%>" 
                  value="<%=PerfPageViewBean.EDIT_EVENT%>"/>
              </uix:contents>
            </uix:singleSelection>
          </uix:tableSelection>

          <uix:contents>
            <uix:messageTextInput 
              textBinding="<%=MetricsPageViewBean.NAME_KEY%>" 
              name="<%=MetricsPageViewBean.NAME_KEY%>"
              columns="64"
              readOnlyBinding="<%=MetricsPageViewBean.READ_ONLY_KEY%>"
              required="yes"
              shortDescBinding="METRIC_NAME@gensvc"
              />
            <uix:choice 
              selectedValueBinding="<%=MetricsPageViewBean.OPERATOR_KEY%>" 
              shortDescBinding="COMPARISON_OPERATOR@gensvc"
              name="<%=MetricsPageViewBean.OPERATOR_KEY%>">
              <uix:contents 
                childDataBinding="<%=MetricsPageViewBean.OPERATORS_KEY%>"
                >
                <uix:option 
                  textBinding="<%=UIConstants.TEXT_KEY%>" 
                  valueBinding="value"
                  />
              </uix:contents>
            </uix:choice>

            <uix:textInput 
              textBinding="<%=MetricsPageViewBean.WARN_THRESHOLD_KEY%>" 
              name="<%=MetricsPageViewBean.WARN_THRESHOLD_KEY%>"
              styleClass="OraFieldNumber"
              shortDescBinding="WARNING_THRESHOLD@gensvc"
              />
            <uix:textInput 
              textBinding="<%=MetricsPageViewBean.CRIT_THRESHOLD_KEY%>" 
              name="<%=MetricsPageViewBean.CRIT_THRESHOLD_KEY%>"
              styleClass="OraFieldNumber"
              shortDescBinding="CRITICAL_THRESHOLD@gensvc"
              />
          </uix:contents>
        </uix:table>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="30"/>
      </uix:rowLayout>
      <uix:rowLayout id="chart">
        <uix:switcher childNameBinding="<%=MetricsPageViewBean.NO_METRIC_FOUND_KEY%>">
          <uix:case name="true">
            <uix:messageChoice 
              name="<%=MetricsPageViewBean.DEFAULT_CHART_KEY%>" 
              promptBinding="DEFAULT_CHART_LABEL@gensvc"
              id="<%=MetricsPageViewBean.DEFAULT_CHART_KEY%>"
              >
              <uix:contents>
                <uix:option 
                  textBinding="NO_METRIC_FOUND@gensvc"
                  value="0"
                  />
              </uix:contents>
            </uix:messageChoice>
          </uix:case>
          <uix:default>
            <uix:messageChoice 
              name="<%=MetricsPageViewBean.DEFAULT_CHART_KEY%>" 
              promptBinding="DEFAULT_CHART_LABEL@gensvc"
              selectedIndexBinding="<%=MetricsPageViewBean.DEFAULT_CHART_INDEX_KEY%>"
              id="<%=MetricsPageViewBean.DEFAULT_CHART_KEY%>"
              >
              <uix:contents childDataBinding="<%=MetricsPageViewBean.DEFAULT_CHART_KEY%>">
                <uix:option 
                  textBinding="<%=MetricsPageViewBean.NAME_KEY%>"
                  valueBinding="<%=UIConstants.VALUE_PARAM%>"
                  />
              </uix:contents>
            </uix:messageChoice>
          </uix:default>
        </uix:switcher>
      </uix:rowLayout>
      <uix:rowLayout>
        <%@ include file="nonPromoted.jspf" %>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
