<%--
/* $Header: systemBasedMetric.jsp 14-jun-2005.08:55:45 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - add table summary 
    andyao      04/13/05 - use display value for read only data 
    andyao      03/01/05 - cut over to the new metrics selector 
    andyao      02/25/05 - fix bug 4171049 
    andyao      02/10/05 - add required asterisk 
    andyao      01/23/05 - single object selection 
    andyao      01/07/05 - remove html comment 
    andyao      01/05/05 - add row banding 
    andyao      12/22/04 - fix layout 
    andyao      12/07/04 - fix key selector 
    andyao      12/03/04 - remove error.jspf 
    andyao      09/20/04 - fix formats 
    andyao      09/19/04 - add partial event 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: systemBasedMetric.jsp 14-jun-2005.08:55:45 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.MetricSourcePageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.SystemBasedMetricPageViewBean" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:tableLayout borderWidth="0" cellSpacing="5">
      <uix:rowLayout>
        <uix:styledText 
          textBinding="<%=MetricSourcePageViewBean.PAGE_TEXT_KEY%>" 
          styleClass="OraPromptText"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:labeledFieldLayout width="500" labelWidth="20%" fieldWidth="80%">
          <%-- system name --%>
          <uix:messageTextInput 
            promptBinding="SYSTEM_NAME@gensvc" 
            readOnly="true"
            name="<%=SystemBasedMetricPageViewBean.SYSTEM_NAME_KEY%>"
            styleClass="OraDataText"
            textBinding="<%=SystemBasedMetricPageViewBean.SYSTEM_NAME_KEY%>"
            />
          <uix:spacer height="10"/>
          <%-- the target types drop down --%>
          <uix:messageChoice 
            name="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_KEY%>" 
            promptBinding="TARGET_TYPE@gensvc"
            onChange="submitForm('mainForm',0,{'event':'targetTypeChanged'});return false;"
            selectedValueBinding="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"
            >
            <uix:contents childDataBinding="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_KEY%>">
              <uix:option textBinding="<%=UIConstants.TEXT_KEY%>" valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
            </uix:contents>
          </uix:messageChoice>

          <%-- the target type display name --%>
          <uix:messageTextInput
            promptBinding="TARGET_TYPE@gensvc"
            readOnly="true"
            styleClassBinding="<%=PageViewBean.READ_ONLY_TEXT_STYLE_KEY%>"
            renderedBinding="<%=PageViewBean.NOT_CREATE_MODE%>"
            textBinding="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_KEY%>"/>
          
          <uix:formValue
            name="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_KEY%>"
            valueBinding="<%=SystemBasedMetricPageViewBean.TARGET_TYPE_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.IS_EDIT_MODE%>"
            />
          <uix:spacer height="10"/>

          <%-- the metric drop down --%>
          <uix:messageChoice 
            name="<%=MetricSourcePageViewBean.METRIC_KEY%>" 
            promptBinding="METRIC@gensvc"
            selectedValueBinding="<%=MetricSourcePageViewBean.METRIC_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"
            onChange="submitForm('mainForm',0,{'event':'metricChanged'});return false;"
            >
            <uix:contents childDataBinding="<%=MetricSourcePageViewBean.METRIC_KEY%>">
              <uix:option 
                textBinding="<%=UIConstants.TEXT_KEY%>" 
                valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
            </uix:contents>
          </uix:messageChoice>

          <%-- the metric value --%>
          <uix:messageTextInput
            promptBinding="METRIC@gensvc"
            readOnly="true"
            styleClassBinding="<%=PageViewBean.READ_ONLY_TEXT_STYLE_KEY%>"
            textBinding="<%=SystemBasedMetricPageViewBean.METRIC_DISPLAY_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.NOT_CREATE_MODE%>"
            />
          <uix:formValue
            name="<%=SystemBasedMetricPageViewBean.METRIC_KEY%>"
            valueBinding="<%=SystemBasedMetricPageViewBean.METRIC_VALUE_KEY%>"
            renderedBinding="<%=PageViewBean.IS_EDIT_MODE%>"
            />


        </uix:labeledFieldLayout>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:header textBinding="SYSTEM_COMPONENTS@gensvc">

          <uix:tableLayout cellSpacing="5" borderWidth="0" width="100%">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>

              <uix:cellFormat>

                <uix:tableLayout cellSpacing="5" borderWidth="0">
                  <uix:rowLayout>
                    <uix:cellFormat columnSpan="2">
                      <%-- radio button choice to choose one component --%>	
                      <uix:messageRadioButton 
                        textBinding="PICK_ONE_COMPONENT@gensvc" 
                        name="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                        value="<%=MetricSourcePageViewBean.USE_SINGLE_KEY%>"
                        selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                        >
                        <uix:end>
                          <uix:flowLayout>
                            <uix:contents>
                              <%-- a list of all system components --%>
                              <uix:choice
                                name="<%=MetricSourcePageViewBean.SINGLE_DEP_KEY%>"
                                selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_DEP_VALUE_KEY%>"	
                                shortDescBinding="SYSTEM_COMPONENTS@gensvc"
                                >
                                <uix:contents 
                                  childDataBinding="<%=MetricSourcePageViewBean.SINGLE_DEP_KEY%>"
                                  >
                                  <uix:option 
                                    textBinding="<%=UIConstants.TEXT_KEY%>"
                                    valueBinding="<%=UIConstants.TEXT_KEY%>"/>
                                </uix:contents>
                              </uix:choice>
                              <uix:spacer width="10"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:end>
                      </uix:messageRadioButton>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showObjects@servletRequest">
                    <uix:spacer width="20"/>

                    <uix:messageLovField
                      name="<%=SystemBasedMetricPageViewBean.OBJECTS_KEY%>"
                      promptBinding="OBJECT@gensvc"
                      messageBinding="OBJECT_TIP@gensvc"
                      onClick="showMetrics('objects', null, true)"
                      required="uiOnly"
                      textBinding="<%=SystemBasedMetricPageViewBean.OBJECTS_KEY%>"
                      searchDescBinding="SEARCH@common"
                      />
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat columnSpan="2">
                      <uix:spacer height="20"/>
                      <%-- radio button choice to choose multiple components --%>
                      <uix:messageRadioButton
                        textBinding="PICK_MULTIPLE_COMPONENTS@gensvc"
                        name="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                        value="<%=MetricSourcePageViewBean.USE_MULTIPLE_KEY%>"
                        selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                        />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat rowSpan="4">
                      <uix:spacer width="20"/>
                    </uix:cellFormat>

                    <uix:cellFormat>
                      <%-- aggregation function --%>
                      <uix:messageChoice 
                        name="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_KEY%>"
                        promptBinding="AGGREGATE_FUNCTION@gensvc"
                        selectedValueBinding="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_VALUE_KEY%>"
                        messageBinding="AGGREGATE_COMPONENT_FUNCTION_TIP@gensvc"
                        >
                        <uix:contents childDataBinding="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_KEY%>">
                          <uix:option 
                            textBinding="<%=UIConstants.TEXT_KEY%>" 
                            valueBinding="<%=UIConstants.VALUE_PARAM%>"
                            />
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:messageChoice
                      name="<%=SystemBasedMetricPageViewBean.COMPONENTS_FILTER_KEY%>"
                      promptBinding="SHOW@gensvc"
                      selectedValueBinding="<%=SystemBasedMetricPageViewBean.COMPONENTS_FILTER_VALUE_KEY%>"
                      onChange="submitForm('mainForm',0,{'event':'componentsFilterChanged'});return false;"
                      >
                      <uix:contents>
                        <uix:option
                          textBinding="KEY_COMPONENTS_ONLY@gensvc"
                          value="<%=SystemBasedMetricPageViewBean.KEY_COMPONENTS_ONLY_KEY%>"
                          />
                        <uix:option
                          textBinding="ALL_COMPONENTS@gensvc"
                          value="<%=SystemBasedMetricPageViewBean.ALL_COMPONENTS_KEY%>"
                          />
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <%-- the components table --%>
                    <uix:table
                      columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
                      columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
                      tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
                      width="100%"
                      id="<%=MetricSourcePageViewBean.DEPS_KEY%>"
                      partialRenderMode="self"
                      blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
                      maxValueBinding="<%=PageViewBean.MAX_KEY%>"
                      valueBinding="<%=PageViewBean.START_KEY%>"
                      unvalidated="true"
                      formSubmitted="true"
                      summaryBinding="SYSTEM_COMPONENTS@gensvc"
                      >
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:columnHeaderStamp>
                        <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                      </uix:columnHeaderStamp>

                      <uix:tableSelection>
                        <uix:multipleSelection selectedBinding="selected" shortDescBinding="<%=UIConstants.TEXT_KEY%>"/>
                      </uix:tableSelection>

                      <uix:contents>
                        <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>

                        <uix:column renderedBinding="showObjects@servletRequest">
                          <uix:columnFormat cellNoWrapFormat="true"/>
                          <uix:contents>
                            <uix:flowLayout>
                            <uix:styledText styleClass="xc" text="* "/>
                            <uix:messageLovField
                              name="<%=SystemBasedMetricPageViewBean.OBJECTS_KEY%>"
                              onClickBinding="<%=SystemBasedMetricPageViewBean.OBJECTS_ONCLICK_KEY%>"
                              shortDescBinding="OBJECT@gensvc"
                              searchDescBinding="SEARCH@common"
                              textBinding="<%=SystemBasedMetricPageViewBean.OBJECTS_KEY%>"/>
                          </uix:flowLayout>
                          </uix:contents>
                        </uix:column>
                      </uix:contents>
                    </uix:table>
                  </uix:rowLayout>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:formValue name="lovId"/>

    <uix:rawText>
        <script language="JavaScript">
        function showMetrics(lovId)
        {   
          document.forms[0].lovId.value = lovId;
          openWindow(window, '../../pref/postBackWithEvent', 'lovWindow', {width:500, height:430}, true, 'dialog', null); 
          return false;
        }
        </script>
    </uix:rawText>
    <%@ include file="/oemNoscript.jspf" %>

  </uix:dataScope>
</oem:pageSegment>
