<%--
/* $Header: testBasedMetric.jsp 13-jun-2005.14:15:48 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The Test Based Metric page segment

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - add table summary 
    andyao      05/06/05 - add tip 
    yxie        03/01/05 - remove tip text
    andyao      03/02/05 - fix bug 4178401 
    andyao      01/07/05 - remove html comment 
    andyao      01/05/05 - add row banding 
    andyao      12/22/04 - fix layout 
    andyao      12/03/04 - remove error.jspf 
    andyao      11/15/04 - fix test based promotion 
    andyao      11/11/04 - add metric source 
    andyao      11/11/04 - add source 
    andyao      09/30/04 - UI and functionality changes 
    andyao      09/20/04 - fix formats 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: testBasedMetric.jsp 13-jun-2005.14:15:48 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.MetricSourcePageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.TestBasedMetricPageViewBean" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
    <uix:bundle name="httpTestRes" class="oracle.sysman.eml.gensvc.test.http.resources.HTTPTestResource"/>

    <uix:tableLayout borderWidth="0" width="100%">
      <uix:rowLayout>
        <uix:cellFormat width="80%">
          <uix:styledText styleClass="OraInstructionText" textBinding="<%=MetricSourcePageViewBean.PAGE_TEXT_KEY%>"/>
        </uix:cellFormat>
        <uix:cellFormat width="20%">
        </uix:cellFormat>

      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>
      
      <uix:rowLayout>
        <uix:labeledFieldLayout labelWidth="10%" fieldWidth="90%">
          <uix:contents>
            <%-- the Service Test Drop Down --%>
            <uix:messageChoice 
              name="<%=TestBasedMetricPageViewBean.TEST_NAMES_KEY%>" 
              promptBinding="SERVICE_TEST@gensvc"
              selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_NAME_VALUE_KEY%>"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_NAME_DROP_DOWN_KEY%>"
              onChange="submitForm('mainForm', 0, {event:'testChangedEvent'});return false"
              >
              <uix:contents childDataBinding="<%=TestBasedMetricPageViewBean.TEST_NAMES_KEY%>">
                <uix:option 
                  textBinding="<%=UIConstants.TEXT_KEY%>" 
                  valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
              </uix:contents>
            </uix:messageChoice>
              
            <%-- the Service Test Name --%>
            <uix:messageTextInput 
              readOnly="true" 
              styleClass="OraDataText" 
              promptBinding="SERVICE_TEST@gensvc" 
              textBinding="<%=TestBasedMetricPageViewBean.TEST_NAME_KEY%>"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_NAME_TEXT_KEY%>"
              />

            <uix:spacer height="10"/>
              
            <%-- the Service Test Type --%>
            <uix:messageTextInput
              readOnly="true"
              styleClass="OraDataText"
              promptBinding="TEST_TYPE@gensvc"
              textBinding="<%=TestBasedMetricPageViewBean.TEST_TYPE_KEY%>"
              />
          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:contents>
            <%-- radio button chocie to choose a txn --%>
            <uix:messageRadioButton
              promptBinding="SOURCE@gensvc"
              textBinding="HTTP_TRANSACTION@httpTestRes"
              name="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              value="<%=TestBasedMetricPageViewBean.USE_TEST_METRIC_SOURCE_TXN_KEY%>"
              selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              disabledBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_DISABLED_KEY%>"
              onClick="submitForm('mainForm', 0, {event:'testMetricSourceChangedEvent'});return false;"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_KEY%>"
              />

            <uix:spacer height="10"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_KEY%>"
              />

            <%-- radio button choice to choose a step--%>	
            <uix:messageRadioButton 
              textBinding="HTTP_PAGE@httpTestRes" 
              name="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              value="<%=TestBasedMetricPageViewBean.USE_TEST_METRIC_SOURCE_STEP_KEY%>"
              selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              disabledBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_DISABLED_KEY%>"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_STEP_KEY%>"
              onClick="submitForm('mainForm', 0, {event:'testMetricSourceChangedEvent'});return false;"
              >
              <uix:end>
                <uix:flowLayout>
                  <uix:contents>
                    <uix:spacer width="10"/>
                    <uix:choice
                      name="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEP_KEY%>"
                      selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEP_VALUE_KEY%>"	
                      shortDescBinding="HTTP_PAGE@httpTestRes" 
                      >
                      <uix:contents 
                        childDataBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEP_KEY%>"
                        >
                        <uix:option 
                          textBinding="<%=UIConstants.TEXT_KEY%>"
                          valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:contents>
                </uix:flowLayout>
              </uix:end>
            </uix:messageRadioButton>

            <uix:spacer height="10"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_KEY%>"
              />

            <%-- radio button choice to choose a stepgroup --%>	
            <uix:messageRadioButton 
              textBinding="HTTP_UAGROUP@httpTestRes" 
              name="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              value="<%=TestBasedMetricPageViewBean.USE_TEST_METRIC_SOURCE_STEPGROUP_KEY%>"
              selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_KEY%>" 
              disabledBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_DISABLED_KEY%>"
              renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_STEPGROUP_KEY%>"
              onClick="submitForm('mainForm', 0, {event:'testMetricSourceChangedEvent'});return false;"
              >
              <uix:end>
                <uix:flowLayout>
                  <uix:contents>
                    <uix:spacer width="10"/>
                    <uix:choice
                      name="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEPGROUP_KEY%>"
                      selectedValueBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEPGROUP_VALUE_KEY%>"	
                      shortDescBinding="HTTP_UAGROUP@httpTestRes" 
                      >
                      <uix:contents 
                        childDataBinding="<%=TestBasedMetricPageViewBean.TEST_METRIC_SOURCE_STEPGROUP_KEY%>"
                        >
                        <uix:option 
                          textBinding="<%=UIConstants.TEXT_KEY%>"
                          valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:contents>
                </uix:flowLayout>
              </uix:end>
            </uix:messageRadioButton>
          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"
          renderedBinding="<%=TestBasedMetricPageViewBean.SHOW_TEST_METRIC_SOURCE_KEY%>"
          />
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:contents>
            <%-- the Metric drop down --%>
            <uix:messageChoice 
              name="<%=MetricSourcePageViewBean.METRIC_KEY%>" 
              promptBinding="METRIC@gensvc"
              selectedValueBinding="<%=MetricSourcePageViewBean.METRIC_VALUE_KEY%>"
              renderedBinding="<%=MetricSourcePageViewBean.IS_CREATE_MODE%>"
              >
              <uix:contents childDataBinding="<%=MetricSourcePageViewBean.METRIC_KEY%>">
                <uix:option 
                  textBinding="<%=UIConstants.TEXT_KEY%>" 
                  valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
              </uix:contents>
            </uix:messageChoice>
            <%-- the Metric label --%>
            <uix:messageTextInput
              promptBinding="METRIC@gensvc"
              readOnly="true"
              styleClassBinding="<%=PageViewBean.READ_ONLY_TEXT_STYLE_KEY%>"
              textBinding="<%=MetricSourcePageViewBean.METRIC_KEY%>"
              renderedBinding="<%=MetricSourcePageViewBean.IS_EDIT_MODE%>"
              />

          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:rowLayout>
      <%-- beacon dep selection --%>
      <uix:rowLayout>
        <uix:header textBinding="BEACONS@gensvc">
          <uix:tableLayout cellSpacing="5" borderWidth="0">
            <uix:rowLayout>

              <uix:cellFormat columnSpan="2">
                <uix:stackLayout>
                  <uix:contents>
                    <%-- radio button choice to choose one component --%>	
                    <uix:messageRadioButton 
                      textBinding="PICK_ONE_BEACON@gensvc" 
                      name="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                      value="<%=MetricSourcePageViewBean.USE_SINGLE_KEY%>"
                      selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                      >
                      <uix:end>
                        <%-- a list of all system components --%>
                        <uix:choice
                          name="<%=MetricSourcePageViewBean.SINGLE_DEP_KEY%>"
                          selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_DEP_VALUE_KEY%>"	
                          shortDescBinding="BEACONS@gensvc"
                          >
                          <uix:contents 
                            childDataBinding="<%=MetricSourcePageViewBean.SINGLE_DEP_KEY%>"
                            >
                            <uix:option 
                              textBinding="<%=UIConstants.TEXT_KEY%>"
                              valueBinding="<%=UIConstants.TEXT_KEY%>"/>
                          </uix:contents>
                        </uix:choice>
                      </uix:end>
                    </uix:messageRadioButton>
                    <%-- radio button choice to choose multiple components --%>
                    <uix:messageRadioButton
                      textBinding="PICK_MULTIPLE_BEACONS@gensvc"
                      name="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                      value="<%=MetricSourcePageViewBean.USE_MULTIPLE_KEY%>"
                      selectedValueBinding="<%=MetricSourcePageViewBean.SINGLE_OR_MULTIPLE_KEY%>" 
                      />
                  </uix:contents>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat rowSpan="4">
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <%-- aggregation function --%>
                <uix:messageChoice 
                  name="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_KEY%>"
                  promptBinding="AGGREGATE_FUNCTION@gensvc"
                  messageBinding="AGGREGATE_BEACON_FUNCTION_TIP@gensvc"
                  selectedValueBinding="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_VALUE_KEY%>">
                  <uix:contents childDataBinding="<%=MetricSourcePageViewBean.AGGREGATE_FUNCTION_KEY%>">
                    <uix:option 
                      textBinding="<%=UIConstants.TEXT_KEY%>" 
                      valueBinding="<%=UIConstants.VALUE_PARAM%>"
                      />
                  </uix:contents>
                </uix:messageChoice>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <%-- the components table --%>
              <uix:table
                columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
                columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
                tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
                width="100%"
                id="<%=MetricSourcePageViewBean.DEPS_KEY%>"
                partialRenderMode="self"
                blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
                maxValueBinding="<%=PageViewBean.MAX_KEY%>"
                valueBinding="<%=PageViewBean.START_KEY%>"
                unvalidated="true"
                formSubmitted="true"
                summaryBinding="BEACONS@gensvc"
                >
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:columnHeaderStamp>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected" shortDescBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:tableSelection>

                <uix:contents>
                  <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:contents>
              </uix:table>

            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>

