<%--
/* $Header: testGeneral.jsp 21-jun-2007.21:38:36 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      05/27/05 - show description in view 
    andyao      02/11/05 - add collection interval 
    andyao      02/04/05 - move test type 
    andyao      01/21/05 - move test type up 
    andyao      01/21/05 - add maximum txn length 
    andyao      01/07/05 - remove html comment 
    andyao      12/15/04 - andyao_testpagesplit
    andyao      12/03/04 - remove error.jspf 
    andyao      11/23/04 - fix drop down selection 
    andyao      11/21/04 - fix test display 
    andyao      11/18/04 - add page text and tip text 
    andyao      10/27/04 - integration with txn management 
    andyao      10/18/04 - add HTTP Transaction section 
    andyao      09/20/04 - fix formats 
    andyao      09/09/04 - revisiting services code 
    andyao      08/24/04 - andyao_services
    andyao      08/01/04 - Creation
 */

/**
 *  @version $Header: testGeneral.jsp 21-jun-2007.21:38:36 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.TestGenUIBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:tableLayout renderedBinding="<%=TestGenUIBean.IS_TEST_DEFINED_KEY%>">

      <uix:rowLayout renderedBinding="<%=TestGenUIBean.IS_CREATE_MODE%>">
        <uix:styledText textBinding="TEST_PAGE_TEXT1@gensvc" styleClass="OraInstructionText"/> 
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="<%=TestGenUIBean.IS_CREATE_MODE%>">
        <uix:spacer height="20"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:tableLayout>
          <uix:rowLayout>
        <uix:cellFormat vAlign="top">
        <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%">
          <%-- test type in edit/view mode --%>
          <uix:messageTextInput
            promptBinding="TEST_TYPE@gensvc"
            textBinding="<%=TestGenUIBean.TEST_DISPLAY_TYPE_KEY%>"
            readOnly="true"
            styleClass="OraDataText"
            id="testType"
            name="<%=TestGenUIBean.TEST_DISPLAY_TYPE_KEY%>"
            renderedBinding="<%=TestGenUIBean.SHOW_TEST_TYPE_TEXT%>"
            />
          <%-- test type in create mode --%>
          <uix:messageChoice
            name="<%=TestGenUIBean.TEST_TYPE_KEY%>"
            promptBinding="TEST_TYPE@gensvc"
            selectedValueBinding="<%=TestGenUIBean.TEST_TYPE_KEY%>"
            renderedBinding="<%=TestGenUIBean.SHOW_TEST_TYPE_CHOICES%>"
            onChange="submitForm(this.form,0,{'event':'testTypeChangedEvent'});return false;"
            >
            <uix:contents childDataBinding="<%=TestGenUIBean.TEST_TYPE_DATA_KEY%>" >
              <uix:option 
                textBinding="<%=UIConstants.TEXT_KEY%>" 
                valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
            </uix:contents>
          </uix:messageChoice>


          <uix:formValue
            name="<%=TestGenUIBean.OLD_TEST_TYPE_KEY%>"
            valueBinding="<%=TestGenUIBean.OLD_TEST_TYPE_KEY%>"
            renderedBinding="<%=TestGenUIBean.SHOW_TEST_TYPE_CHOICES%>"
            />

          <uix:spacer height="5"/>

          <%-- name in create mode --%>
          <uix:messageTextInput 
            promptBinding="NAME@common"
            readOnlyBinding="<%=TestGenUIBean.READ_ONLY_AND_REQUIRED_KEY%>"
            styleClassBinding="<%=TestGenUIBean.READ_ONLY_TEXT_STYLE_KEY%>"
            name="<%=TestGenUIBean.TEST_NAME_KEY%>"
            textBinding="<%=TestGenUIBean.TEST_NAME_KEY%>"
            required="yes"
            columns="32"
            maximumLength="64"
            renderedBinding="<%=PageViewBean.IS_CREATE_MODE%>"
            />
          <%-- name in edit/view mode --%>
          <uix:messageTextInput 
            promptBinding="NAME@common"
            name="<%=TestGenUIBean.TEST_NAME_KEY%>"
            readOnly="true"
            styleClassBinding="<%=TestGenUIBean.READ_ONLY_TEXT_STYLE_KEY%>"
            textBinding="<%=TestGenUIBean.TEST_NAME_KEY%>"
            renderedBinding="<%=PageViewBean.NOT_CREATE_MODE%>"
            />
          <uix:spacer height="5"/>

          <%-- collection interval in edit/create mode --%>
          <uix:messageTextInput
            promptBinding="COLLECTION_INTERVAL_LABEL@gensvc"
            name="<%=TestGenUIBean.COLLECTION_INTERVAL_KEY%>"
            columns="10"
            required="yes"
            renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>"
            textBinding="<%=TestGenUIBean.COLLECTION_INTERVAL_KEY%>"
            styleClass="OraFieldNumber"
            />
          <%-- collection interval in view mode --%>
          <uix:messageTextInput 
            promptBinding="COLLECTION_INTERVAL_LABEL@gensvc"
            name="<%=TestGenUIBean.COLLECTION_INTERVAL_KEY%>"
            columns="10"
            readOnly="true"
            renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>"
            styleClass="OraDataNumber"
            textBinding="<%=TestGenUIBean.COLLECTION_INTERVAL_KEY%>"
            />

        </uix:labeledFieldLayout>
      </uix:cellFormat>
      <uix:cellFormat width="10px">
      </uix:cellFormat>

      <uix:cellFormat vAlign="bottom">

        <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%">

          <%-- description in edit/create mode --%>
          <uix:messageTextInput
            rows="3"
            promptBinding="DESCRIPTION@common"
            textBinding="<%=TestGenUIBean.DESCRIPTION_KEY%>"
            name="<%=TestGenUIBean.DESCRIPTION_KEY%>"
            columns="61"
            renderedBinding="<%=PageViewBean.NOT_VIEW_MODE%>"
            />
          <uix:messageStyledText
            promptBinding="DESCRIPTION@common"
            textBinding="<%=TestGenUIBean.DESCRIPTION_KEY%>"
            renderedBinding="<%=PageViewBean.IS_VIEW_MODE%>"
            styleClassBinding="<%=TestGenUIBean.READ_ONLY_TEXT_STYLE_KEY%>"
            />

        </uix:labeledFieldLayout>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
    </uix:rowLayout>

    </uix:tableLayout>

    <uix:messagePrompt 
      promptBinding="NO_TEST_DEFINED@gensvc" 
      renderedBinding="<%=TestGenUIBean.NO_TEST_DEFINED_KEY%>"/>
  </uix:dataScope>
</oem:pageSegment>
