<%--

/* $Header: testTxn.jsp 16-jul-2007.15:26:22 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    The JSP segment for displaying transaction recording button.

   NOTES
    None

   MODIFIED    (MM/DD/YY)
    rgraham     07/16/07 - add tip text
    andyao      06/28/07 - change layout
    rgraham     05/16/07 - Add play buttons
    andyao      05/15/07 - 
    rgraham     04/09/07 - Creation
 */

/**
 *  @version $Header: testTxn.jsp 16-jul-2007.15:26:22 rgraham Exp $
 *  @author  rgraham
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.TestTxnUIBean" %>

<oem:pageSegment>
<uix:dataScope currentDataBinding="bean">
  <uix:bundle name="websiteResourceBundle"
    class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:bundle name="gensvcResourceBundle"
    class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>

    <uix:stackLayout>
      <uix:separator>
        <uix:spacer height="10"/>
      </uix:separator>

      <uix:tableLayout width="100%" borderWidth="0" cellSpacing="5">

        <uix:rowLayout>
      
          <uix:cellFormat vAlign="top">
            <uix:messageLayout
              promptBinding="HTTP_TEST_OPTION_RECORD@gensvcResourceBundle"
              renderedBinding="<%=TestTxnUIBean.SHOW_RECORD_KEY%>">
              <uix:contents>
                <uix:submitButton 
                  textBinding="GO@websiteResourceBundle"
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.USER_ACTION_RECORD_EVENT%>"
                  disabledBinding="<%=TestTxnUIBean.DISABLE_RECORD_KEY%>"
                  renderedBinding="<%=TestTxnUIBean.SHOW_RECORD_KEY%>"
                  shortDescBinding="TXN_STEP_RECORD_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/>
              </uix:contents>
            </uix:messageLayout>
          </uix:cellFormat>

          <uix:cellFormat hAlign="right" vAlign="top" rowSpan="2">
            <uix:contentContainer id="instruction" width="450" textBinding="TIP@gensvc" renderedBinding="<%=TestTxnUIBean.SHOW_PLAY_MODE_KEY%>">
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="TXN_PLAYBACK_MODE_CHANGE@websiteResourceBundle" />
              </uix:flowLayout>
              
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionTextStrong"
                  textBinding="TXN_PLAYBACK_MODE_HTTP_REQUESTS@websiteResourceBundle" />
                <uix:spacer height="5"/>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="REQUEST_SIMULATION_TEXT@websiteResourceBundle" />
              </uix:flowLayout>

              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionTextStrong" renderedBinding="<%=TestTxnUIBean.SHOW_BROWSER_MODE_KEY%>"
                  textBinding="TXN_PLAYBACK_MODE_DHTML_SCRIPT@websiteResourceBundle" />
                <uix:spacer height="5"/>
                <uix:styledText styleClass="OraInstructionText" renderedBinding="<%=TestTxnUIBean.SHOW_BROWSER_MODE_KEY%>"
                  textBinding="BROWSER_SIMULATION_TEXT@websiteResourceBundle" />
              </uix:flowLayout>
            </uix:contentContainer>
          </uix:cellFormat> 
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat vAlign="bottom">
            <uix:include nodeBinding="<%=TestTxnUIBean.LABELED_FIELD_LAYOUT_KEY%>"/>
          </uix:cellFormat>

        </uix:rowLayout>
      </uix:tableLayout>
    </uix:stackLayout>

</uix:dataScope>
</oem:pageSegment>
