<%--
/* $Header: tests.jsp 16-jul-2007.13:50:49 rgraham Exp $ */

/* Copyright (c) 2004, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rgraham     07/16/07 - add beacon compatibility messages
    mvajapey    07/28/05 - not use partial 
    andyao      07/24/05 - add partial action 
    andyao      07/13/05 - add short desc 
    andyao      06/13/05 - add table summary 
    andyao      03/31/05 - 
    andyao      03/09/05 - fix bug 4178589 
    yxie        02/15/05 - add Status column
    andyao      01/31/05 - add key column 
    andyao      01/07/05 - move global button using tableActions 
    andyao      01/05/05 - add row banding 
    andyao      12/28/04 - remove dependency from TestPageViewBean 
    andyao      12/03/04 - remove error.jspf 
    andyao      11/19/04 - add view event 
    andyao      10/27/04 - integration with txn management 
    andyao      10/18/04 - Modify for Availability 
    andyao      10/01/04 - Creation
 */

/**
 *  @version $Header: tests.jsp 16-jul-2007.13:50:49 rgraham Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */

 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.PageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.TestsPageViewBean" %>
<%@ page import="oracle.sysman.eml.gensvc.admin.data.ui.TestGenUIBean" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:tableLayout cellSpacing="5" borderWidth="0" width="80%">
      <uix:rowLayout>
        <uix:styledText styleClass="OraInstructionText" textBinding="<%=TestsPageViewBean.TESTS_BCNS_TEXT_KEY%>"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:cellFormat columnSpan="2">
          <uix:table
            columnHeaderDataBinding="<%=PageViewBean.COLUMN_HEADER_DATA_KEY%>"
            columnFormatsBinding="<%=PageViewBean.COLUMN_FORMATS_DATA_KEY%>"
            tableDataBinding="<%=PageViewBean.TABLE_DATA_KEY%>"
            alternateTextBinding="NO_TEST_DEFINED@gensvc"
            width="100%"
            id="<%=TestsPageViewBean.TESTS_KEY%>"
            partialRenderMode="self"
            blockSizeBinding="<%=PageViewBean.BLOCK_SIZE_KEY%>"
            maxValueBinding="<%=PageViewBean.MAX_KEY%>"
            valueBinding="<%=PageViewBean.START_KEY%>"
            unvalidated="true"
            formSubmitted="true"
            summaryBinding="SERVICE_TESTS@gensvc"
            >
            <uix:tableActions>
              <uix:flowLayout renderedBinding="<%=TestsPageViewBean.SHOW_BUTTONS_ABOVE_TABLE_KEY%>">
                <uix:messageChoice
                  name="<%=TestGenUIBean.TEST_TYPE_KEY%>"
                  promptBinding="TEST_TYPE@gensvc"
                  selectedValueBinding="<%=TestGenUIBean.TEST_TYPE_KEY%>"
                  shortDescBinding="ACTION_DESC_CREATE_SERVICE_TEST@gensvc"
                  >
                  <uix:contents childDataBinding="<%=TestGenUIBean.TEST_TYPE_DATA_KEY%>" >
                    <uix:option 
                      textBinding="<%=UIConstants.TEXT_KEY%>" 
                      valueBinding="<%=UIConstants.VALUE_PARAM%>"/>
                  </uix:contents>
                  <uix:end>
                    <uix:submitButton 
                      textBinding="ADD@common" 
                      name="<%=UIConstants.EVENT_PARAM%>" 
                      value="<%=TestsPageViewBean.ADD_EVENT%>"
                      shortDescBinding="ACTION_DESC_CREATE_SERVICE_TEST@gensvc"
                      />
                  </uix:end>
                </uix:messageChoice>
              </uix:flowLayout>
            </uix:tableActions>
            <uix:tableFormat tableBanding="rowBanding"/>
            <uix:columnHeaderStamp>
              <uix:sortableHeader 
                textBinding="<%=UIConstants.TEXT_KEY%>" 
                sortableBinding="sortable"
                />
            </uix:columnHeaderStamp>
            <uix:tableSelection>
              <uix:singleSelection selectedIndex="0" renderedBinding="<%=TestsPageViewBean.SHOW_SELECTION_COLUMN_KEY%>"
                shortDescBinding="<%=TestsPageViewBean.TEST_KEY%>">
                <uix:contents>
                  <uix:submitButton 
                    textBinding="VERIFY_SERVICE_TEST@gensvc" 
                    name="<%=UIConstants.EVENT_PARAM%>" 
                    value="<%=TestsPageViewBean.VERIFY_TEST_EVENT%>"
                    />
                  <uix:submitButton
                    textBinding="ENABLE@gensvc"
                    primaryClientActionBinding="enableTestAction"
                    />
                  <uix:submitButton
                    textBinding="DISABLE@gensvc"
                    primaryClientActionBinding="disableTestAction"
                    />
                  <uix:submitButton 
                    textBinding="REMOVE@common" 
		    name="<%=UIConstants.EVENT_PARAM%>"
		    value="<%=TestsPageViewBean.REMOVE_EVENT%>"
                    />
                  <uix:submitButton 
                    textBinding="VIEW@common" 
                    name="<%=UIConstants.EVENT_PARAM%>" 
                    value="<%=TestsPageViewBean.VIEW_EVENT%>"
                    />
                  <uix:submitButton 
                    textBinding="EDIT@common" 
                    name="<%=UIConstants.EVENT_PARAM%>" 
                    value="<%=TestsPageViewBean.EDIT_EVENT%>"
                    />
                </uix:contents>
              </uix:singleSelection>
            </uix:tableSelection>

            <uix:contents>
              <uix:link 
                textBinding="<%=TestsPageViewBean.TEST_KEY%>" 
                destinationBinding="<%=TestsPageViewBean.TEST_LINK_KEY%>"
                />
              <uix:text textBinding="<%=TestsPageViewBean.TEST_TYPE_KEY%>"/>
              <uix:text textBinding="<%=TestsPageViewBean.ENABLED_KEY%>"/>
              <uix:image
                shortDescBinding="<%=TestsPageViewBean.STATUS_LABEL_KEY%>"
                sourceBinding="<%=TestsPageViewBean.STATUS_CLICKABLE_ICON_KEY%>"
                destinationBinding="<%=TestsPageViewBean.STATUS_DEST_KEY%>"/>
              <uix:flowLayout renderedBinding="<%=TestsPageViewBean.SHOW_KEY_COLUMN_KEY%>">
                <uix:contents>
                  <uix:checkBox 
                    checkedBinding="<%=TestsPageViewBean.KEY_TEST_KEY%>" 
                    name="<%=TestsPageViewBean.KEY_TEST_KEY%>" 
                    renderedBinding="<%=TestsPageViewBean.SHOW_MUTABLE_KEY_COLUMN_KEY%>"
                    disabledBinding="<%=TestsPageViewBean.KEY_TEST_DISABLED_KEY%>"
                    shortDescBinding="KEY_SERVICE_TEST@gensvc"
                    />
                  <uix:switcher childNameBinding="<%=TestsPageViewBean.KEY_TEST_KEY%>">
                    <uix:case name="true">
                      <uix:image sourceBinding="isKeyImageSource" shortDescBinding="KEY_SERVICE_TEST@gensvc" renderedBinding="<%=TestsPageViewBean.SHOW_READONLY_KEY_COLUMN_KEY%>"/>
                    </uix:case>
                    <uix:default>
                      <uix:text text="" renderedBinding="<%=TestsPageViewBean.SHOW_READONLY_KEY_COLUMN_KEY%>"/>
                    </uix:default>
                  </uix:switcher>
                </uix:contents>
              </uix:flowLayout>
              
            </uix:contents>
          </uix:table>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>

