<%--
/* $Header: configThresholds.jsp 11-aug-2005.18:21:03 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Threshold Settings page 

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      08/11/05 - use form submission 
    mvajapey    07/28/05 - remove location 
    andyao      07/25/05 - add apply train 
    andyao      03/04/05 - add error handling code 
    yxie        02/25/05 - add test label value pair
    andyao      12/03/04 - move error location 
    andyao      11/19/04 - fix page header 
    andyao      10/22/04 - provide a way to return to Monitoring Setting - 
                           Tests 
    andyao      10/16/04 - andyao_mon_settings
    andyao      09/01/04 - Creation
 */

/**
 *  @version $Header: configThresholds.jsp 11-aug-2005.18:21:03 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.ThresholdBean' %>
<%@ page import='oracle.sysman.eml.PageSegmentTypes' %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.eml.gensvc.GenSvcUIConstants' %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
	<oem:setURLEncoder id="renderingContext"/>
	<uix:document>
		<%@ include file="/oemTitle.jspf" %>
		<%@ include file="/enablePPR.jspf" %>
		<uix:body>
			<uix:pageLayout>
				<%@ include file="/oemGlobal.jspf"%>
        <uix:form name="mainForm" method="POST">
          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
            <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />

            <uix:dataScope currentDataBinding="@servletRequest">
              <%@ include file="/webapp/tmpl/applyTemplateTrain.jspf" %>
            </uix:dataScope>

            <%@ include file="/gensvc/message.jspf"%>
            <uix:header textBinding="<%=GenSvcUIConstants.PAGE_HEADER_KEY%>">

              <uix:contents>

                <%@ include file="configTop.jspf"%>

                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndexBinding="selectedIndex@servletRequest">
                      <uix:contents childDataBinding="svcSubTabs@servletRequest">
                        <uix:link textBinding="name" primaryClientActionBinding="primaryAction"/>
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:subTabs>

                  <uix:contents>
                    <uix:tableLayout borderWidth="0" width="100%">

                      <uix:rowLayout>
                        <uix:header textBinding="TRANSACTION_METRICS@gensvc">
                          <uix:ref refID="<%=PageSegmentTypes.GENSVC_TXN_THRESHOLD_TYPE%>"/>
                        </uix:header>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:header 
                          renderedBinding="<%=ThresholdBean.STEP_LEVEL_METRICS_COL_EXIST%>" 
                          textBinding="UA_AND_UAGROUP_METRICS@gensvc">
                          <uix:ref refID="<%=PageSegmentTypes.GENSVC_UAGROUP_THRESHOLD_TYPE%>"/>
                        </uix:header>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:subTabLayout>

              </uix:contents>
            </uix:header>
          </uix:dataScope>
        </uix:form>

        <uix:contentFooter>
          <%@ include file="configNav.jspf"%>
        </uix:contentFooter>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
