<%--
/* $Header: collectionFrequency.jsp 27-jul-2005.00:52:29 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Collection Frequency page segment.

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      07/27/05 - add required flag 
    andyao      07/24/05 - add partial action
    andyao      06/13/05 - add table summary 
    andyao      05/06/05 - add view mode 
    andyao      03/08/05 - change the view by string 
    andyao      03/02/05 - fix bug 4214572 
    andyao      01/19/05 - fix UI issues 
    andyao      09/01/04 - Creation
 */

/**
 *  @version $Header: collectionFrequency.jsp 27-jul-2005.00:52:29 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.CollectionSettingBean' %>
<%@ page import='oracle.sysman.eml.beacon.data.Beacon' %>
<%@ page import='oracle.cabo.ui.UIConstants' %>

<oem:pageSegment>
	<uix:dataScope currentDataBinding="bean">
		<uix:bundle name="beacon" class="oracle.sysman.resources.beacon.BeaconResourceBundle" />
		<uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
		<uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
    <uix:tableLayout borderWidth="0" width="100%" cellSpacing="5">

      <uix:rowLayout renderedBinding="<%=CollectionSettingBean.NOT_VIEW_MODE%>">
        <uix:messagePrompt promptBinding="<%=CollectionSettingBean.INSTRUCTION_TEXT_KEY%>"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="<%=CollectionSettingBean.IS_VIEW_MODE%>">
        <%-- view mode --%>
        <uix:table
          id="frequencyTable" 
          width="50%"
          tableDataBinding="frequencyTableData"
          columnHeaderDataBinding="frequencyTableColumnHeaderData"
          summaryBinding="COLLECTION_FREQUENCY@gensvc"
          >
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"/>
          </uix:columnHeaderStamp>

          <uix:contents>
            <uix:styledText textBinding="beaconName@"/>
            <uix:column>
              <uix:columnFormat columnDataFormat="numberFormat"/>
              <uix:contents>
                <uix:styledText styleClass="OraFieldNumber" textBinding="frequency@" />
              </uix:contents>
            </uix:column>
          </uix:contents>
        </uix:table>
      </uix:rowLayout>

        <%-- edit mode --%>
      <uix:rowLayout renderedBinding="<%=CollectionSettingBean.NOT_VIEW_MODE%>">
        <uix:table
          id="frequencyTable" 
          width="50%"
          tableDataBinding="frequencyTableData"
          renderedBinding="<%=CollectionSettingBean.NOT_VIEW_MODE%>"
          summaryBinding="COLLECTION_FREQUENCY@gensvc"
          columnHeaderDataBinding="frequencyTableColumnHeaderData">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"/>
          </uix:columnHeaderStamp>

          <uix:tableActions>
            <uix:submitButton 
              name="event" 
              valueBinding="<%=CollectionSettingBean.SPECIFY_BEACON_OVERRIDES_EVENT%>" 
              shortDescBinding="COLL_INTERVAL_ADD_BCN_BTN_DESC@gensvc"
              textBinding="SPECIFY_BEACON_OVERRIDES@gensvc"
              />
          </uix:tableActions>

          <uix:contents>
            <uix:styledText textBinding="beaconName@"/>
            <uix:column>
              <uix:columnFormat columnDataFormat="numberFormat" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:flowLayout>
                  <uix:styledText styleClass="xc" text="*"/>
                  <uix:messageTextInput 
                    required="yes"
                    columns="10"
                    styleClass="OraFieldNumber"
                    name="frequency"
                    shortDescBinding="COLLECTION_FREQUENCY@gensvc"
                    textBinding="frequency@" />
                </uix:flowLayout>
              </uix:contents>
            </uix:column>
            <uix:column>
              <uix:columnFormat columnDataFormat="iconButtonFormat"/>
              <uix:contents>
                <uix:image sourceBinding="removeSource@" 
                          primaryClientActionBinding="removeAction" />
              </uix:contents>
            </uix:column>
            <uix:formValue name="beaconId" valueBinding="beaconId@"/>
          </uix:contents>
        </uix:table>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>



