<%--
/* $Header: collectionProperties.jsp 19-jun-2007.00:48:27 rgraham Exp $ */

/* Copyright (c) 2004, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Collection Properties page segment.

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rgraham     06/18/07 - fix bug 6018345
    andyao      08/30/05 - add no auto complete 
    andyao      07/27/05 - add required flag 
    andyao      07/24/05 - add partial action 
    andyao      06/13/05 - add short description 
    andyao      05/09/05 - adde view mode
    andyao      03/08/05 - change the view by string 
    andyao      03/02/05 - fix bug 4214572 
    andyao      01/19/05 - fix UI issues 
    andyao      09/01/04 - Creation
 */

/**
 *  @version $Header: collectionProperties.jsp 19-jun-2007.00:48:27 rgraham Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.CollectionPropertiesBean' %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.eml.ImageNames' %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
    <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
    <uix:tableLayout borderWidth="0" width="80%" cellSpacing="5">

      <uix:rowLayout rendered="<%=CollectionPropertiesBean.NOT_VIEW_MODE%>">
        <uix:cellFormat columnSpan="3">
          <uix:messagePrompt promptBinding="<%=CollectionPropertiesBean.INSTRUCTION_TEXT_KEY%>"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat width="150">
          <uix:messageChoice 
            nameBinding="<%=CollectionPropertiesBean.VIEW_BY_KEY%>"
            promptBinding="VIEW_BY@gensvc"
            selectedValueBinding="<%=CollectionPropertiesBean.VIEW_BY_VALUE_KEY%>"
            primaryClientActionBinding="viewByAction"
            >
            <uix:contents>
              <uix:option textBinding="BEACONS_BY_PROPERTY@gensvc" value="<%=CollectionPropertiesBean.VIEW_BY_PROPERTY%>"/>
              <uix:option textBinding="PROPERTIES_BY_BEACON@gensvc" value="<%=CollectionPropertiesBean.VIEW_BY_BEACON%>"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:cellFormat>

        <uix:cellFormat width="10">
          <%--
          <uix:submitButton 
            name="event" 
            valueBinding="<%=CollectionPropertiesBean.VIEW_BY_EVENT%>" 
            textBinding="GO@common"/>
          --%>
        </uix:cellFormat>

        <uix:cellFormat>
          <uix:spacer width="10"/>
        </uix:cellFormat>
        <%--

        <uix:cellFormat width="150">
          <uix:messageChoice 
            nameBinding="<%=CollectionPropertiesBean.VIEW_BEACONS_KEY%>"
            promptBinding="VIEW_BEACONS@gensvc"
            selectedValueBinding="<%=CollectionPropertiesBean.VIEW_BEACONS_VALUE_KEY%>"
            >
            <uix:contents childDataBinding="<%=CollectionPropertiesBean.ALL_BEACONS_KEY%>">
              <uix:option textBinding="<%=UIConstants.TEXT_KEY%>" valueBinding="value"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:cellFormat>

        <uix:cellFormat width="10">
          <uix:submitButton 
            name="event" 
            valueBinding="<%=CollectionPropertiesBean.VIEW_BEACONS_EVENT%>" 
            textBinding="GO@common"
            />
        </uix:cellFormat>
        --%>

      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat columnSpan="3">
          <uix:switcher childNameBinding="<%=CollectionPropertiesBean.VIEW_BY_VALUE_KEY%>">
            <uix:case name="<%=CollectionPropertiesBean.VIEW_BY_PROPERTY%>">
              <uix:hGrid 
                columnFormatsBinding="columnFormats"
                columnHeaderDataBinding="columnHeaderData"
                columnHeaderFormatsBinding="columnHeaderFormats"
                treeDataBinding="<%=CollectionPropertiesBean.TREE_DATA_KEY%>"
                rendered="true"
                partialRenderMode="self"
                id="<%=CollectionPropertiesBean.ID_KEY%>" 
                proxyBinding="<%=CollectionPropertiesBean.PROXY_KEY%>"
                width="100%"
                formSubmitted="true"
                unvalidated="true"
                summaryBinding="COLLECTION_PROPERTIES@gensvc"
                >
                <uix:tableSelection>
                  <uix:singleSelection disabledBinding="disabled" selectedIndex="1" 
                    shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                    renderedBinding="<%=CollectionPropertiesBean.NOT_VIEW_MODE%>">
                    <uix:contents>
                      <uix:submitButton 
                        name="event" 
                        valueBinding="<%=CollectionPropertiesBean.SPECIFY_BEACON_OVERRIDES_EVENT%>" 
                        shortDescBinding="PROPERTY_ADD_BCN_BTN_DESC@gensvc"
                        textBinding="SPECIFY_BEACON_OVERRIDES@gensvc"
                        />
                    </uix:contents>
                  </uix:singleSelection>
                </uix:tableSelection>

                <uix:tableActions>
                  <uix:switcher childNameBinding="<%=CollectionPropertiesBean.VIEW_BY_VALUE_KEY%>" renderedBinding="<%=CollectionPropertiesBean.NOT_VIEW_MODE%>">
                    <uix:case name="<%=CollectionPropertiesBean.VIEW_BY_PROPERTY%>">
                      <uix:submitButton 
                        name="event" 
                        valueBinding="<%=CollectionPropertiesBean.ADD_PROPERTY_EVENT%>" 
                        textBinding="ADD_PROPERTY@gensvc"
                        />
                    </uix:case>
                    <uix:default>
                      <uix:spacer width="10"/>
                    </uix:default>
                  </uix:switcher>

                </uix:tableActions>

                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="NAME@common"/>
                    </uix:columnHeader>
                      <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:columnHeaderStamp>

                <uix:contents>
                  <uix:column>
                    <uix:columnFormat columnDataFormat="numberFormat" cellNoWrapFormat="true"/>

                    <uix:columnHeader>
                      <uix:text textBinding="VALUE@common"/>
                    </uix:columnHeader>

                    <uix:contents>
                      <uix:switcher childNameBinding="<%=CollectionPropertiesBean.SHOW_PROPERTY_KEY%>">
                        <uix:case name="false"><uix:text text=""/></uix:case>
                        <uix:case name="<%=CollectionPropertiesBean.READ_ONLY_KEY%>">
                          <uix:styledText 
                            textBinding="<%=CollectionPropertiesBean.VALUE_KEY%>"/>
                        </uix:case>
                        <uix:default>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:flowLayout renderedBinding="<%=CollectionPropertiesBean.SHOW_TEXT_INPUT_KEY%>">
                                <uix:contents>
                                  <uix:switcher childNameBinding="<%=CollectionPropertiesBean.REQUIRED_KEY%>">
                                    <uix:case name="yes">
                                      <uix:styledText styleClass="xc" text="*"/>
                                    </uix:case>
                                  </uix:switcher>
                                  <uix:messageTextInput
                                    name="<%=CollectionPropertiesBean.VALUE_KEY%>" 
                                    textBinding="<%=CollectionPropertiesBean.VALUE_KEY%>" 
                                    secretBinding="<%=CollectionPropertiesBean.SECRET_KEY%>"
                                    noAutoCompleteBinding="<%=CollectionPropertiesBean.SECRET_KEY%>"
                                    columns="10" 
                                    requiredBinding="<%=CollectionPropertiesBean.REQUIRED_KEY%>"
                                    shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                                    styleClassBinding="<%=CollectionPropertiesBean.STYLE_CLASS_KEY%>"/>
                                </uix:contents>
                              </uix:flowLayout>
                              <uix:choice
                                name="<%=CollectionPropertiesBean.VALUE_KEY%>"
                                selectedValueBinding="<%=CollectionPropertiesBean.VALUE_KEY%>"
                                renderedBinding="<%=CollectionPropertiesBean.SHOW_CHOICE_KEY%>"
                                shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                                >
                                <uix:contents childDataBinding="<%=CollectionPropertiesBean.CHOICES_KEY%>">
                                  <uix:option 
                                    textBinding="<%=UIConstants.TEXT_KEY%>" 
                                    valueBinding="value"/>
                                </uix:contents>
                              </uix:choice>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:default>
                      </uix:switcher>
                    </uix:contents>
                  </uix:column>

                  <uix:column renderedBinding="<%=CollectionPropertiesBean.NOT_VIEW_MODE%>">
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:columnHeader>
                      <uix:text textBinding="REMOVE@common"/>
                    </uix:columnHeader>
                    <uix:switcher childNameBinding="<%=CollectionPropertiesBean.SHOW_REMOVE_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:default>
                        <uix:image sourceBinding="<%=CollectionPropertiesBean.REMOVE_RESOURCE%>" 
                          primaryClientActionBinding="removeAction"
                          shortDescBinding="PROPERTY_REMOVE_BTN_DESC@gensvc"
                          />
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                </uix:contents>
              </uix:hGrid>
            </uix:case>
            <uix:case name="<%=CollectionPropertiesBean.VIEW_BY_BEACON%>">
              <uix:hGrid 
                columnFormatsBinding="columnFormats"
                columnHeaderDataBinding="columnHeaderData"
                columnHeaderFormatsBinding="columnHeaderFormats"
                treeDataBinding="<%=CollectionPropertiesBean.TREE_DATA_KEY%>"
                rendered="true"
                partialRenderMode="self"
                id="<%=CollectionPropertiesBean.ID_KEY%>" 
                proxyBinding="<%=CollectionPropertiesBean.PROXY_KEY%>"
                width="100%"
                formSubmitted="true"
                unvalidated="true"
                summaryBinding="COLLECTION_PROPERTIES@gensvc"
                >

                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="NAME@common"/>
                    </uix:columnHeader>
                      <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:columnHeaderStamp>

                <uix:contents>
                  <uix:column renderedBinding="<%=CollectionPropertiesBean.NOT_VIEW_MODE%>">
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:columnHeader>
                      <uix:text textBinding="SHOW_DEFAULT@gensvc"/>
                    </uix:columnHeader>
                    <uix:switcher childNameBinding="<%=CollectionPropertiesBean.SHOW_PROPERTY_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=CollectionPropertiesBean.READ_ONLY_KEY%>">
                        <uix:image sourceBinding="<%=CollectionPropertiesBean.DEFAULT_RESOURCE%>" 
                          primaryClientActionBinding="overrideAction"
                          shortDescBinding="<%=CollectionPropertiesBean.OVERRIDE_HOVER_KEY%>"
                          />
                      </uix:case>
                      <uix:default>
                        <uix:image sourceBinding="<%=CollectionPropertiesBean.OVERRIDE_RESOURCE%>" 
                          primaryClientActionBinding="defaultAction"
                          shortDescBinding="<%=CollectionPropertiesBean.DEFAULT_HOVER_KEY%>"
                          />
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat columnDataFormat="numberFormat" cellNoWrapFormat="true"/>
                    <uix:columnHeader>
                      <uix:text textBinding="VALUE@common"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:switcher childNameBinding="<%=CollectionPropertiesBean.SHOW_PROPERTY_KEY%>">
                        <uix:case name="false"><uix:text text=""/></uix:case>
                        <uix:case name="<%=CollectionPropertiesBean.READ_ONLY_KEY%>">
                          <uix:styledText 
                            textBinding="<%=CollectionPropertiesBean.VALUE_KEY%>"/>
                        </uix:case>
                        <uix:default>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:flowLayout renderedBinding="<%=CollectionPropertiesBean.SHOW_TEXT_INPUT_KEY%>">
                                <uix:switcher childNameBinding="<%=CollectionPropertiesBean.REQUIRED_KEY%>">
                                  <uix:case name="yes">
                                    <uix:styledText styleClass="xc" text="*"/>
                                  </uix:case>
                                </uix:switcher>
                                <uix:messageTextInput 
                                  name="<%=CollectionPropertiesBean.VALUE_KEY%>" 
                                  textBinding="<%=CollectionPropertiesBean.VALUE_KEY%>" 
                                  columns="10" 
                                  styleClassBinding="<%=CollectionPropertiesBean.STYLE_CLASS_KEY%>"
                                  requiredBinding="<%=CollectionPropertiesBean.REQUIRED_KEY%>"
                                  secretBinding="<%=CollectionPropertiesBean.SECRET_KEY%>"
                                  noAutoCompleteBinding="<%=CollectionPropertiesBean.SECRET_KEY%>"
                                  shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                                  />
                              </uix:flowLayout>
                              <uix:choice
                                name="<%=CollectionPropertiesBean.VALUE_KEY%>"
                                selectedValueBinding="<%=CollectionPropertiesBean.VALUE_KEY%>"
                                renderedBinding="<%=CollectionPropertiesBean.SHOW_CHOICE_KEY%>"
                                shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                                >
                                <uix:contents childDataBinding="<%=CollectionPropertiesBean.CHOICES_KEY%>">
                                  <uix:option 
                                    textBinding="<%=UIConstants.TEXT_KEY%>" 
                                    valueBinding="value"/>
                                </uix:contents>
                              </uix:choice>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:default>
                      </uix:switcher>
                    </uix:contents>
                  </uix:column>

                </uix:contents>
              </uix:hGrid>
            </uix:case>
          </uix:switcher>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>

