<%--
/* $Header: monitoringTests.jsp 13-jun-2005.14:15:49 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Tests Page Segment

   PRIVATE CLASSES

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao      06/13/05 - add table summary 
    andyao      03/09/05 - fix bug 4181336 
    andyao      01/05/05 - add row banding 
    andyao      10/26/04 - andyao_services5
    andyao      10/26/04 - fix alternate text 
    andyao      10/19/04 - Creation
 */

/**
 *  @version $Header: monitoringTests.jsp 13-jun-2005.14:15:49 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.MonitoringTestsBean' %>
<%@ page import='oracle.cabo.ui.UIConstants' %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
		<uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
    <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:spacer height="10"/>
    <uix:table
      columnHeaderDataBinding="<%=MonitoringTestsBean.COLUMN_HEADER_DATA_KEY%>"
      columnFormatsBinding="<%=MonitoringTestsBean.COLUMN_FORMATS_DATA_KEY%>"
      tableDataBinding="<%=MonitoringTestsBean.TABLE_DATA_KEY%>"
      alternateTextBinding="NO_TEST_DEFINED@gensvc"
      width="500"
      id="<%=MonitoringTestsBean.ID_KEY%>"
      partialRenderMode="self"
      blockSizeBinding="<%=MonitoringTestsBean.BLOCK_SIZE_KEY%>"
      maxValueBinding="<%=MonitoringTestsBean.MAX_KEY%>"
      valueBinding="<%=MonitoringTestsBean.START_KEY%>"
      unvalidated="true"
      formSubmitted="true"
      summaryBinding="MONITORING_SETTINGS_FOR_TESTS@gensvc"
      >
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader textBinding="<%=UIConstants.TEXT_KEY%>" sortableBinding="sortable"/>
      </uix:columnHeaderStamp>

      <uix:contents>
        <uix:text textBinding="<%=MonitoringTestsBean.NAME_KEY%>"/>
        <uix:image sourceBinding="<%=MonitoringTestsBean.EDIT_SOURCE_KEY%>" 
          onClickBinding="<%=MonitoringTestsBean.EDIT_ON_CLICK_KEY%>"/>
      </uix:contents>
    </uix:table>

  </uix:dataScope>
</oem:pageSegment>
