<%--
/* $Header: uaGroupThreshold.jsp 19-jun-2007.00:48:27 rgraham Exp $ */

/* Copyright (c) 2004, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - User Action and User Action Group Threshold Settings page segment

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rgraham     06/18/07 - fix bug 6018345
    andyao      07/24/05 - add partial action 
    andyao      06/13/05 - add short description 
    andyao      05/09/05 - add view mode 
    andyao      04/08/05 - 
    andyao      03/08/05 - change the view by string 
    andyao      03/01/05 - fix bug 4201848 
    andyao      01/19/05 - fix UI issues 
    andyao      01/07/05 - remove html comment 
    andyao      10/22/04 - remove error.jspf from segments 
    andyao      10/16/04 - andyao_mon_settings
    andyao      09/01/04 - Creation
 */

/**
 *  @version $Header: uaGroupThreshold.jsp 19-jun-2007.00:48:27 rgraham Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.ThresholdBean' %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.UAGroupThresholdBean' %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.eml.ImageNames' %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="bean">
		<uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
		<uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />

    <uix:tableLayout borderWidth="0" width="100%" cellSpacing="5">

      <uix:rowLayout renderedBinding="<%=UAGroupThresholdBean.NOT_VIEW_MODE%>">
        <uix:cellFormat columnSpan="6">
          <uix:messagePrompt promptBinding="<%=ThresholdBean.INSTRUCTION_TEXT_KEY%>"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="10"/>
      </uix:rowLayout>

			<uix:rowLayout>
				<%-- the View By drop down --%>
				<uix:cellFormat width="150">
					<uix:messageChoice 
						nameBinding="<%=ThresholdBean.VIEW_BY_KEY%>"
						promptBinding="VIEW_BY@gensvc"
						selectedValueBinding="<%=ThresholdBean.VIEW_BY_VALUE_KEY%>"
            primaryClientActionBinding="viewByAction"
						>
						<uix:contents>
							<uix:option textBinding="MON_SETTINGS_STEP_METRIC_BEACON@gensvc" value="<%=ThresholdBean.VIEW_BY_METRIC%>"/>
							<uix:option textBinding="MON_SETTINGS_STEP_BEACON_METRIC@gensvc" value="<%=ThresholdBean.VIEW_BY_BEACON%>"/>
						</uix:contents>
					</uix:messageChoice>
				</uix:cellFormat>

				<uix:cellFormat width="10">
          <%--
					<uix:submitButton 
            name="<%=UIConstants.EVENT_PARAM%>" 
						valueBinding="<%=ThresholdBean.VIEW_BY_EVENT%>" 
						textBinding="GO@common"
            />--%>
				</uix:cellFormat>

				<uix:cellFormat width="10">
					<uix:spacer width="10"/>
				</uix:cellFormat>

				<uix:cellFormat width="150">
					<%-- the View Beacons drop down --%>
					<%--
					this drop down allows filtering by beacons
					this functionality is disabled
					<uix:messageChoice 
						nameBinding="<%=ThresholdBean.VIEW_BEACONS_KEY%>"
						promptBinding="VIEW_BEACONS@gensvc"
						selectedValueBinding="<%=ThresholdBean.VIEW_BEACONS_VALUE_KEY%>"
						>
						<uix:contents childDataBinding="<%=ThresholdBean.ALL_BEACONS_KEY%>">
							<uix:option textBinding="<%=UIConstants.TEXT_KEY%>" valueBinding="value"/>
						</uix:contents>
					</uix:messageChoice>
					--%>
				</uix:cellFormat>

				<uix:cellFormat width="10">
					<%--
					this filtering functionality is disabled
					<uix:submitButton 
            name="<%=UIConstants.EVENT_PARAM%>" 
						valueBinding="<%=ThresholdBean.VIEW_BEACONS_EVENT%>" 
						textBinding="GO@common"
						/>
					--%>
				</uix:cellFormat>

				<uix:cellFormat hAlign="right" width="100%">
					<uix:spacer width="10"/>
				</uix:cellFormat>

			</uix:rowLayout>

			<uix:rowLayout>
				<uix:cellFormat columnSpan="6">
					<uix:switcher childNameBinding="<%=ThresholdBean.VIEW_BY_VALUE_KEY%>">
						<uix:case name="<%=ThresholdBean.VIEW_BY_METRIC%>">
							<uix:hGrid 
								columnFormatsBinding="columnFormats"
								columnHeaderDataBinding="columnHeaderData"
								columnHeaderFormatsBinding="columnHeaderFormats"
								treeDataBinding="<%=ThresholdBean.TREE_DATA_KEY%>"
								rendered="true"
								id="<%=UAGroupThresholdBean.UAGROUP_THRESHOLD_ID_KEY%>" 
								proxyBinding="<%=ThresholdBean.PROXY_KEY%>"
								width="100%"
                formSubmitted="true"
                unvalidated="true"
                partialRenderMode="self"
                summaryBinding="UA_AND_UAGROUP_METRICS@gensvc"
                >
								<uix:tableSelection>
                  <uix:singleSelection 
                    disabledBinding="disabled" 
                    selectedIndex="1" 
                    shortDescBinding="<%=UIConstants.TEXT_KEY%>"
                    renderedBinding="<%=ThresholdBean.NOT_VIEW_MODE%>">
										<uix:contents>
											<uix:submitButton 
												name="event" 
												valueBinding="<%=ThresholdBean.SPECIFY_BEACON_OVERRIDES_EVENT%>" 
                        shortDescBinding="THRESHOLD_ADD_BCN_BTN_DESC@gensvc"
												textBinding="SPECIFY_BEACON_OVERRIDES@gensvc"
												/>
											<uix:submitButton 
												name="event" 
                        valueBinding="<%=ThresholdBean.ADD_METRIC_EVENT%>" 
                        shortDescBinding="STEP_THRESHOLD_ADD_METRIC_BTN_DESC@gensvc"
												textBinding="ADD_METRIC@gensvc"
												/>
										</uix:contents>
									</uix:singleSelection>
								</uix:tableSelection>

                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="NAME@common"/>
                    </uix:columnHeader>
                      <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                  </uix:column>
                </uix:nodeStamp>

								<uix:columnHeaderStamp>
									<uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
								</uix:columnHeaderStamp>

								<uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="TYPE@common"/>
                    </uix:columnHeader>
                    <uix:text textBinding="<%=ThresholdBean.TYPE_KEY%>"/>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="COMPARISON_OPERATOR@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.COMPARISON_VALUE_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:choice
                          name="<%=ThresholdBean.COMPARISON_KEY%>"
                          selectedIndexBinding="<%=ThresholdBean.COMPARISON_INDEX_KEY%>"
                          shortDescBinding="COMPARISON_OPERATOR@gensvc"
                          >
                          <uix:contents childDataBinding="<%=ThresholdBean.COMPARISON_KEY%>">
                            <uix:option textBinding="<%=UIConstants.TEXT_KEY%>" valueBinding="value"/>
                          </uix:contents>
                        </uix:choice>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="WARNING_THRESHOLD@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.WARN_THRESHOLD_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:textInput 
                          name="<%=ThresholdBean.WARN_THRESHOLD_KEY%>" 
                          styleClass="OraFieldNumber"
                          textBinding="<%=ThresholdBean.WARN_THRESHOLD_KEY%>" 
                          shortDescBinding="WARNING_THRESHOLD@gensvc"
                          columns="10"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="CRITICAL_THRESHOLD@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:textInput 
                          name="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>" 
                          styleClass="OraFieldNumber"
                          textBinding="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>" 
                          shortDescBinding="CRITICAL_THRESHOLD@gensvc"
                          columns="10"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="NUMBER_OF_OCCURRENCES@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_OCCURRENCE_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:flowLayout>
                          <uix:styledText styleClass="xc" text="*"/>
                          <uix:textInput 
                            name="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>" 
                            styleClass="OraFieldNumber"
                            textBinding="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>"  
                            shortDescBinding="NUMBER_OF_OCCURRENCES@gensvc"
                            columns="10"/>
                        </uix:flowLayout>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <%-- This needs to be implemented later 
                  <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_ADV_EDIT_KEY%>">
                    <uix:case name="false"><uix:text text=""/></uix:case>
                    <uix:default>
                      <uix:image sourceBinding="advEditSource" destinationBinding="editURL"/>
                    </uix:default>
                  </uix:switcher>
                  --%>
                  <uix:column renderedBinding="<%=ThresholdBean.NOT_VIEW_MODE%>">
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="REMOVE@common"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_REMOVE_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:default>
                        <uix:image sourceBinding="removeSource" 
                          primaryClientActionBinding="removeAction"
                          shortDescBinding="THRESHOLD_REMOVE_BTN_DESC@gensvc"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                </uix:contents>
              </uix:hGrid>
            </uix:case>
            <uix:case name="<%=ThresholdBean.VIEW_BY_BEACON%>">
              <uix:hGrid 
                columnFormatsBinding="columnFormats"
                columnHeaderDataBinding="columnHeaderData"
                columnHeaderFormatsBinding="columnHeaderFormats"
                treeDataBinding="<%=ThresholdBean.TREE_DATA_KEY%>"
                partialRenderMode="self"
                rendered="true"
                id="<%=UAGroupThresholdBean.UAGROUP_THRESHOLD_ID_KEY%>" 
                proxyBinding="<%=ThresholdBean.PROXY_KEY%>"
                width="100%"
                formSubmitted="true"
                unvalidated="true"
                summaryBinding="UA_AND_UAGROUP_METRICS@gensvc"
                >

                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="NAME@common"/>
                    </uix:columnHeader>
                      <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:text textBinding="<%=UIConstants.TEXT_KEY%>"/>
                </uix:columnHeaderStamp>

                <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="TYPE@common"/>
                    </uix:columnHeader>
                    <uix:text textBinding="<%=ThresholdBean.TYPE_KEY%>"/>
                  </uix:column>

                  <uix:column renderedBinding="<%=ThresholdBean.NOT_VIEW_MODE%>">
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="iconButtonFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="SHOW_DEFAULT@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_DEF_OVERRIDE_KEY%>">
                      <uix:case name="<%=ThresholdBean.SHOW_OVERRIDE_KEY%>">
                        <uix:image sourceBinding="defSource" 
                          primaryClientActionBinding="overrideAction"
                          shortDescBinding="<%=ThresholdBean.OVERRIDE_HOVER_KEY%>"/>
                      </uix:case>
                      <uix:case name="<%=ThresholdBean.SHOW_DEF_KEY%>">
                        <uix:image sourceBinding="ovSource" 
                          primaryClientActionBinding="defaultAction"
                          shortDescBinding="<%=ThresholdBean.DEFAULT_HOVER_KEY%>"/>
                      </uix:case>
                      <uix:default><uix:text text=""/></uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="iconButtonFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="COMPARISON_OPERATOR@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.COMPARISON_VALUE_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:choice
                          name="<%=ThresholdBean.COMPARISON_KEY%>"
                          selectedIndexBinding="<%=ThresholdBean.COMPARISON_INDEX_KEY%>"
                          shortDescBinding="COMPARISON_OPERATOR@gensvc"
                          >
                          <uix:contents childDataBinding="<%=ThresholdBean.COMPARISON_KEY%>">
                            <uix:option textBinding="<%=UIConstants.TEXT_KEY%>" valueBinding="value"/>
                          </uix:contents>
                        </uix:choice>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="WARNING_THRESHOLD@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.WARN_THRESHOLD_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:textInput 
                          name="<%=ThresholdBean.WARN_THRESHOLD_KEY%>" 
                          styleClass="OraFieldNumber"
                          textBinding="<%=ThresholdBean.WARN_THRESHOLD_KEY%>" 
                          shortDescBinding="WARNING_THRESHOLD@gensvc"
                          columns="10"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="CRITICAL_THRESHOLD@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_THRESHOLD_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:textInput 
                          name="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>" 
                          styleClass="OraFieldNumber"
                          textBinding="<%=ThresholdBean.CRIT_THRESHOLD_KEY%>" 
                          shortDescBinding="CRITICAL_THRESHOLD@gensvc"
                          columns="10"/>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat  cellNoWrapFormat="true" columnDataFormat="numberFormat"/>

                    <uix:columnHeader>
                      <uix:text textBinding="NUMBER_OF_OCCURRENCES@gensvc"/>
                    </uix:columnHeader>

                    <uix:switcher childNameBinding="<%=ThresholdBean.SHOW_OCCURRENCE_KEY%>">
                      <uix:case name="false"><uix:text text=""/></uix:case>
                      <uix:case name="<%=ThresholdBean.READ_ONLY_KEY%>">
                        <uix:text textBinding="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>"/>
                      </uix:case>
                      <uix:default>
                        <uix:flowLayout>
                          <uix:styledText styleClass="xc" text="*"/>
                          <uix:textInput 
                            name="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>" 
                            styleClass="OraFieldNumber"
                            textBinding="<%=ThresholdBean.NUM_OCCURRENCES_KEY%>"  
                            shortDescBinding="NUMBER_OF_OCCURRENCES@gensvc"
                            required="yes"
                            columns="10"/>
                        </uix:flowLayout>
                      </uix:default>
                    </uix:switcher>
                  </uix:column>

                </uix:contents>
              </uix:hGrid>
            </uix:case>
          </uix:switcher>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
