<%--
/* $Header: selectMetrics.jsp 12-aug-2005.00:44:51 andyao Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   Monitoring Settings - Dummy page for a metric selection page

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao      08/12/05 - add return url 
    andyao      06/13/05 - add table summary 
    andyao      03/08/05 - layout fixes 
    yxie        02/25/05 - add test label-value pair
    andyao      03/03/05 - fix bug 4181325 
    andyao      01/21/05 - UI Fixes 
    andyao      01/07/05 - remove html comment 
    andyao      01/05/05 - 
    andyao      11/19/04 - fix page header 
    andyao      10/22/04 - fix form values 
    andyao      10/16/04 - andyao_mon_settings
    andyao      09/01/04 - Creation
 */

/**
 *  @version $Header: selectMetrics.jsp 12-aug-2005.00:44:51 andyao Exp $
 *  @author  andyao  
 *  @since   release specific (what release of product did this appear in)
 */
 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.emSDK.eml.EmlConstants' %>
<%@ page import='oracle.sysman.eml.gensvc.test.data.ui.MetricsSelectorUIBean' %>
<%@ page import='oracle.sysman.eml.gensvc.GenSvcUIConstants' %>

<uix:renderingContext id="renderingContext">
	<oem:setURLEncoder id="renderingContext"/>
	<uix:document>
		<%@ include file="/oemTitle.jspf" %>
		<%@ include file="/enablePPR.jspf" %>
		<uix:body>
      <uix:form name="mainForm" method="POST">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
            <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle" />
            <uix:bundle name="mntr"   class="oracle.sysman.resources.MntrResourceBundle"/>
            <%-- used to track the incoming level --%>
            <uix:formValue name="level" valueBinding="level"/>
            <uix:formValue 
              name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
              />


            <uix:header textBinding="<%=GenSvcUIConstants.PAGE_HEADER_KEY%>">
              <uix:tableLayout cellSpacing="2" width="100%">

                <uix:rowLayout>
                  <%@ include file="configTop.jspf"%>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="MON_SETTINGS_SEL_METRICS_PAGE_TEXT1@gensvc"/>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:dataScope currentDataBinding="bean@">
                    <uix:table
                      tableDataBinding="<%=MetricsSelectorUIBean.TABLE_DATA_KEY%>" 
                      alternateTextBinding="NO_METRICS@gensvc"
                      id="<%=MetricsSelectorUIBean.TABLE_ID_KEY%>" 
                      partialRenderMode="self"
                      blockSizeBinding="<%=MetricsSelectorUIBean.BLOCK_SIZE_KEY%>"
                      maxValueBinding="<%=MetricsSelectorUIBean.MAX_KEY%>"
                      valueBinding="<%=MetricsSelectorUIBean.START_KEY%>"
                      unvalidated="true"
                      formSubmitted="true"
                      width="50%"
                      summaryBinding="METRICS@mntr"
                      >
                      <uix:tableFormat tableBanding="rowBanding"/>

                      <uix:tableSelection>
                        <uix:multipleSelection 
                          selectedBinding="<%=MetricsSelectorUIBean.SELECTED_KEY%>"
                          shortDescBinding="text"
                          />
                      </uix:tableSelection>
                      <uix:contents>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:text textBinding="METRIC@mntr"/>
                          </uix:columnHeader>
                          <uix:contents>
                            <uix:text textBinding="text"/>
                          </uix:contents>
                        </uix:column>
                        <uix:formValue name="metricName" valueBinding="text"/>
                      </uix:contents>
                    </uix:table>
                  </uix:dataScope>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>

              </uix:tableLayout>

            </uix:header>
          </uix:dataScope>

          <uix:contentFooter>
            <%@ include file="configNav.jspf"%>
          </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

