<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.ui.GenSvcKeyTestViewBean"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<oem:pageSegment>
  <uix:dataScope currentDataBinding="GenSvcKeyTestViewBean@">
    <uix:bundle name="gensvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
    <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:header textBinding="KEY_TESTS@gensvcRB" renderedBinding="showKeyTests">
      <uix:stackLayout>
        <uix:spacer height="10"/>
        <uix:styledText styleClass="OraPromptText" textBinding="KEY_MONITORED_TEST_TEXT@gensvcRB"/>
        <uix:spacer height="10"/>
        <uix:form name="change_test_form" method="POST">
          <uix:rowLayout>
            <uix:messageChoice promptBinding="KEY_TEST@gensvcRB" nameBinding="TESTS_CHOICE_BOX" id="TEST_TYPE_SELECTION" selectedValueBinding="selectedTestGuid">
              <uix:contents childDataBinding="displayedTests">
                <uix:option textBinding="<%= UIConstants.TEXT_KEY %>" valueBinding="<%= UIConstants.VALUE_PARAM %>"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:spacer width="10"/>
            <uix:submitButton textBinding="GO@sdkMsg" shortDescBinding="GO@sdkMsg" name="<%= UIConstants.EVENT_PARAM %>" value="<%= GenSvcUIConstants.CHANGE_KEY_COMP_EVENT %>"/>
            <uix:spacer width="10"/>
          </uix:rowLayout>
        </uix:form>
        <uix:spacer height="10"/>
        <oem:chart chartType="timeSeriesChart" 
                 orientation="vertical" 
                 width="800" height="300" 
                 seriesColorsAutomatic="true" legendPositionBinding="east" 
                 yAxisLabelBinding="YAxis">
        <uix:contents>
          <oem:boundChartDataSource chartDataSourceBinding="chartData"/>
          <oem:chartColumn sourceIndex="0" isKey="true"/>
          <oem:chartColumn sourceIndex="1" isTimeColumn="true"/>
          <oem:chartColumn sourceIndex="2" displayLabel=""/>
        </uix:contents>
      </oem:chart>
      <uix:spacer height="10"/>
      <uix:header textBinding="CURRENT_PERF@gensvcRB">
        <uix:include nodeBinding="tableBean@"/>
      </uix:header>
      </uix:stackLayout>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
