<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.ui.GenSvcTestHGridViewBean"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<%@ page import="oracle.sysman.emSDK.page.seg.PageSegmentContext"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<oem:pageSegment>
  <uix:dataScope currentDataBinding="GenSvcTestHGridViewBean@">
    <uix:bundle name="mntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
    <%     
      PageSegmentContext psc = (PageSegmentContext) request.getAttribute("pageSegmentContext");
      GenSvcTestHGridViewBean viewBean = (GenSvcTestHGridViewBean) psc.getAttribute("GenSvcTestHGridViewBean");
      
    %>
    <uix:header textBinding="header">
      <uix:form nameBinding="formName" method="post">
        <uix:rowLayout>
          <uix:messageChoice promptBinding="VIEW_BY@gensvcRB" nameBinding="PIVOT_BOX" id="pivot_selection" selectedValueBinding="selectedValue" onChangeBinding="formSubmissionStr">
            <uix:contents childDataBinding="pivotChoices">
              <uix:option textBinding="<%= UIConstants.TEXT_KEY %>" valueBinding="<%= UIConstants.VALUE_PARAM %>"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:rowLayout>
        <uix:hGrid partialRenderMode="self" width="80%" treeDataBinding="root" columnHeaderDataBinding="colHeaders" proxied="true" proxyBinding="proxy" id="<%= viewBean.getID() %>" columnFormatsBinding="colFormats" formSubmitted="true" summaryBinding="header">
          <uix:nodeStamp>
            <uix:column columnFormatBinding="firstColFormat">
              <uix:columnHeader>
                <uix:styledText textBinding="NAME_LABEL@mntrRB"/>
              </uix:columnHeader>
              <uix:styledText shortDescBinding="<%= GenSvcTestHGridViewBean.NAME_COL_KEY %>" textBinding="<%= GenSvcTestHGridViewBean.NAME_COL_KEY %>" styleClassBinding="keyStyle" destinationBinding="<%= GenSvcTestHGridViewBean.NAME_LINK_KEY %>"/>
            </uix:column>
          </uix:nodeStamp>
          <uix:columnHeaderStamp>
            <uix:text textBinding="<%= GenSvcTestHGridViewBean.COL_HDR_KEY %>"/>
          </uix:columnHeaderStamp>
          <%     
          ArrayList columns = viewBean.getColumns();
          for(int i = 0 ; i < columns.size(); i++) 
          {
            String columnKey = (String) columns.get(i);
            String columnLinkKey = (String) columns.get(++i);
          %>
            <uix:styledText styleClass = "OraDataText" textBinding="<%= columnKey %>" destinationBinding="<%= columnLinkKey %>" />
            <%     
          }
          %>
          <uix:image sourceBinding="<%= GenSvcTestHGridViewBean.STATUS_COL_KEY %>" destinationBinding="<%= GenSvcTestHGridViewBean.STATUS_DEST_KEY %>"/>
          <uix:text textBinding="<%= GenSvcTestHGridViewBean.TIMESTAMP_COL_KEY %>"/>
        </uix:hGrid>
      </uix:form>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
