<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.ui.GenSvcTestPerfViewBean"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<jsp:useBean id="UI_BEAN" scope="request" type="oracle.sysman.eml.gensvc.view.data.ui.GenSvcTestPerfViewBean"/>
<uix:buildTree nodeID="homePlugin">
  <uix:renderingContext id="renderingContext">
    <uix:dataScope currentDataBinding="UI_BEAN@servletRequest">
      <uix:bundle name="gensvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
      <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
      <uix:messageBox messageBinding="NO_TEST_BCNS_DEFINED@gensvcRB" messageType="info" renderedBinding="noTestDefined"/>
      <uix:tableLayout width="100%">
        <uix:rowLayout hAlign="right" vAlign="top">
          <uix:rowLayout>
            <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED_TIME@sdkMsg"/>
            <uix:spacer width="4"/>
            <uix:styledText styleClass="OraTipLabel" textBinding="LAST_REFRESH@servletRequest"/>
            <uix:spacer width="4"/>
            <uix:image sourceBinding="refreshImage" destinationBinding="refreshLink"/>
          </uix:rowLayout>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:ref refID="<%= GenSvcTestPerfViewBean.UPPER_PAGE_SEGMENT %>"/>
      <uix:header textBinding="ALL_TESTS@gensvcRB">
        <uix:styledText styleClass="OraPromptText" textBinding="ALL_TESTS_INSTRUCTION@gensvcRB"/>
        <uix:spacer height="10"/>
        <%       
          ArrayList refIDs = UI_BEAN.getRefIDs();
          for(int i = 0 ; i < refIDs.size(); i++) 
          {
            String refID = (String) refIDs.get(i);
        %>
        <uix:ref refID="<%= refID %>"/>
        <uix:spacer height="20"/>
        <%       
          }
        %>
      </uix:header>
    </uix:dataScope>
  </uix:renderingContext>
</uix:buildTree>
<%@ include file="/gensvc/view/gensvcViewTemplate.jspf"%>
