<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.ui.SvcCompAvailUIBean"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.SvcAvailData"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="GenSvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:bundle name="MntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="aggSvcRB" class="oracle.sysman.eml.target.svc.AggSvcMsg"/>
  <uix:bundle name="WebsiteRB" class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle" />
  <uix:dataScope currentDataBinding="_DATA_SOURCE@servletRequest">
    <uix:document>
      <%@ include file="/enablePPR.jspf"%>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:header textBinding="headerPage">
            <uix:contents>
              <uix:dataScope currentDataBinding="@servletRequest">
                <%@ include file="/gensvc/message.jspf"%>
              </uix:dataScope>
              <uix:tableLayout width="100%">
                <uix:rowLayout vAlign="top">
                  <uix:cellFormat width="100%">
                    <uix:stackLayout>
                      <uix:form name="OneBigForm" method="POST">
                        <uix:formValue nameBinding="REFRESHUI" valueBinding="NO_REFRESH"/>
                        <uix:tableLayout width="100%" borderWidth="0">
                        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:rowLayout>
                                <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED_TIME@sdkMsg"/>
                                <uix:spacer width="4"/>
                                <uix:styledText styleClass="OraTipLabel" textBinding="lastUpdateTime"/>
                                <uix:spacer width="4"/>
                                <uix:image destinationBinding="refreshLink" sourceBinding="refreshImage"/>
                              </uix:rowLayout>
                            </uix:cellFormat>
                            <uix:cellFormat width="10"/>
                            <uix:cellFormat width="80" vAlign="top" hAlign="right">
                              <uix:messageChoice nameBinding="CHANGE_PERIOD_EVENT" id="PeriodChange" onChange="submitForm('OneBigForm',0,{'event':'CHANGE_PERIOD'}); return false;"
                                promptBinding="VIEWDATA_TEXT@sdkMsg"
                                >
                                <uix:contents>
                                  <uix:option textBinding="LAST_DAY@MntrRB" value="<%= SvcAvailData.P24H %>" selectedBinding="viewByDay"/>
                                  <uix:option textBinding="LAST_WEEK@MntrRB" value="<%= SvcAvailData.P7D %>" selectedBinding="viewByWeek"/>
                                  <uix:option textBinding="LAST_MONTH@MntrRB" value="<%= SvcAvailData.P31D %>" selectedBinding="viewByMonth"/>
                                </uix:contents>
                              </uix:messageChoice>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:header textBinding="GENERAL_HDR@MntrRB">
                          <uix:stackLayout>
                            <uix:tableLayout widthBinding="tableWidth" borderWidth="0">
                              <uix:contents>
                                <uix:dataScope currentDataBinding="availOverview">
                                  <uix:rowLayout>
                                    <uix:cellFormat width="50%" vAlign="top">
                                      <uix:tableLayout width="100%" borderWidth="0">
                                        <uix:rowLayout>
                                          <uix:cellFormat width="50%" hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.CURRENT_STATUS_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>                                        
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="SINCE@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.SINCE_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                                                                
                                        <!-- Root Cause Analysis of Down Status-->
                                        <uix:dataScope currentDataBinding="rcaAvailData@servletRequest" >
                                          <uix:rowLayout renderedBinding="showRcaDSData@" vAlign="top" >
                                            <uix:cellFormat hAlign="right">
                                              <uix:styledText styleClass="OraPromptText" textBinding="RCA_DOWN_STATUS@rcaResourceBundle"/>
                                            </uix:cellFormat>
                                            <uix:spacer width="5"/>
                                            <uix:cellFormat hAlign="left">
                                              <uix:styledText styleClassBinding="styleType@availData" textBinding="rootCauseMsg@" destinationBinding="rcaDownStatusDest@" />
                                            </uix:cellFormat>
                                          </uix:rowLayout>
                                          <!-- Services Impacted by Down Status-->
                                          <uix:rowLayout renderedBinding="showRcaSIData@" vAlign="top" >
                                            <uix:cellFormat hAlign="right">
                                              <uix:styledText styleClass="OraPromptText" textBinding="RCA_SERV_IMPACTED_BY_DOWN_STATUS@rcaResourceBundle"/>
                                            </uix:cellFormat>
                                            <uix:spacer width="5"/>
                                            <uix:cellFormat hAlign="left">
                                              <uix:styledText textBinding="noOfSrvcsImpacted@" destinationBinding="srvcsImpactedDest@" />
                                            </uix:cellFormat>
                                          </uix:rowLayout>
                                        </uix:dataScope>
   
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="AVAILABILITY_PERCENT@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.AVAIL_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="AVAILABILITY@GenSvcRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.AVAIL_BASED_ON_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_DOWN_TIME@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_DOWNTIME_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_BLACKOUT_TIME@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.SCH_DOWNTIME_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_AGENT_DOWN_TIME@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_UNMONTIME_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_METRIC_ERROR_TIME@MntrRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_ERROR_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout>
                                       
                                        <%-- uix:rowLayout>
                                          <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_PERF_PROB_TIME@GenSvcRB"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                          <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_PERF_PROB_KEY %>"/>
                                          </uix:cellFormat>
                                        </uix:rowLayout --%>
                                      </uix:tableLayout>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top" width="480">
                                      <uix:switcher childNameBinding="<%= SvcCompAvailUIBean.SHOW_CHART %>">
                                      <uix:case name="true">
                                      <oem:chart chartType="pieChart" width="480" legendPosition="east" height="175" pieValuesInLegend="percent" showSlicePercentLabels="false" pieSliceColorsBinding="<%= SvcCompAvailUIBean.PIE_SLICE_COLORS_KEY %>">
                                        <uix:contents>
                                          <oem:boundChartDataSource chartDataSourceBinding="<%= SvcCompAvailUIBean.CHART_DATA_SOURCE_KEY %>"/>
                                          <oem:chartColumn sourceIndex="0" isKey="true"/>
                                          <oem:chartColumn sourceIndex="1" displayLabel=""/>
                                        </uix:contents>
                                      </oem:chart>
                                      </uix:case>
                                      <uix:case name="false">
                                        <uix:styledText textBinding="DATA_NOT_AVAILABLE@MntrRB" styleClass="OraDataText"/>
                                      </uix:case>
                                     </uix:switcher>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                </uix:dataScope>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:stackLayout>
                        </uix:header>
                      <uix:header textBinding="DETAILS@aggSvcRB">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:rowLayout>
                                <uix:checkBox checkedBinding="showKeyComponents" id="<%= SvcCompAvailUIBean.SHOW_KEY_COMPONENTS_CHECKBOX_ID %>" textBinding="choiceBoxMsg" nameBinding="SHOW_KEY_COMPONENTS_CHECKBOX_ID" styleClass="OraPromptText" onClick="submitForm('OneBigForm',0,{'event':'CHANGE_KEY_COMP'}); return false;"/>
                              </uix:rowLayout>
                              <uix:spacer height="10"/>
                                  <uix:ref refID="SVC_AVAIL_HISTORY_HGRID_SEGEMENT"/>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:ref refID="<%= SvcCompAvailUIBean.alertTableRefID %>"/>
                      </uix:form>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="10"/>
            </uix:contents>
          </uix:header>
        </uix:pageLayout>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
