<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthDeletedTargets"/>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <uix:header textBinding="DELETED_TARGETS_LABEL@HealthResourceBundle">
        <%@ include file="healthTimestampandError.jsp" %> 
          <%
             String orientation = "top";
             String hasDelete = (String)request.getAttribute("hasDelete");
          %>
        <%@ include file="healthFaintTabs.jsp" %>               
        <uix:spacer width="2" />
        <uix:rowLayout >
          <uix:spacer width="5" />
            <uix:tableLayout width="100%" cellSpacing="2">
              <uix:form name="submit" method="POST" destinationBinding="Deletedestination@servletRequest">
                <uix:formValue name="value"/>
                <uix:rowLayout width="100%" >
                  <uix:spacer width="3" />
                  <uix:table name="deletedTargetTable" 
                       tableDataBinding="deletedTargetTableData@servletRequest" 
                       destinationBinding="destination@servletRequest"
                       columnHeaderDataBinding="deletedTargetTableHeaderData@servletRequest"
                       alternateTextBinding="NO_DELETED_TARGETS@HealthResourceBundle"
                       summaryBinding="DELETED_TARGETS_LABEL@HealthResourceBundle"
                       width="100%"
                       formSubmitted="false"
                       minValue="1"
                       maxValueBinding="delMaxSize@defaultBean@servletRequest"
                       blockSizeBinding="delBlockSize@defaultBean@servletRequest"
                       valueBinding="delStIndex@defaultBean@servletRequest"
                       showAll="yes">
                 <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>
           <%
                  if((hasDelete != null) && (hasDelete.equals("true")))
                  {
           %>
                    <uix:tableSelection>
                      <uix:singleSelection disabledBinding="disabled">
                        <uix:submitButton formName="submit"
                            name="delete" textBinding="FORCE_DELETE@HealthResourceBundle" value="delete" />
                      </uix:singleSelection>
                    </uix:tableSelection>
           <%
                  }
           %>
                    
                    <uix:styledText textBinding="targetName"/>
                    <uix:styledText textBinding="targetType"/>
                    <uix:styledText textBinding="emdUrl"/>
                    <uix:styledText textBinding="deleteReqTime"/>
                    <uix:styledText textBinding="deleteCompleteTime"/>
                    <uix:styledText textBinding="lastUpdateTime" />
                  </uix:table>
                </uix:rowLayout>
        <uix:spacer width="2" />
                <uix:rowLayout width="100%">
                  <uix:tip>
           <%
                  if((hasDelete != null) && (hasDelete.equals("true")))
                  {
           %>
                    <uix:inlineMessage messageBinding="TARGET_DEL_TIP@HealthResourceBundle"/>
           <%
                  }
                  else
                  {
           %>
                    <uix:inlineMessage messageBinding="DELETED_TARGETS_DESCRIPTION@HealthResourceBundle"/>
           <%
                  }
           %>
                  </uix:tip>
                </uix:rowLayout>
              </uix:form>
          </uix:tableLayout >
        </uix:rowLayout >
        <uix:spacer width="2" />
          <%
             orientation = "bottom";
          %>
        <%@ include file="healthFaintTabs.jsp" %>        
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
