<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthDupTargetBeanInfo"/>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
     <uix:form name="RelocateTargets" method="POST">
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <%@ include file="/sdk/page/pageMsgBox.jspf" %>
        <uix:header textBinding="DUP_TARGET_LABEL@HealthResourceBundle"/>
        <uix:spacer width="2" />
        <%@ include file="healthTimestampandError.jsp" %> 
          <%
             String orientation = "top";
          %>
        <%@ include file="healthFaintTabs.jsp" %>               
        <uix:spacer width="2" />

<uix:rowLayout width ="100%" >
<uix:cellFormat hAlign="right">

</uix:cellFormat>
</uix:rowLayout>
<uix:spacer width="2" />

        <uix:rowLayout >
        <uix:spacer width="5" />

            <uix:tableLayout width="100%" cellSpacing="2">
             <uix:rowLayout width="100%" >
              <uix:spacer width="3" />
                <uix:table name="dupTargetTable" 
                   tableDataBinding="dupTargetTableData@servletRequest" 
                   destinationBinding="destination@servletRequest"
                   columnHeaderDataBinding="dupTargetTableHeaderData@servletRequest"
                   width="100%"
                   formSubmitted="false"
                   minValue="1"
                   maxValueBinding="maxValue@defaultBean@servletRequest"
                   blockSizeBinding="blockSize@defaultBean@servletRequest"
                   valueBinding="stIndex@defaultBean@servletRequest"
                   showAll="yes">
		   <uix:tableSelection>
		   <uix:singleSelection>
	      <uix:submitButton formName ="RelocateTargets" 
		  name="event" 
                   value="relocateTargets" 
                   textBinding="DUP_TARGET_RELOCATE@HealthResourceBundle"/>
	</uix:singleSelection>
		   </uix:tableSelection>
                <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                
                </uix:columnHeaderStamp>
                <uix:styledText textBinding="targetName"/>
                <uix:styledText textBinding="targetType"/>
                <uix:styledText textBinding="displayName"/>
                <uix:styledText textBinding="displayType"/>
                <uix:styledText textBinding="monitoringAgent"/>
                <uix:styledText textBinding="conflictingAgent" 
                      destinationBinding="conflictingAgentdestination"/>
                <uix:styledText textBinding="detectedTime"/>
                
		<uix:formValue name="targetName" valueBinding="targetName" />
		<uix:formValue name="targetType" valueBinding="targetType" />
	        <uix:formValue name="monitoringAgent" valueBinding="monitoringAgent" />
                <uix:formValue name="conflictingAgent" valueBinding="conflictingAgent" />   
              </uix:table>
             </uix:rowLayout>
            </uix:tableLayout>
        </uix:rowLayout >
        <uix:rowLayout width="100%">
          <uix:tip>
            <uix:inlineMessage messageBinding="DUP_TARGET_DESCRIPTION@HealthResourceBundle"/>
          </uix:tip>
        </uix:rowLayout>
        <uix:spacer width="2" />
          <%
             orientation = "bottom";
          %>
        <%@ include file="healthFaintTabs.jsp" %>        
      </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
