<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="java.util.ResourceBundle"%>
<%@ page import="oracle.cabo.ui.RenderingContext"%>
<%@ page import="oracle.cabo.ui.ServletRenderingContext"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthHomeBeanInfo"/>
<uix:renderingContext id="renderingContext" >
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>

  <uix:bundle name="MntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  
  <uix:bundle name="PolicyJspMsg" 
              class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
                 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
                               <%
                               ResourceBundle rb =
                                  NLSUtil.getBundle(HealthResourceBundle.class.getName(), request);
                               String statusImage = defaultBean.getgotrafficImage();
                               ServletRenderingContext rctx = new ServletRenderingContext(pageContext);
                               String helpDest = defaultBean.getOOBHelpDestination(pageContext, (RenderingContext)rctx);
                               %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <uix:header textBinding="header@defaultBean@servletRequest">
          <%@ include file="healthTimestampAndTabs.jsp" %>        
          <uix:tableLayout width="100%">
            <uix:contents>
              <uix:rowLayout vAlign="top" hAlign="left" width="100%">            
                <uix:cellFormat hAlign="right" width="40%">
                  <uix:tableLayout width="100%">
                    <uix:contents>
                      <uix:rowLayout vAlign="top" hAlign="left" width="100%">            
                        <uix:cellFormat width="100%">
                          <uix:header textBinding="GENERAL@HealthResourceBundle" size="1">
                            <uix:tableLayout  width="100%">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:cellFormat width="10%">
                                    <uix:image source="<%=statusImage%>"
                                               shortDescBinding="UP@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat width="90%">
                               <%
                                String agent = (String)request.getAttribute("agent");
                                String agentdest = (String)request.getAttribute("agentdestination");
                                if((agent != null) && (agent.length() > 0))
                                {
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText 
                                           textBinding="AVAILABILITY@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText 
                                           textBinding="availability@servletRequest"
                                           styleClass="OraInstructionText"
                                           destinationBinding="availabilitydestination@servletRequest" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%"/>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText textBinding="AVAILABILITY_TIP@HealthResourceBundle" 
                                           styleClass="OraInlineInfoText"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText 
                                           textBinding="DUP_TARGET_HEADER_5@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText 
                                           text="<%=agent%>"
                                           styleClass="OraInstructionText"
                                           destination="<%=agentdest%>" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                               <%
                                 }
                                 else
                                 {
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText
                                           textBinding="AVAILABILITY@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText
                                           textBinding="UNKNOWN_AVAILABILITY@MntrResourceBundle"
                                           styleClass="OraInstructionTextStrong" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText 
                                           textBinding="DUP_TARGET_HEADER_5@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText 
                                           textBinding="NOT_DEFINED@MntrResourceBundle"
                                           styleClass="OraInstructionTextStrong" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                               <%
                                 }
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText 
                                           textBinding="MGMT_SERV@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText 
                                           textBinding="totalOms@defaultBean@servletRequest"
                                           styleClass="OraInstructionText"
                                           destinationBinding="servicesLink@defaultBean@servletRequest" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText 
                                           textBinding="AGENTS@HealthResourceBundle"
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText 
                                           textBinding="totalAgents@defaultBean@servletRequest"
                                           styleClass="OraInstructionText"
                                           destinationBinding="agentsLink@defaultBean@servletRequest" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                                  String targetCount = (String)request.getAttribute("targetCount");
                                  String userCount = (String)request.getAttribute("userCount");
                                  if(targetCount != null)
                                  {
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="NUMBER_OF_TARGETS@HealthResourceBundle" 
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=targetCount%>" 
                                           styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                               <%
                                  }
                                  else
                                  {
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="NUMBER_OF_TARGETS@HealthResourceBundle"
                                            styleClass="OraInstructionText"/>
                                     </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle"                                                                                                               
                                            styleClass="OraInstructionTextStrong"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                                   }
                                   if(userCount != null)
                                   {
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="NUMBER_OF_ADMINISTRATORS@HealthResourceBundle" 
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=userCount%>" 
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                                   }
                                   else
                                   {
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="NUMBER_OF_ADMINISTRATORS@HealthResourceBundle" 
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle" 
                                            styleClass="OraInstructionTextStrong"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                               }
                               String deletedTargetCount = (String)request.getAttribute("deletedTargets");
                               String deletedTargetCountDest = (String)request.getAttribute("deletedTargetsdestination");
                               if (deletedTargetCount != null) 
                               {
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="DELETED_TARGETS_LABEL@HealthResourceBundle"
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=deletedTargetCount%>"
                                            styleClass="OraInstructionText"
                                            destination="<%=deletedTargetCountDest%>"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                               }
                               String dupCount = defaultBean.getdupTargetCount();
                               String dupCountDest = defaultBean.getdupTargetLink();
                               if (dupCount != null) 
                               {
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="DUP_TARGET_LABEL@HealthResourceBundle" 
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=dupCount%>" 
                                            styleClass="OraInstructionText"
                                            destination="<%=dupCountDest%>"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                               }
                               %>

                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="CLIENT_SESSION_COUNT@HealthResourceBundle" 
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText textBinding="clientSessions@servletRequest" 
                                            styleClass="OraInstructionTextStrong" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                               <%
                               String jobbacklog = (String)request.getAttribute("repository_job_backlog");
                               String jobbacklogDest = (String)request.getAttribute("repository_job_backlogdestination");
                               String jobbacklogImage = (String)request.getAttribute("repository_job_backlogimage");
                               if (jobbacklog != null)
                               {
                                    if(jobbacklogDest != null)
                                    {
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="JOB_BACKLOG@HealthResourceBundle"
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%">
                                        <uix:image source="<%=jobbacklogImage%>"
                                                   shortDescBinding="JOB_BACKLOG@HealthResourceBundle"/> 
                                      </uix:cellFormat>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=jobbacklog%>"
                                            styleClass="OraInstructionText" 
                                            destination="<%=jobbacklogDest%>"/>
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                               <%
                                    }
                                    else
                                    {
                               %>
                                    <uix:rowLayout width="100%">
                                      <uix:cellFormat hAlign="right" width="49%">
                                        <uix:styledText textBinding="JOB_BACKLOG@HealthResourceBundle"
                                            styleClass="OraInstructionText"/>
                                      </uix:cellFormat>
                                      <uix:cellFormat width="2%"/>
                                      <uix:cellFormat hAlign="left" width="49%">
                                        <uix:styledText text="<%=jobbacklog%>"
                                            styleClass="OraInstructionTextStrong" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                               <%
                                     }
                               }
                               %>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:header>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="60%">
                          <uix:header textBinding="LOADER_BACKLOG_GRAPH_LABEL@HealthResourceBundle" size="1">
                            <uix:tableLayout cellSpacing="2" width="50%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                               <%
                               SimpleChartDataSource chartData = (SimpleChartDataSource)request.getAttribute("loaderChartData");
                               if(chartData == null)
                               {
                               %>
                                  <uix:styledText textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle" 
                                            styleClass="OraInstructionTextStrong"/>
                               <%
                               }
                               else
                               {
                               %>
                                  <uix:cellFormat hAlign="left" width="95%">
                                    <oem:chart
                                          title=""
                                          shortDescBinding="LOADER_BACKLOG_GRAPH_LABEL@HealthResourceBundle"
                                          chartType="timeSeriesChart"
                                          orientation="vertical"
                                          width="400"
                                          height="200"
                                          yAxisLabelBinding="LOADER_BACKLOG_GRAPH_Y_AXIS_LABEL@HealthResourceBundle"
                                          timeGranularity="HOUR"
                                          xAxisMinBinding="loaderXAxisMin@servletRequest"
                                          xAxisMaxBinding="loaderXAxisMax@servletRequest"
                                          destinationBinding="loaderImageDest@defaultBean@servletRequest"
                                          legendPosition="south">
                                      <uix:contents>
                                        <oem:boundChartDataSource
                                               chartDataSourceBinding = "loaderChartData@servletRequest"/>
                                        <oem:chartColumn sourceIndex="0"
                                               displayLabelBinding="LOADER_BACKLOG_GRAPH_LABEL@HealthResourceBundle"/>
                                        <oem:chartColumn sourceIndex="1"
                                               displayLabel="Time"
                                               isTimeColumn="true"/>
                                      </uix:contents>
                                    </oem:chart>
                                  </uix:cellFormat>
                               <%
                               }
                               %>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:header>
                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout vAlign="top" hAlign="left" width="100%">            
                        <uix:cellFormat hAlign="right" width="40%">
                          <uix:header textBinding="REP_DETAILS@HealthResourceBundle" size="1">
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:cellFormat width="10%"/>
                                  <uix:cellFormat width="90%">

                               <%
                               String[] host = defaultBean.gethost();
                               String[] hostDest = defaultBean.gethostDestination();
                               String msg = rb.getString("HOST");
                               if((host != null) && (host.length > 0))
                               {
                                 if(host.length > 1)
                                 {
                                   msg = rb.getString("HOSTS");
                                 }
                                 for(int i = 0;i < host.length;i++)
                                 {
                               %>

                                <uix:rowLayout vAlign="top" width="100%">
                                  <uix:cellFormat hAlign="right" width="49%" height="5">
                                    <uix:spacer width="2"/>                            
                                    <uix:styledText 
                                            text="<%=msg%>"
                                            styleClass="OraInstructionText"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat width="2%"/>

                               <%
                                   if((host[i] != null) && (host[i].length() > 0)
                                     && (hostDest[i] != null) && (hostDest[i].length() > 0))
                                   {
                               %>

                                  <uix:cellFormat hAlign="left" width="49%">
                                    <uix:styledText 
                                            text="<%=host[i]%>"
                                            styleClass="OraInstructionText"
                                            destination="<%=hostDest[i]%>" />
                                  </uix:cellFormat>

                               <%
                                   }
                                   else if((host[i] != null) && (host[i].length() > 0))
                                   {
                               %>

                                  <uix:cellFormat hAlign="left" width="49%">
                                    <uix:styledText 
                                            text="<%=host[i]%>"
                                            styleClass="OraInstructionTextStrong" />
                                  </uix:cellFormat>

                               <%
                                   }
                                   else
                                   {
                               %>

                                  <uix:cellFormat hAlign="left" width="49%">
                                    <uix:styledText 
                                            textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle"
                                            styleClass="OraInstructionTextStrong" />
                                  </uix:cellFormat>

                               <%
                                   }  
                                   msg = ""; // We only display the message on the first line
                               %>

                                </uix:rowLayout>

                               <%
                                 }
                               }
                               String[] dbdest = defaultBean.getdbDestination();
                               String[] repository = defaultBean.getrepository();
                               msg = rb.getString("DATABASE");
                               boolean begin = true;
                               if((repository != null) && (repository.length > 0))
                               {
                                 if(repository.length > 1)
                                 {
                                   msg = rb.getString("DATABASES");
                                 } 
                                 for(int i=0;i<repository.length;i++)
                                 {
                               %>

                                <uix:rowLayout vAlign="top" width="100%">
                                  <uix:cellFormat hAlign="right" width="49%" height="5">
                                    <uix:spacer width="2"/>                            
                                    <uix:styledText 
                                            text="<%=msg%>"
                                            styleClass="OraInstructionText"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat width="2%"/>
                                  <uix:cellFormat hAlign="left" width="49%">

                               <%
                                   if((dbdest[i] != null) && (dbdest[i].length() > 0))
                                   {
                               %>

                                    <uix:styledText 
                                            text="<%=repository[i]%>"
                                            styleClass="OraInstructionText" 
                                            destination="<%=dbdest[i]%>"/>

                               <%
                                   }
                                   else
                                   {
                                     if((repository[i] != null) && (repository[i].length() > 0))
                                     {
                               %>

                                    <uix:styledText 
                                            text="<%=repository[i]%>"
                                            styleClass="OraInstructionTextStrong" />                           

                               <%
                                     }
                                     else
                                     {
                               %>

                                    <uix:styledText 
                                            textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle"
                                            styleClass="OraInstructionTextStrong" />                           

                               <%
                                     }
                                   }
                               %>

                                  </uix:cellFormat>
                                </uix:rowLayout>

                               <%
                                   msg = ""; // We only display the message on the first line
                                 }  // end of the loop
                               } // end of if dbs found
                               String tablespaceused = (String)request.getAttribute("usedRepSpace");
                               String tablespaceusedunit = (String)request.getAttribute("usedRepSpaceunits");
                               String tablespaceUsedDisplay = tablespaceused+" "+tablespaceusedunit;
                               String tablespacetotal = (String)request.getAttribute("totalRepSpace");
                               String tablespacetotalunit = (String)request.getAttribute("totalRepSpaceunits");
                               String tablespaceTotalDisplay = tablespacetotal+" "+tablespacetotalunit;
                               String tablespaceuseddest = null;
                               String tablespacetotaldest = null;
                               tablespaceuseddest = (String)request.getAttribute("usedRepSpacedestination");
                               tablespacetotaldest = (String)request.getAttribute("totalRepSpacedestination");
                               String used = tablespaceused+tablespaceusedunit+rb.getString("OF")+
                                     tablespacetotal+tablespacetotalunit;
                               String[] tablespaces = defaultBean.gettablespaces();
                               String[] tablespaceDest = defaultBean.gettablespacesDest();
                               if((tablespaces != null) && (tablespaces.length > 0))
                               {
                                 msg = rb.getString("TABLESPACES");
                                 for(int i=0;i<tablespaces.length;i++)
                                 {
                               %>

                                <uix:rowLayout width="100%">
                                  <uix:cellFormat hAlign="right" width="49%">
                                    <uix:styledText 
                                            text="<%=msg%>"
                                            styleClass="OraInstructionText"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat width="2%"/>
                                  <uix:cellFormat hAlign="left" width="49%">

                               <%
                                   if((tablespaceDest != null ) && (tablespaceDest.length > 0))
                                   {
                               %>

                                    <uix:styledText text="<%=tablespaces[i]%>" 
                                            styleClass="OraInstructionText" 
                                            destination="<%=tablespaceDest[i]%>"/>

                               <%
                                   }
                                   else
                                   {
                               %>

                                    <uix:styledText text="<%=tablespaces[i]%>" 
                                            styleClass="OraInstructionTextStrong"/>

                               <%
                                   }
                               %>

                                  </uix:cellFormat>
                                </uix:rowLayout>

                               <%
                                   msg = "";
                                 } // end of tablespace loop
                               } // end of tablespaces not null
                               %>

                                <uix:rowLayout width="100%">
                                  <uix:cellFormat hAlign="right" width="49%">
                                    <uix:styledText textBinding="SPACE_USED@HealthResourceBundle" 
                                            styleClass="OraInstructionText"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat width="2%"/>

                               <%
                               if(( tablespaceuseddest == null) || (tablespaceuseddest.length() < 1) ||
                                  (tablespacetotaldest == null) || (tablespacetotaldest.length() < 1))
                               {
                               %>

                                  <uix:cellFormat hAlign="left" width="49%">
                                    <uix:styledText text="<%=tablespaceUsedDisplay%>" 
                                            styleClass="OraInstructionTextStrong"/>
                                  </uix:cellFormat>

                               <%
                               }
                               else
                               {
                               %>

                                  <uix:cellFormat hAlign="left" width="49%"
                                        wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:flowLayout >
                                        <uix:styledText text="<%=tablespaceUsedDisplay%>" 
                                              destination="<%=tablespaceuseddest%>"
                                              styleClass="OraInstructionText"/>
                                        <uix:styledText textBinding="OF@HealthResourceBundle" 
                                              styleClass="OraInstructionText"/>
                                        <uix:styledText text="<%=tablespaceTotalDisplay%>" 
                                              destination="<%=tablespacetotaldest%>"
                                              styleClass="OraInstructionText"/>
                                      </uix:flowLayout>
                                    </uix:contents>                  
                                  </uix:cellFormat>

                               <%
                               }
                               %>

                                </uix:rowLayout>

                                <uix:rowLayout width="100%">
                                  <uix:cellFormat hAlign="right" width="49%"/>
                                  <uix:cellFormat width="2%"/>
                                  <uix:cellFormat hAlign="left" width="49%"
                                        wrappingDisabled="true">
                                    <uix:image sourceBinding="cigarUsedImage@defaultBean@servletRequest" 
                                            widthBinding="cigarUsedWidth@servletRequest"
                                            height="15"/>
                                    <uix:image sourceBinding="cigarNotUsedImage@defaultBean@servletRequest" 
                                            widthBinding="cigarNotUsedWidth@servletRequest"
                                            height="15"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                              </uix:contents>
                            </uix:tableLayout>
                          </uix:header>
                        </uix:cellFormat>
                        <uix:cellFormat width="60%">
                               <%
                                 String headerstring = rb.getString("EMD_NOTIFICATION_DELIVERY")+" "+rb.getString("BACKLOG");
                               %>
                          <uix:header text="<%=headerstring%>" size="1">
                            <uix:tableLayout cellSpacing="2" width="50%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                               <%
                               SimpleChartDataSource chartData = (SimpleChartDataSource)request.getAttribute("notifChartData");
                               if(chartData == null)
                               {
                               %>
                                  <uix:styledText textBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle"
                                            styleClass="OraInstructionTextStrong"/>
                               <%
                               }
                               else
                               {
                               %>
                                  <uix:cellFormat hAlign="left" width="95%">
                                    <oem:chart
                                        title=""
                                        shortDescBinding="NOTIF_GRAPH_LABEL@HealthResourceBundle"
                                        chartType="timeSeriesChart"
                                        orientation="vertical"
                                        width="400" 
                                        height="200"
                                        yAxisLabelBinding="NOTIF_GRAPH_Y_AXIS_LABEL@HealthResourceBundle"
                                        timeGranularity="HOUR"
                                        xAxisMinBinding="notifXAxisMin@servletRequest"
                                        xAxisMaxBinding="notifXAxisMax@servletRequest"
                                        destinationBinding="notifImageDest@defaultBean@servletRequest"
                                        legendPosition="south">
                                      <uix:contents>
                                        <oem:boundChartDataSource
                                            chartDataSourceBinding = "notifChartData@servletRequest"/>
                                        <oem:chartColumn sourceIndex="0"
                                            displayLabelBinding="NOTIF_GRAPH_LABEL@HealthResourceBundle" />
                                        <oem:chartColumn sourceIndex="1"
                                            displayLabel="Time"
                                            isTimeColumn="true"/>
                                      </uix:contents>
                                    </oem:chart>
                                  </uix:cellFormat>
                               <%
                               }
                               %>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:header>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
          <uix:tableLayout width="100%" >
            <uix:contents>
              <uix:rowLayout hAlign="left" width="100%">
                <uix:cellFormat hAlign="left" width="100%">              
                  <uix:tableLayout width="100%">
                    <uix:contents>
                      <uix:header textBinding="OUTSTANDING_ALERTS@HealthResourceBundle" size="1">

                        <uix:spacer height="4"/>
                              <uix:rowLayout vAlign="left">
                                <uix:cellFormat vAlign="left" width="100%">
                                  <uix:styledText textBinding="OOB_TIP@HealthResourceBundle"
                                     styleClass="OraInstructionText"/>
                              <%
                               if((helpDest != null) && (helpDest.length() > 0))
                               {
                              %>
                                  <uix:spacer width = "2" />
                                  <uix:image sourceBinding="infoIcon@servletRequest"
                                             destination="<%=helpDest%>" height="15"
                                             shortDescBinding="SHORTDESC_HELPICON@PolicyJspMsg"/>
                              <%
                               }
                              %>
                                </uix:cellFormat>
                              </uix:rowLayout>

                        <uix:switcher childNameBinding="hasMetricErrors@servletRequest">
                          <uix:case name="true">
                            <uix:spacer width="1" />
                            <uix:rowLayout width="100%">
                              <uix:cellFormat hAlign="right" width="20%">
                                <uix:styledText textBinding="METRIC_COL_ERR@HealthResourceBundle" 
                                      styleClass="OraInstructionText"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="right" width="2%">
                                <uix:image sourceBinding="metricErrorImage@defaultBean@servletRequest" />
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="left" width="26%">
                                <uix:styledText textBinding="metricErrors@servletRequest" 
                                      styleClass="OraInstructionText"
                                      destinationBinding="metricErrorsdestination@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="left" width="25%"/>
                              <uix:cellFormat hAlign="left" width="25%"/>
                            </uix:rowLayout>
                          </uix:case>
                        </uix:switcher>

                        <uix:switcher childNameBinding="hasRelMetricErrors@servletRequest">
                          <uix:case name="true">
                            <uix:spacer width="1" />
                            <uix:rowLayout width="100%">
                              <uix:cellFormat hAlign="right" width="20%"> 
                                <uix:styledText textBinding="RELATED_ERRORS@HealthResourceBundle"
                                      styleClass="OraInstructionText"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="right" width="2%">
                                <uix:image sourceBinding="metricErrorImage@defaultBean@servletRequest" />
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="left" width="26%">
                                <uix:styledText textBinding="relmetricErrors@servletRequest" 
                                      styleClass="OraInstructionText"
                                      destinationBinding="relmetricErrorsdestination@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="left" width="25%"/>
                              <uix:cellFormat hAlign="left" width="25%"/>
                            </uix:rowLayout>
                          </uix:case>
                        </uix:switcher>

                        <uix:spacer width="1" />
                        <uix:switcher childNameBinding="hasrelAlerts@servletRequest">
                          <uix:case name="true">
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right" width="20%">
                              <uix:styledText textBinding="RELATED_ALERTS@HealthResourceBundle"
                                    styleClass="OraInstructionText"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="right" width="2%"/>
                              <uix:cellFormat hAlign="right" width="1%"/>
                              <uix:cellFormat hAlign="left" width="26%">
                                <uix:styledText textBinding="relatedAlertsCt@servletRequest"
                                    styleClass="OraInstructionText"
                                    destinationBinding="relatedAlertsCtdestination@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left" width="25%"/>
                            <uix:cellFormat hAlign="left" width="25%"/>
                          </uix:rowLayout>
                          </uix:case>
                        </uix:switcher>
                        <uix:spacer height="5"/>
                        <uix:rowLayout vAlign="top" width="100%">
        		  <uix:table name="alertsTable" 
                              width="100%"
                              tableDataBinding="alerttableData@servletRequest" 
                              summaryBinding="ALERTS_TABLE_SUMMARY@HealthResourceBundle"
                              columnHeaderDataBinding="alerttableHeaderData@servletRequest"
                              alternateTextBinding="NO_ALERTS@HealthResourceBundle"
                              destinationBinding="destination@servletRequest"
                              showAll="yes"
                              minValue="1"
                              maxValueBinding="listMaxValue@defaultBean@servletRequest"
                              blockSizeBinding="blockSize@defaultBean@servletRequest"
                              valueBinding="homeStIndex@defaultBean@servletRequest">
                            <uix:columnHeaderStamp>
                              <uix:sortableHeader textBinding="text"
                                  sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:contents>
                              <uix:column>
                                <uix:styledText textBinding="metricName" destinationBinding="alertDestination"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnFormat columnDataFormat="iconButtonFormat" /> 
                                <uix:image sourceBinding="severityImage" destinationBinding="alertDestination" 
                                           shortDescBinding="severityShortDesc" />
                              </uix:column>
                              <uix:column>
                                <uix:columnFormat columnDataFormat="iconButtonFormat" /> 
                                <uix:styledText textBinding="trigger_timestamp"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnFormat columnDataFormat="numberFormat" /> 
                                <uix:styledText textBinding="message"/>
                              </uix:column>
                              <uix:styledText textBinding="collection_timestamp"/>
                            </uix:contents>
                          </uix:table>
                        </uix:rowLayout>
                        <uix:spacer height="4"/>

                      </uix:header>

                    </uix:contents>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>

          <uix:spacer width="15"/>        
          <%
             String orientation = "bottom";
          %>
          <%@ include file="healthFaintTabs.jsp" %>        
          <uix:spacer width="1"/>        
          <%@ include file="healthRelatedLinks.jsp" %>        
          <uix:spacer width="1"/>        
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

