<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="MntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>              
  <uix:document>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthMetricErrorBeanInfo"/>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <uix:header textBinding="RELATED_ERRORS@HealthResourceBundle"/>
        <uix:tableLayout width="100%">
          <uix:rowLayout vAlign="top" hAlign="right" width="100%">
            <uix:cellFormat hAlign="right" width="40%">
              <uix:rowLayout>
                <uix:styledText styleClass="OraTipText" 
                   textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
                <uix:spacer width="4" />
                <uix:styledText styleClass="OraTipLabel" 
                   textBinding="timestamp@servletRequest"/>
                <uix:spacer width="4" />
                <uix:image sourceBinding="refreshImage@defaultBean@servletRequest"
                           shortDescBinding="REFRESH@MntrResourceBundle" 
                           destinationBinding="refreshDestination@servletRequest"/>
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          <%
              String pageMsg = defaultBean.getpageMessage();
              if(pageMsg != null && pageMsg.length() > 0)
              {
            %>
            <uix:rowLayout vAlign="top" hAlign="left" width="100%">
               <uix:inlineMessage message="<%=pageMsg%>"/>
            </uix:rowLayout>
            <%
              }
              String errMsg = defaultBean.geterrorMessage();
              if(errMsg != null && errMsg.length() > 0)
              {
            %>
            <uix:rowLayout vAlign="top" hAlign="left" width="100%">
               <uix:inlineMessage 
                  messageType="error"
                  message="<%=errMsg%>"/>
            </uix:rowLayout>
            <%
              }
            %>
        </uix:tableLayout>
        <uix:rowLayout >
        <uix:spacer width="5" />
        <uix:tableLayout width="98%" cellSpacing="5" hAlign="right">
          <uix:rowLayout width="100%" hAlign="left">
            <uix:styledText textBinding="RELATED_ERRORS_TIP@HealthResourceBundle"
                                  styleClass="OraInstructionText" />
          </uix:rowLayout>
          <uix:rowLayout width="100%" hAlign="left">
           <uix:tableLayout width="100%" cellSpacing="5">
             <uix:rowLayout width="100%" >
    	       <uix:table name="metricErrorTable" 
                   tableDataBinding="metricErrorTableData@servletRequest"
                   alternateTextBinding="NO_ERRORS@HealthResourceBundle"
                   summaryBinding="METRIC_ERROR_LABEL@HealthResourceBundle" 
                   destinationBinding="destination@servletRequest"
                   columnHeaderDataBinding="metricErrorTableHeaderData@servletRequest"
                   width="100%"
                   formSubmitted="false">
                <uix:columnHeaderStamp>
                  <uix:styledText textBinding="text" />
                </uix:columnHeaderStamp>
                <uix:styledText textBinding="targetName"
                      destinationBinding="targetNamedestination"/>
                <uix:styledText textBinding="targetType"/>
                <uix:styledText textBinding="metric"/>
                <uix:styledText textBinding="timestamp"/>
                <uix:styledText textBinding="message"
                      destinationBinding="messagedestination"/>
              </uix:table>
             </uix:rowLayout>
            </uix:tableLayout>
             </uix:rowLayout>
         </uix:tableLayout >
        </uix:rowLayout >

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
