<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="java.util.ResourceBundle"%>
<%@ page import="oracle.cabo.ui.RenderingContext"%>
<%@ page import="oracle.cabo.ui.ServletRenderingContext"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthRelatedAlerts"/>
<uix:renderingContext id="renderingContext" >
  <oem:setURLEncoder id="renderingContext"/>
                                                                                                            
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="MntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
                                                                                                   
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
                                                                                                   

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <uix:header textBinding="header@defaultBean@servletRequest">
          <uix:tableLayout width="100%" >
            <uix:rowLayout vAlign="top" hAlign="right" width="100%">
              <uix:cellFormat hAlign="right" width="40%">
                <uix:rowLayout>
                  <uix:styledText styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
                  <uix:spacer width="4" />
                  <uix:styledText styleClass="OraTipLabel"
                      textBinding="timestamp@servletRequest"/>
                  <uix:spacer width="4" />
                  <uix:image sourceBinding="refreshImage@defaultBean@servletRequest"
                           shortDescBinding="REFRESH@MntrResourceBundle"
                           destinationBinding="refreshDestination@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%" hAlign="right">
              <uix:tableLayout width="98%" cellSpacing="2">
                <uix:contents>
                  <uix:rowLayout width="95%" hAlign="left">
                    <uix:styledText textBinding="RELATED_ALERT_TIP@HealthResourceBundle"
                                  styleClass="OraInstructionText" />
                  </uix:rowLayout>
                  <uix:rowLayout width="95%" hAlign="right">
                    <uix:table name="relAlertsTable"
                         width="100%"
                         tableDataBinding="relAlerttableData@servletRequest"
                         summaryBinding="RELATED_ALERTS_TABLE_SUMMARY@HealthResourceBundle"  
                         columnHeaderDataBinding="relAlerttableHeaderData@servletRequest"
                         alternateTextBinding="NO_ALERTS@HealthResourceBundle"
                         destinationBinding="destination@servletRequest"
                         minValue="1"
                         blockSizeBinding="blockSize@defaultBean@servletRequest"
                         maxValueBinding="maxValue@defaultBean@servletRequest" 
                         valueBinding="startIndex@defaultBean@servletRequest"
                         showAll="yes">
                      <uix:columnHeaderStamp>
                        <uix:sortableHeader textBinding="text"
                                   sortableBinding="sortable"/>
                      </uix:columnHeaderStamp>
                      <uix:contents>
                        <uix:styledText textBinding="targetName"
                                destinationBinding="targetNamedestination"/>
                        <uix:styledText textBinding="targetTypeName"/>
                        <uix:styledText textBinding="metricName"
                                destinationBinding="alertDestination"/>
                        <uix:column>
                          <uix:columnFormat columnDataFormat="iconButtonFormat" />
                          <uix:image sourceBinding="severityImage" 
                                destinationBinding="alertDestination"
                                shortDescBinding="severityShortDesc"/>
                        </uix:column>
                        <uix:styledText textBinding="trigger_timestamp"/>
                        <uix:column>
                          <uix:columnFormat columnDataFormat="numberFormat" />
                          <uix:styledText textBinding="message"/>
                        </uix:column>
                        <uix:styledText textBinding="collection_timestamp"/>
                      </uix:contents>
                    </uix:table>
                  </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer width="1"/>
      </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

