<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="java.util.ResourceBundle"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<%@ page import="oracle.cabo.ui.data.ListDataObjectList"%>
<%@ page import="oracle.sysman.eml.mntr.util.GenDataObjectList"%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthRepOpsBeanInfo"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="MntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
        <uix:header textBinding="header@defaultBean@servletRequest">
        <%@ include file="healthTimestampandError.jsp" %>        
          <%
             String orientation = "top";
          %>
        <%@ include file="healthFaintTabs.jsp" %>        

        <%
          GenDataObjectList table = (GenDataObjectList)defaultBean.gettableData();
          int len = table.getLength();
          SimpleChartDataSource chartData = (SimpleChartDataSource)request.getAttribute("severitiesChartData");
          if(chartData != null)
          {
        %>
        <uix:rowLayout width="100%">
          <uix:contents>
            <uix:header textBinding="SEVERITY_GRAPH_LABEL@HealthResourceBundle" size="1">
              <uix:tableLayout cellSpacing="2" width="100%">
                <uix:contents>
                  <uix:rowLayout width="100%">
                    <uix:cellFormat hAlign="left" width="5%"/>
                    <uix:cellFormat hAlign="left" width="65%">
                      <oem:chart
                            title=""
                            shortDescBinding="SEVERITY_GRAPH_LABEL@HealthResourceBundle"
                            chartType="timeSeriesChart"
                            orientation="vertical"
                            width="450"
                            height="200"
                            yAxisLabelBinding="SEVERITY_GRAPH_Y_AXIS_LABEL@HealthResourceBundle"
                            timeGranularity="HOUR"
                            xAxisMinBinding="severitiesXAxisMin@servletRequest"
                            xAxisMaxBinding="severitiesXAxisMax@servletRequest"
                            destinationBinding="severitiesChartDatadestination@servletRequest"
                            legendPosition="south">
                        <uix:contents>
                          <oem:boundChartDataSource
                                 chartDataSourceBinding = "severitiesChartData@servletRequest"/>
                          <oem:chartColumn sourceIndex="0"
                                 displayLabelBinding="SEVERITY_GRAPH_LABEL@HealthResourceBundle"/>
                          <oem:chartColumn sourceIndex="1"
                                 displayLabel="Time"
                                 isTimeColumn="true"/>
                        </uix:contents>
                      </oem:chart>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:header>
          </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout width="100%">
        <uix:contents>
        <uix:spacer width="4" />
        <uix:header textBinding="REP_OPS_TABLE_HEADER@HealthResourceBundle" size="1">
        <uix:tableLayout cellSpacing="4" cellPadding="2" width="98%" hAlign="right">
          <uix:contents>
            <uix:rowLayout vAlign="top" width="100%">
              <uix:contents>

                <uix:table name="jobsTable" 
                    tableDataBinding="tableData@servletRequest" 
                    alternateTextBinding="METRIC_NOT_AVAILABLE@HealthResourceBundle"
                    summaryBinding="REP_OPS_TABLE_HEADER@HealthResourceBundle"                     
                    columnHeaderDataBinding="repOpsTableHeaders@servletRequest"
                    width="100%"
                    minValue="1"
                    blockSizeBinding ="blockSize@defaultBean@servletRequest"
                    maxValueBinding="maxValue@defaultBean@servletRequest" 
                    valueBinding="startIndex@defaultBean@servletRequest"
                    showAll="yes">
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text"
                              sortableBinding="sortable"/>
                  </uix:columnHeaderStamp>
                  <uix:styledText textBinding="jobName"/>
                  <uix:column>
                    <uix:columnFormat columnDataFormat="iconButtonFormat" /> 
                    <uix:image sourceBinding="jobUpDownImage"  shortDescBinding="jobUpDownDesc"/>
                  </uix:column>
                  <uix:styledText textBinding="lasterror" destinationBinding="lasterrordestination"/>         
                  <uix:column>
                    <uix:columnFormat cellNoWrapFormat="true" columnDataFormat="numberFormat" /> 
                    <uix:contents>
                      <uix:flowLayout>
                        <uix:styledText textBinding="jobthroughput" 
                           destinationBinding="jobthroughputdestination"/>
                        <uix:spacer width="5" />
                        <uix:image sourceBinding="jobthroughputimage" 
                           destinationBinding="jobthroughputdestination"/>
                        <uix:spacer width="5" />
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnFormat cellNoWrapFormat="true" columnDataFormat="numberFormat" /> 
                    <uix:contents>
                      <uix:flowLayout>
                        <uix:styledText textBinding="jobprocessing" 
                           destinationBinding="jobprocessingdestination" />
                        <uix:spacer width="5" />
                        <uix:image sourceBinding="jobprocessingimage" 
                           destinationBinding="jobprocessingdestination" 
                           shortDescBinding="SEV_CLEAR@sdkUIMsg"/>
                        <uix:spacer width="5" />
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:column>
                  <uix:styledText textBinding="scheduled"/>
                  <uix:styledText textBinding="last_run"/>
                </uix:table>
              </uix:contents>
            </uix:rowLayout>
          </uix:contents>
        </uix:tableLayout>
        </uix:header>
        </uix:contents>
        </uix:rowLayout>
        <%
           if(len > 0)
           {
        %> 
        <uix:rowLayout width="100%">
          <uix:tip>
            <uix:inlineMessage messageBinding="REP_OP_TIP@HealthResourceBundle"/>
          </uix:tip>
        </uix:rowLayout>
        <%
           }
        }
        %> 
        <uix:tableLayout width="100%" >
          <uix:rowLayout width="100%" >
          </uix:rowLayout >
          <uix:rowLayout width="100%" >
            <uix:spacer width="1"/>        
          </uix:rowLayout >
          <uix:rowLayout width="100%" >
          <%
             orientation = "bottom";
          %>
          <%@ include file="healthFaintTabs.jsp" %>
          </uix:rowLayout >
          <uix:rowLayout width="100%" >
            <uix:spacer width="1"/>        
          </uix:rowLayout >
          <%@ include file="healthRelatedLinks.jsp" %>
        </uix:tableLayout>
    </uix:header>
   </uix:pageLayout>
   </uix:body>
  </uix:document>
</uix:renderingContext>
