<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %> 
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.resources.health.HealthResourceBundle"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HealthResourceBundle"
              class="oracle.sysman.resources.health.HealthResourceBundle"/>
  <uix:bundle name="MntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.health.data.HealthSystemErrorBeanInfo"/>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="header.jsp" %>
           <%
             String tableTooLong = (String)request.getAttribute("tableTooLong");
             if((tableTooLong != null) && (tableTooLong.equals("true")))
             {
                String tableTooLongMsg = (String)request.getAttribute("tableTooLongMsg");
           %>
             <uix:messageBox messageType="info"
                 message="<%=tableTooLongMsg%>"/>
           <%
              }
           %>

        <uix:header textBinding="header@defaultBean@servletRequest">
        <%@ include file="healthTimestampAndTabs.jsp" %>        
           <%
             String hasTable = (String)request.getAttribute("hasTable");
             if(hasTable.equals("true"))
             {
           %>
        <uix:form name="sysErrPurge" destinationBinding="purgeErrorsdestination@servletRequest" method="POST" >
          <uix:tableLayout width="95%" cellSpacing="2">
            <uix:contents>
            <uix:rowLayout width="100%" hAlign = "right">
              <uix:submitButton name="sysErrPurge" textBinding="PURGE_ERRORS_BUTTON_LABEL@HealthResourceBundle"
                  destinationBinding="purgeErrorsdestination@servletRequest" />
            </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
        </uix:form>

           <%
             }
           %>

          <uix:form name="sysErr" destinationBinding="searchDestination@servletRequest" method="POST" >
            <uix:formValue name="searchString"/>
            <uix:formValue name="agentsearchString"/>
            <uix:formValue name="typeChoice"/>
            <uix:formValue name="levelChoice"/>

            <uix:header textBinding="SEARCH@HealthResourceBundle" styleClass="OraInstructionText" size="1"> 

              <uix:tableLayout width="95%" cellSpacing="3">
                <uix:contents>
                  <uix:rowLayout width="100%" hAlign="left">
                    <uix:contents>
                      <uix:cellFormat width="20%" hAlign="right">
                        <uix:contents>
                          <uix:styledText textBinding="HOME_ERRORS_HEADER_1@HealthResourceBundle"
                                labeledNodeId="typeChoice"                            
                                styleClass="OraInstructionText"/> 
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="25%" hAlign="left">
                        <uix:contents>
                          <uix:choice name="typeChoice" id="typeChoice" >
                            <uix:contents
                                  childDataBinding="componentType@servletRequest">
                              <uix:option textBinding="available"
                                  valueBinding="available"
                                  selected="false"
                                  selectedBinding="selected"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="10%" />
                      <uix:cellFormat width="20%" hAlign="right">
                        <uix:contents>
                          <uix:styledText textBinding="HOME_ERRORS_HEADER_4@HealthResourceBundle"
                                labeledNodeId="levelChoice"                          
                                styleClass="OraInstructionText"/>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="25%" hAlign="left">
                        <uix:contents>
                          <uix:choice name="levelChoice" id="levelChoice">
                            <uix:contents
                                  childDataBinding="levelType@servletRequest">
                              <uix:option textBinding="available"
                                  valueBinding="available"
                                  selected="false"
                                  selectedBinding="selected"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%" hAlign="left">
                    <uix:contents>
                      <uix:cellFormat width="20%" hAlign="right">
                        <uix:contents>
                          <uix:styledText textBinding="HOME_ERRORS_HEADER_2@HealthResourceBundle"
                                styleClass="OraInstructionText"/>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="25%" hAlign="left" >
                        <uix:contents>
                          <uix:textInput name="agent"
                                         textBinding="agentsearchString@servletRequest"
                                         shortDescBinding="HOME_ERRORS_HEADER_2@HealthResourceBundle"/>                        
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="10%"/>
                      <uix:cellFormat width="20%" hAlign="right">
                        <uix:contents>
                          <uix:styledText textBinding="HOME_ERRORS_HEADER_5@HealthResourceBundle"
                                styleClass="OraInstructionText"/>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="25%" hAlign="left" >
                        <uix:contents>
                          <uix:textInput name="searchName"
                                         textBinding="searchString@servletRequest"
                                         shortDescBinding="HOME_ERRORS_HEADER_5@HealthResourceBundle"/>                        
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%" hAlign="left">
                    <uix:contents>
                      <uix:cellFormat width="20%"/>
                      <uix:cellFormat width="25%" hAlign="left">
                        <uix:contents>
                          <uix:submitButton name="search"
                                   textBinding="GO_BUTTON@MntrResourceBundle"
                                   value="searchVal" /> 
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="10%"/>
                      <uix:cellFormat width="20%"/>
                      <uix:cellFormat width="25%"/>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:header>
          </uix:form>

        <uix:spacer width="1"/>
           <%
             String metricErrors = defaultBean.getmetricErrorsCount();
             String metricErrorsDest = defaultBean.getmetricErrorLink();
             if (metricErrors != null)
             {
           %>
        <uix:tableLayout width="95%" cellSpacing="2">
          <uix:contents>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" width="20%">
                <uix:styledText textBinding="METRIC_COL_ERR@HealthResourceBundle" 
                    styleClass="OraInstructionText"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="1%"/>
              <uix:cellFormat hAlign="left" width="2%">
                <uix:image sourceBinding="metricErrorImage@defaultBean@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="1%"/>
              <uix:cellFormat hAlign="left" width="76%">
                <uix:styledText text="<%=metricErrors%>" 
                    styleClass="OraInstructionText"
                    destination="<%=metricErrorsDest%>"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:contents>
        </uix:tableLayout>
          <%
            }
            String disabled = defaultBean.getdisabled();
          %>
        <uix:rowLayout width="100%">
          <uix:spacer width="5" />
          <uix:tableLayout width="95%" cellSpacing="2">
            <uix:contents>
              <uix:tableLayout width="100%" cellSpacing="2">
                <uix:contents>
                  <uix:rowLayout width="100%" >
                    <uix:spacer width="3" />
                    <uix:form name="submit" method="POST" destinationBinding="Deletedestination@servletRequest">
                      <uix:formValue name="value"/>
                      <uix:formValue name="searchString"/>
                      <uix:table name="errorsTable" 
                          tableDataBinding="errorsTableData@servletRequest"
                          summaryBinding="ERRORS_TABLE_SUMMARY@HealthResourceBundle"                           
                          destinationBinding="destination@servletRequest"
                          columnHeaderDataBinding="errorsTableHeaderData@servletRequest"
                          alternateTextBinding="NO_ERRORS@HealthResourceBundle"
                          valueBinding="errorsTableValue@servletRequest"
                          minValue="1"
                          blockSize="25"
                          width="100%"
                          showAll="yes"
                          maxValueBinding="errorMaxValueInt@defaultBean@servletRequest">
                        <uix:tableSelection>
                          <uix:multipleSelection 
                              disabled="<%=disabled%>"
                              selectedBinding="selected"
                              selectionBinding="selected"
                              shortDesc="select">
                            <uix:submitButton formName="submit"
                                 name="delete" 
                                 textBinding="DELETE@HealthResourceBundle"
                                 value="delete" />
                          </uix:multipleSelection>
                        </uix:tableSelection>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader textBinding="text"
                               sortableBinding="sortable"/>
                        </uix:columnHeaderStamp>
                        <uix:styledText textBinding="component"/>
                        <uix:styledText textBinding="agent"/>
                        <uix:styledText textBinding="error_timestamp"/>
                        <uix:styledText textBinding="level"/>
                        <uix:styledText textBinding="message"/>
                      </uix:table>
                    </uix:form>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:contents>
          </uix:tableLayout >
        </uix:rowLayout >
        <uix:spacer width="15"/>        
        <uix:tableLayout width="100%" >
          <uix:rowLayout width="100%" >
            <uix:spacer width="2"/>        
          </uix:rowLayout >
          <uix:rowLayout width="100%" >
          <%
             String orientation = "bottom";
          %>
            <%@ include file="healthFaintTabs.jsp" %>        
          </uix:rowLayout >
          <%@ include file="healthRelatedLinks.jsp" %>        
          <uix:rowLayout width="100%" >
            <uix:spacer width="1"/>        
          </uix:rowLayout >
        </uix:tableLayout>
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>


