<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="consoleHome" scope="request"
             type="oracle.sysman.eml.home.ConsoleHome"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="EcmResourceBundle"
              class="oracle.sysman.eml.ecm.util.EcmResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
	<%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>

        <%-- auto refresh every 5 min
        <uix:rawText>
          <meta http-equiv="Refresh" content="300"/>
        </uix:rawText> --%>

        <%-- <uix:header textBinding="header@servletRequest"> --%>
          <uix:switcher childNameBinding="nodeValue@consoleHome@servletRequest">
            <uix:case name="okNode">
              <uix:form nameBinding="formName@consoleHome@servletRequest" 
                        method="GET">
                <uix:stackLayout>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraTipText"
                                      textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
                      <uix:spacer width="4"/>
                      <uix:styledText styleClass="OraTipLabel"
                                      textBinding="timestamp@consoleHome@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:tableLayout cellSpacing="4" width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top">
                        <uix:contentContainer background="light" width="100%">
                          <uix:stackLayout>
                            <uix:tableLayout width="100%">
                              <uix:rowLayout>
                                <uix:cellFormat>
                                  <uix:rowLayout hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="VIEW@commonResourceBundle"/>
                                    <uix:spacer width="4"/>
                                    <uix:choice name="typeChoice" id="typeChoice"
                                                selectedValueBinding="selectedTargetType@consoleHome@servletRequest"
                                                shortDescBinding="TARGET_TYPES@mntrResourceBundle"
                                                primaryClientActionBinding="onChangeTargetTypeDropBox@servletRequest">
                                      <uix:contents childDataBinding="targetTypes@consoleHome@servletRequest">
                                        <uix:option textBinding="text"
                                                    valueBinding="value"
                                                    renderedBinding="rendered"/>
                                      </uix:contents>
                                    </uix:choice>
                                    <uix:spacer width="4"/>
                                  </uix:rowLayout>
                                </uix:cellFormat>
                              </uix:rowLayout>
                            </uix:tableLayout>

                            <uix:header textBinding="GROUP_OVERVIEW@mntrResourceBundle" size="1" />
                            <uix:tableLayout>
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraFieldText" id="homePage3"
                                                  textBinding="totalMonitoredTargetsString@consoleHome@servletRequest"/>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:cellFormat hAlign="left">
                                  <uix:styledText styleClass="OraDataText" id="homePage5"
                                                  textBinding="totalMonitoredTargets@consoleHome@servletRequest"
                                                  destinationBinding="totalMonitoredTargetsDest@consoleHome@servletRequest"/>
                                </uix:cellFormat>
                              </uix:rowLayout>

                            </uix:tableLayout>

                            <uix:header textBinding="availabilityString@consoleHome@servletRequest" id="homePage1">
                              <oem:chart chartType="pieChart"
                                         width="360"
                                         height="160"
                                         shortDescBinding="availabilityString@consoleHome@servletRequest"
                                         pieValuesInLegend="value"
                                         showSlicePercentLabels="true"
                                         pieSliceColorsBinding="pieChartColors@consoleHome@servletRequest"
                                         backgroundColorBinding="pieChartBackgroundColor@consoleHome@servletRequest"
                                         hideZeroSlices="true">
                                <oem:boundChartDataSource chartDataSourceBinding="pieChartData@consoleHome@servletRequest"/>
                                <oem:imageMap imageMapItemsBinding="pieChartImageMap@consoleHome@servletRequest"/>
                                <oem:chartColumn isKey="true"
                                                 displayLabel="Availability"
                                                 sourceIndex="0"/>
                                <oem:chartColumn displayLabel="Targets"
                                                 sourceIndex="1"/>
                              </oem:chart>
                            </uix:header>

                            <uix:header textBinding="alertsString@consoleHome@servletRequest" id="homePage2" renderedBinding="fullMode@consoleHome@servletRequest">
                              <uix:tableLayout cellSpacing="2">
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="SEV_CRITICAL@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="criticalImage@servletRequest"
                                             shortDescBinding="criticalImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                    textBinding="critical@consoleHome@servletRequest"
                                                    destinationBinding="criticalDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="SEV_WARNING@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="warningImage@servletRequest"
                                             shortDescBinding="warningImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                    textBinding="warning@consoleHome@servletRequest"
                                                    destinationBinding="warningDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="ERRORS@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="metricErrorImage@servletRequest"
                                             shortDescBinding="metricErrorImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                    textBinding="metricError@consoleHome@servletRequest"
                                                    destinationBinding="metricErrorDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout  renderedBinding="showMtThresholdsBrokenCA@consoleHome@servletRequest"> 
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="BROKEN_CORRECTIVE_ACTIONS@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <%-- do we need image for Broken CA?
                                  <uix:image sourceBinding="@servletRequest"
                                             shortDescBinding="@servletRequest"/> --%>                 <uix:spacer width="8"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                    textBinding="mtThresholdsBrokenCA@consoleHome@servletRequest"
                                                    destinationBinding="mtThresholdsBrokenCADest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                 </uix:rowLayout>
                               </uix:tableLayout>
                            </uix:header>
                    
                           <%--........................ Policy Violations Rollup ...........................--%>
                            <uix:header textBinding="policyString@consoleHome@servletRequest" id="homePage6" renderedBinding="fullMode@consoleHome@servletRequest">
                              <uix:tableLayout cellSpacing="2">
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="SEV_CRITICAL@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="policyCriticalImage@servletRequest"
                                             shortDescBinding="policyCriticalImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                shortDescBinding="policyCriticalShortDesc@consoleHome@servletRequest"
                                                textBinding="policyCritical@consoleHome@servletRequest"
                                                destinationBinding="policyCriticalDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="SEV_WARNING@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="policyWarningImage@servletRequest"
                                             shortDescBinding="policyWarningImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                              shortDescBinding="policyWarningShortDesc@consoleHome@servletRequest"
                                              textBinding="policyWarning@consoleHome@servletRequest"
                                              destinationBinding="policyWarningDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="SEV_INFORMATIONAL@sdkUIMsg"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="policyInfoImage@servletRequest"
                                             shortDescBinding="policyInfoImageDesc@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                shortDescBinding="policyInfoShortDesc@consoleHome@servletRequest"
                                                textBinding="policyInfo@consoleHome@servletRequest"
                                                destinationBinding="policyInfoDest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout renderedBinding="showPolicyBrokenCA@consoleHome@servletRequest" >
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="BROKEN_CORRECTIVE_ACTIONS@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <%-- do we need image for Broken CA ?
                                  <uix:image sourceBinding="@servletRequest"
                                             shortDescBinding="@servletRequest"/> --%>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraLinkText"
                                                    shortDescBinding="policyBrokenCAShortDesc@consoleHome@servletRequest"
                                                    textBinding="policyBrokenCA@consoleHome@servletRequest"
                                                    destinationBinding="policyBrokenCADest@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                 </uix:rowLayout>
 
                              </uix:tableLayout>
                            </uix:header>
                            
                          <%--........................ Start Jobs Rollup ...........................--%>
                            <uix:header textBinding="jobHeaderString@jobStatusBean@consoleHome@servletRequest" id="homePage4" renderedBinding="fullMode@consoleHome@servletRequest">
                            <%-- uix:rowLayout>
                              <uix:styledText styleClass="OraInstructionText" 
                                              textBinding="statusInstrString@jobStatusBean@consoleHome@servletRequest"/>
                            </uix:rowLayout --%>                            

                              <uix:tableLayout cellSpacing="2">

                                <%-- Problems --%>
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="problemLabel@jobStatusBean@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="jobProblemsImgSrcHome@jobStatusBean@consoleHome@servletRequest"
                                             shortDescBinding="problemLabel@jobStatusBean@consoleHome@servletRequest"
                                             destinationBinding="jobProblemsDest@jobStatusBean@consoleHome@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="jobProblems@jobStatusBean@consoleHome@servletRequest"
                                                    destinationBinding="jobProblemsDest@jobStatusBean@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <%-- Suspended --%>
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="suspendedLabel@jobStatusBean@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:image sourceBinding="jobSuspendImgSrcHome@jobStatusBean@consoleHome@servletRequest"
                                             shortDescBinding="suspendedLabel@jobStatusBean@consoleHome@servletRequest"
                                             destinationBinding="jobSuspendDest@jobStatusBean@consoleHome@servletRequest"/>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="jobSuspend@jobStatusBean@consoleHome@servletRequest"
                                                    destinationBinding="jobSuspendDest@jobStatusBean@consoleHome@servletRequest"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                              </uix:tableLayout>
                            </uix:header>
                          <%--........................ End Jobs Rollup ...........................--%>

                          </uix:stackLayout>
                        </uix:contentContainer>
                       <uix:rowLayout renderedBinding="largeRepos@consoleHome@servletRequest">
                         <uix:cellFormat hAlign="left">
                           <uix:image sourceBinding="infoStatus@servletRequest"
                                      shortDescBinding="INFORMATION@commonResourceBundle" />
                            <uix:spacer width="8"/>
                            <uix:styledText styleClass="OraTipText" textBinding="CONSOLE_PERF_STRING@mntrResourceBundle" />
                          </uix:cellFormat>
                         </uix:rowLayout>
                      </uix:cellFormat>
  
                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:separator>
                            <uix:spacer height="4"/>
                          </uix:separator>

                          <uix:contentContainer background="light" width="100%"
                                                textBinding="TARGET_SEARCH@mntrResourceBundle">
                            <uix:contents>
                              <uix:messagePrompt rendered="false" renderedBinding="showInlineMessage@consoleHome@servletRequest"
                                                 messageTypeBinding="inlineMessageType@consoleHome@servletRequest"
                                                 promptBinding="inlineMessage@consoleHome@servletRequest"/>
                              <uix:include nodeBinding="eml.core.tgtSrch.UINode@servletRequest"/>
                            </uix:contents>
                          </uix:contentContainer>

			  <uix:contentContainer background="light" width="100%" renderedBinding="fullMode@consoleHome@servletRequest">
						<uix:include nodeBinding="emHomeData@SecInfo@servletRequest"/>

						<uix:header textBinding="CRITICAL_PATCH@mntrResourceBundle">
						<uix:contents>
							<uix:include nodeBinding="EcmPatch@servletRequest"/>
						</uix:contents>
				</uix:header>
				</uix:contentContainer>
				<uix:contentContainer background="light" width="100%">
			    <uix:header textBinding="ENTERPRISE_CONFIGURATION@mntrResourceBundle">
				<uix:contents>
				<uix:include nodeBinding="EcmInv@servletRequest"/>
				</uix:contents>
		            </uix:header>
                          </uix:contentContainer>

                          <uix:contentContainer background="light" width="100%"
                                                textBinding="RESOURCE_CENTER@mntrResourceBundle">
                            <uix:stackLayout>
                              <uix:link textBinding="DOCUMENTATION@mntrResourceBundle"
                                        destination="<%= consoleHome.selectHelpTopicsValue(renderingContext, \"oemtop_related_docs\") %>" />
                              <uix:link textBinding="RELEASE_NOTES@mntrResourceBundle"
                                        destinationBinding="releaseNotesDest@consoleHome@servletRequest"
                                        targetFrame="_blank"/>
                              <uix:link textBinding="SUPPORT@mntrResourceBundle"
                                        destination="http://www.oracle.com/support/"
                                        targetFrame="_blank"/>
                              <uix:link textBinding="ORACLE_TECHNOLOGY_NETWORK@mntrResourceBundle"
                                        destination="http://technet.oracle.com/products/oem/content.html"
                                        targetFrame="_blank"/>
                            </uix:stackLayout>
                          </uix:contentContainer>
                        </uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:stackLayout>
              </uix:form>
            </uix:case>

            <uix:case name="errNode">
              <uix:messageBox messageBinding="errorMessage@consoleHome@servletRequest"
                              messageType="error"
                              shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                              textBinding="ERR_OCCUR@mntrResourceBundle">
              </uix:messageBox>
            </uix:case>
          </uix:switcher>
        <%-- </uix:header> --%>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
