<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        addCategory.jsp
  -- Controller:  eml/ip/ui/edit/IPAddCategoryController.java
  -- Bean:        addCategoryUIBean:  eml.ip.ui.edit.AddCategoryUIBean
  --
  -- Description: Category Addition for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ip.IPConstants"%>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrResourceBundle" 
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@addCategoryUIBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="loadIt()">

<%-- HTML Form --%>
    <uix:form name="addCategoryForm" 
              method="POST"
              destinationBinding="formDestination@addCategoryUIBean@servletRequest">
      <uix:pageLayout titleBinding="prompt@addCategoryUIBean@servletRequest">
       <%@ include file="/oemGlobal.jspf" %>

       <uix:pageButtons>
         <uix:pageButtonBar>
           <uix:rowLayout rendered="true"
                          renderedBinding="showContents@cacheLoss@servletRequest">
             <uix:submitButton textBinding="CANCEL@ipBundle" 
                               name="event" 
                               value="cancel"/>
             <uix:spacer height="3"/>                  
             <uix:submitButton textBinding="CONTINUE@ipBundle" 
                               name="event" 
                               value="Add"/>
           </uix:rowLayout>                 
         </uix:pageButtonBar>
       </uix:pageButtons>
        
       <uix:contents>
        <%-- cache loss --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="showCacheLoss@cacheLoss@servletRequest">
           <uix:contents>
             <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                             messageType="error"
                             textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
             <uix:spacer height="10"/>
             <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                             destinationBinding="restartDest@cacheLoss@servletRequest"/>
           </uix:contents>
        </uix:stackLayout>

        <%-- content --%>
            <uix:messageTextInput name="nameInputText"
                promptBinding="NAME@ipBundle"
                required="no"
                id="nameInputText"
                columns="60"
                maximumLength="<%=IPConstants.TABLE_MAX_CATEGORY_LENGTH%>"
                textBinding="nameText@addCategoryUIBean@servletRequest"
                rendered="true"
                renderedBinding="showContents@cacheLoss@servletRequest"/>
            <uix:spacer width="5" />

          <uix:formValue
            name="event"
            value="Add"/>
 
          <script>
            function loadIt()
            {
              document.addCategoryForm.nameInputText.focus();
              document.addCategoryForm.nameInputText.select();
            }
          </script>

        </uix:contents>

       </uix:pageLayout>
      </uix:form>
    </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



